/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.components;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mobac.utilities.I18nUtils;
import mobac.utilities.Utilities;
import mobac.utilities.geo.CoordinateDms2Format;

public class JCoordinateField
extends JTextField {
    private static final long serialVersionUID = 1L;
    private static final Color ERROR_COLOR = new Color(255, 100, 100);
    private static final String INVALID_TEXT = I18nUtils.localizedStringForKey("lp_coords_invalid_text", new Object[0]);
    private JCoordinateListener coordinateListener;
    private boolean inputIsValid = true;
    private NumberFormat numberFormat;
    private final double min;
    private final double max;

    public JCoordinateField(double min, double max) {
        super(10);
        this.min = min;
        this.max = max;
        this.numberFormat = new CoordinateDms2Format(new DecimalFormatSymbols());
        this.coordinateListener = new JCoordinateListener();
        this.coordinateListener.checkCoordinate(null);
    }

    public Point getToolTipLocation(MouseEvent event) {
        if (this.getToolTipText().length() > 0) {
            return super.getToolTipLocation(event);
        }
        return new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoordinate(double value) {
        try {
            boolean newValid = true;
            this.coordinateListener.setEnabled(false);
            if (Double.isNaN(value)) {
                super.setText("");
                newValid = false;
            } else {
                super.setText(this.numberFormat.format(value));
            }
            if (newValid != this.inputIsValid) {
                this.coordinateListener.changeValidMode(true);
            }
        }
        finally {
            this.coordinateListener.setEnabled(true);
        }
    }

    public double getCoordinate() throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        String text = this.getText();
        Number num = this.numberFormat.parse(text, pos);
        if (num == null || pos.getErrorIndex() >= 0 || Double.isNaN(num.doubleValue())) {
            throw new ParseException(text, pos.getErrorIndex());
        }
        return num.doubleValue();
    }

    public double getCoordinateOrNaN() {
        ParsePosition pos = new ParsePosition(0);
        String text = this.getText();
        Number num = this.numberFormat.parse(text, pos);
        if (num == null || pos.getErrorIndex() >= 0) {
            return Double.NaN;
        }
        return num.doubleValue();
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        double coord = this.getCoordinateOrNaN();
        this.numberFormat = numberFormat;
        this.setCoordinate(coord);
    }

    protected class JCoordinateListener
    implements DocumentListener {
        private Color defaultColor;
        private boolean enabled = true;

        private JCoordinateListener() {
            this.defaultColor = JCoordinateField.this.getBackground();
            JCoordinateField.this.getDocument().addDocumentListener(this);
        }

        private void checkCoordinate(DocumentEvent de) {
            if (!this.enabled) {
                return;
            }
            boolean valid = false;
            try {
                ParsePosition pos = new ParsePosition(0);
                String text = JCoordinateField.this.getText();
                Number num = JCoordinateField.this.numberFormat.parse(text, pos);
                if (num == null) {
                    valid = false;
                    return;
                }
                double d = num.doubleValue();
                valid = !Double.isNaN(d) && d >= JCoordinateField.this.min && d <= JCoordinateField.this.max;
            }
            catch (Exception e) {
                valid = false;
            }
            if (valid != JCoordinateField.this.inputIsValid) {
                this.changeValidMode(valid);
            }
        }

        private void changeValidMode(boolean valid) {
            Color newC = valid ? this.defaultColor : ERROR_COLOR;
            JCoordinateField.this.setBackground(newC);
            String toolTip = valid ? "" : String.format(INVALID_TEXT, JCoordinateField.this.numberFormat.format(JCoordinateField.this.min), JCoordinateField.this.numberFormat.format(JCoordinateField.this.max));
            JCoordinateField.this.setToolTipText(toolTip);
            if (toolTip.length() > 0) {
                Utilities.showTooltipNow(JCoordinateField.this);
            }
            JCoordinateField.this.inputIsValid = valid;
        }

        public void changedUpdate(DocumentEvent e) {
            this.checkCoordinate(e);
        }

        public void insertUpdate(DocumentEvent e) {
            this.checkCoordinate(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.checkCoordinate(e);
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

