/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.actions;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.xml.bind.JAXBException;
import mobac.data.gpx.GPXUtils;
import mobac.data.gpx.gpx11.Gpx;
import mobac.gui.MainGUI;
import mobac.gui.mapview.layer.GpxLayer;
import mobac.gui.panels.JGpxPanel;
import mobac.program.model.Settings;
import mobac.utilities.I18nUtils;
import mobac.utilities.file.GpxFileFilter;
import org.apache.log4j.Logger;

public class GpxLoad
implements ActionListener {
    private Logger log = Logger.getLogger(GpxLoad.class);
    JGpxPanel panel;

    public GpxLoad(JGpxPanel panel) {
        this.panel = panel;
    }

    public void actionPerformed(ActionEvent event) {
        int answer;
        File selectedFile;
        if (!GPXUtils.checkJAXBVersion()) {
            return;
        }
        JFileChooser fc = new JFileChooser();
        try {
            File dir = new File(Settings.getInstance().gpxFileChooserDir);
            fc.setCurrentDirectory(dir);
        }
        catch (Exception e) {
            // empty catch block
        }
        fc.setMultiSelectionEnabled(true);
        fc.addChoosableFileFilter(new GpxFileFilter(false));
        MainGUI mainGUI = MainGUI.getMainGUI();
        int returnVal = fc.showOpenDialog(mainGUI);
        if (returnVal != 0) {
            return;
        }
        Settings.getInstance().gpxFileChooserDir = fc.getCurrentDirectory().getAbsolutePath();
        File[] f = fc.getSelectedFiles();
        boolean duplicates = false;
        File[] arr$ = f;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(duplicates = this.panel.isFileOpen((selectedFile = arr$[i$]).getAbsolutePath())); ++i$) {
        }
        if (duplicates && (answer = JOptionPane.showConfirmDialog(mainGUI, I18nUtils.localizedStringForKey("rp_gpx_msg_confirm_reopen_file", new Object[0]), I18nUtils.localizedStringForKey("Warning", new Object[0]), 0, 3)) != 0) {
            return;
        }
        if (f.length > 1) {
            this.doMultiLoad(f, mainGUI);
        } else if (f.length == 1) {
            this.doLoad(f[0], mainGUI);
        }
        mainGUI.previewMap.refreshMap();
    }

    private void doLoad(File f, Component parent) {
        try {
            Gpx gpx = GPXUtils.loadGpxFile(f);
            GpxLayer gpxLayer = new GpxLayer(gpx);
            gpxLayer.setFile(f);
            this.panel.addGpxLayer(gpxLayer);
        }
        catch (JAXBException e) {
            JOptionPane.showMessageDialog(parent, "<html>Unable to load the GPX file <br><i>" + f.getAbsolutePath() + "</i><br><br><b>Please make sure the file is a valid GPX v1.1 file.</b><br>" + "<br>Internal error message:<br>" + e.getMessage() + "</html>", "GPX loading failed", 0);
            throw new RuntimeException(e);
        }
    }

    private void doMultiLoad(final File[] files, final MainGUI mainGUI) {
        final JDialog progressDialog = new JDialog(mainGUI);
        progressDialog.setSize(400, 50);
        progressDialog.setResizable(false);
        progressDialog.setDefaultCloseOperation(0);
        progressDialog.setLocation(Math.max(0, (int)(mainGUI.getLocation().getX() + mainGUI.getSize().getWidth() / 2.0 - 200.0)), Math.max(0, (int)(mainGUI.getLocation().getY() + mainGUI.getSize().getHeight() / 2.0 - 25.0)));
        final JProgressBar progressBar = new JProgressBar(0, files.length);
        progressDialog.add(progressBar);
        mainGUI.setCursor(Cursor.getPredefinedCursor(3));
        mainGUI.setEnabled(false);
        progressDialog.setVisible(true);
        Thread job = new Thread(){
            private int counter = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    for (final File file : files) {
                        ++this.counter;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                progressBar.setValue(counter);
                                progressDialog.setTitle("Processing " + counter + " of " + files.length + " <" + file.getName() + ">");
                            }
                        });
                        GpxLoad.this.doLoad(file, progressDialog);
                    }
                }
                catch (RuntimeException e) {
                    try {
                        GpxLoad.this.log.error(e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                mainGUI.previewMap.repaint();
                                mainGUI.setCursor(Cursor.getDefaultCursor());
                                if (progressDialog != null) {
                                    progressDialog.setVisible(false);
                                    progressDialog.dispose();
                                }
                                mainGUI.setEnabled(true);
                                mainGUI.toFront();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        job.start();
    }
}

