/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.actions;

import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JOptionPane;
import mobac.data.gpx.gpx11.TrkType;
import mobac.data.gpx.gpx11.TrksegType;
import mobac.data.gpx.gpx11.WptType;
import mobac.data.gpx.interfaces.GpxPoint;
import mobac.exceptions.InvalidNameException;
import mobac.gui.MainGUI;
import mobac.gui.atlastree.JAtlasTree;
import mobac.gui.gpxtree.GpxEntry;
import mobac.gui.gpxtree.GpxRootEntry;
import mobac.gui.gpxtree.TrkEntry;
import mobac.gui.gpxtree.TrksegEntry;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.model.EastNorthCoordinate;
import mobac.program.model.Layer;
import mobac.program.model.MapPolygon;
import mobac.program.model.SelectedZoomLevels;
import mobac.program.model.Settings;
import mobac.program.model.TileImageParameters;
import mobac.utilities.I18nUtils;

public class AddGpxTrackAreaPolygonMap
implements ActionListener {
    public static final AddGpxTrackAreaPolygonMap INSTANCE = new AddGpxTrackAreaPolygonMap();

    public void actionPerformed(ActionEvent event) {
        String msg;
        int result;
        MainGUI mg = MainGUI.getMainGUI();
        GpxEntry entry = mg.gpxPanel.getSelectedEntry();
        if (entry == null) {
            return;
        }
        TrksegType trk = null;
        TrkType t = null;
        if (entry instanceof TrksegEntry) {
            trk = ((TrksegEntry)entry).getTrkSeg();
        } else if (entry instanceof GpxRootEntry) {
            GpxRootEntry re = (GpxRootEntry)entry;
            List<TrkType> tlist = re.getLayer().getGpx().getTrk();
            if (tlist.size() > 1) {
                JOptionPane.showMessageDialog(mg, I18nUtils.localizedStringForKey("msg_add_gpx_polygon_too_many_track", new Object[0]));
                return;
            }
            if (tlist.size() == 1) {
                t = tlist.get(0);
            }
        }
        if (entry instanceof TrkEntry) {
            t = ((TrkEntry)entry).getTrk();
        }
        if (t != null) {
            if (t.getTrkseg().size() > 1) {
                JOptionPane.showMessageDialog(mg, I18nUtils.localizedStringForKey("msg_add_gpx_polygon_too_many_segment", new Object[0]));
                return;
            }
            if (t.getTrkseg().size() == 1) {
                trk = t.getTrkseg().get(0);
            }
        }
        if (trk == null) {
            JOptionPane.showMessageDialog(mg, I18nUtils.localizedStringForKey("msg_add_gpx_polygon_no_select", new Object[0]), I18nUtils.localizedStringForKey("Error", new Object[0]), 0);
            return;
        }
        JAtlasTree jAtlasTree = mg.jAtlasTree;
        String mapNameFmt = "%s %02d";
        AtlasInterface atlasInterface = jAtlasTree.getAtlas();
        String name = mg.getUserText();
        MapSource mapSource = mg.getSelectedMapSource();
        SelectedZoomLevels sZL = mg.getSelectedZoomLevels();
        int[] zoomLevels = sZL.getZoomLevels();
        if (zoomLevels.length == 0) {
            JOptionPane.showMessageDialog(mg, I18nUtils.localizedStringForKey("msg_no_zoom_level_selected", new Object[0]));
            return;
        }
        List<WptType> points = trk.getTrkpt();
        EastNorthCoordinate[] trackPoints = new EastNorthCoordinate[points.size()];
        EastNorthCoordinate minCoordinate = new EastNorthCoordinate(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        EastNorthCoordinate maxCoordinate = new EastNorthCoordinate(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (int i = 0; i < trackPoints.length; ++i) {
            GpxPoint gpxPoint = points.get(i);
            EastNorthCoordinate c = new EastNorthCoordinate(gpxPoint.getLat().doubleValue(), gpxPoint.getLon().doubleValue());
            minCoordinate.lat = Math.min(minCoordinate.lat, c.lat);
            minCoordinate.lon = Math.min(minCoordinate.lon, c.lon);
            maxCoordinate.lat = Math.max(maxCoordinate.lat, c.lat);
            maxCoordinate.lon = Math.max(maxCoordinate.lon, c.lon);
            trackPoints[i] = c;
        }
        int maxZoom = zoomLevels[zoomLevels.length - 1];
        MapSpace mapSpace = mapSource.getMapSpace();
        String layerName = name;
        int c = 1;
        Layer layer = null;
        boolean success = false;
        do {
            try {
                layer = new Layer(atlasInterface, layerName);
                success = true;
            }
            catch (InvalidNameException e) {
                layerName = name + "_" + Integer.toString(c++);
            }
        } while (!success);
        TileImageParameters customTileParameters = mg.getSelectedTileImageParameters();
        int[] xPoints = new int[trackPoints.length];
        int[] yPoints = new int[trackPoints.length];
        for (int i = 0; i < trackPoints.length; ++i) {
            EastNorthCoordinate coord = trackPoints[i];
            xPoints[i] = mapSpace.cLonToX(coord.lon, maxZoom);
            yPoints[i] = mapSpace.cLatToY(coord.lat, maxZoom);
        }
        Polygon p = new Polygon(xPoints, yPoints, xPoints.length);
        MapPolygon maxZoomMap = new MapPolygon(null, "Dummy", mapSource, maxZoom, p, customTileParameters);
        int width = maxZoomMap.getMaxTileCoordinate().x - maxZoomMap.getMinTileCoordinate().x;
        int height = maxZoomMap.getMaxTileCoordinate().y - maxZoomMap.getMinTileCoordinate().y;
        if (Math.max(width, height) > Settings.getInstance().maxMapSize && (result = JOptionPane.showConfirmDialog(mg, msg = I18nUtils.localizedStringForKey("msg_add_gpx_polygon_maxsize", new Object[0]), I18nUtils.localizedStringForKey("msg_add_gpx_polygon_maxsize_title", new Object[0]), 0, 3)) != 0) {
            return;
        }
        for (int zoom : zoomLevels) {
            String mapName = String.format("%s %02d", layerName, zoom);
            MapPolygon map = MapPolygon.createFromMapPolygon(layer, mapName, zoom, maxZoomMap);
            layer.addMap(map);
        }
        atlasInterface.addLayer(layer);
        mg.jAtlasTree.getTreeModel().notifyNodeInsert(layer);
    }
}

