/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import mobac.gui.MainGUI;
import mobac.program.AtlasThread;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSourceListener;
import mobac.program.model.AtlasOutputFormat;
import mobac.program.model.Settings;
import mobac.utilities.GBC;
import mobac.utilities.I18nUtils;
import mobac.utilities.OSUtilities;
import mobac.utilities.Utilities;
import org.apache.log4j.Logger;

public class AtlasProgress
extends JFrame
implements ActionListener,
MapSourceListener {
    private static Logger log = Logger.getLogger(AtlasProgress.class);
    private static final long serialVersionUID = -1L;
    private static final Timer TIMER = new Timer(true);
    private JProgressBar atlasProgressBar;
    private JProgressBar mapDownloadProgressBar;
    private JProgressBar mapCreationProgressBar;
    private Container background;
    private long initialTotalTime;
    private long initialMapDownloadTime;
    private final Data data = new Data();
    private boolean aborted = false;
    private boolean finished = false;
    private JLabel windowTitle;
    private JLabel title;
    private JLabel mapInfoLabel;
    private JLabel mapDownloadTitle;
    private JLabel atlasPercent;
    private JLabel mapDownloadPercent;
    private JLabel atlasMapsDone;
    private JLabel mapDownloadElementsDone;
    private JLabel atlasTimeLeft;
    private JLabel mapDownloadTimeLeft;
    private JLabel mapCreation;
    private JLabel nrOfDownloadedBytes;
    private JLabel nrOfDownloadedBytesValue;
    private JLabel nrOfDownloadedBytesPerSecond;
    private JLabel nrOfDownloadedBytesPerSecondValue;
    private JLabel nrOfCacheBytes;
    private JLabel nrOfCacheBytesValue;
    private JLabel activeDownloads;
    private JLabel activeDownloadsValue;
    private JLabel retryableDownloadErrors;
    private JLabel retryableDownloadErrorsValue;
    private JLabel permanentDownloadErrors;
    private JLabel permanentDownloadErrorsValue;
    private JLabel totalDownloadTime;
    private JLabel totalDownloadTimeValue;
    private JCheckBox ignoreDlErrors;
    private JLabel statusLabel;
    private JButton dismissWindowButton;
    private JButton openProgramFolderButton;
    private JButton abortAtlasCreationButton;
    private JButton pauseResumeDownloadButton;
    private AtlasCreationController downloadControlListener = null;
    private UpdateTask updateTask = null;
    private GUIUpdater guiUpdater = null;
    private AtlasThread atlasThread;
    private ArrayList<MapInfo> mapInfos = null;
    private static String TEXT_MAP_DOWNLOAD = I18nUtils.localizedStringForKey("dlg_download_zoom_level_progress", new Object[0]);
    private static String TEXT_PERCENT = I18nUtils.localizedStringForKey("dlg_download_done_percent", new Object[0]);
    private static String TEXT_TENTHPERCENT = I18nUtils.localizedStringForKey("dlg_download_done_tenthpercent", new Object[0]);

    public AtlasProgress(AtlasThread atlasThread) {
        super(I18nUtils.localizedStringForKey("dlg_download_title", new Object[0]));
        this.atlasThread = atlasThread;
        ToolTipManager.sharedInstance().setDismissDelay(12000);
        if (MainGUI.getMainGUI() == null) {
            this.setDefaultCloseOperation(3);
        } else {
            this.setDefaultCloseOperation(2);
        }
        this.setIconImages(MainGUI.MOBAC_ICONS);
        this.setLayout(new GridBagLayout());
        this.updateTask = new UpdateTask();
        this.guiUpdater = new GUIUpdater();
        this.createComponents();
        this.pack();
        this.guiUpdater.run();
        this.background.setLayout(null);
        this.setResizable(false);
        Dimension dScreen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dContent = this.getSize();
        this.setLocation((dScreen.width - dContent.width) / 2, (dScreen.height - dContent.height) / 2);
        this.initialTotalTime = System.currentTimeMillis();
        this.initialMapDownloadTime = System.currentTimeMillis();
        this.addWindowListener(new CloseListener());
    }

    private void createComponents() {
        this.background = new JPanel(new GridBagLayout());
        this.windowTitle = new JLabel(I18nUtils.localizedStringForKey("dlg_download_window_title", new Object[0]));
        this.title = new JLabel(I18nUtils.localizedStringForKey("dlg_download_map_progress", new Object[0]));
        this.mapInfoLabel = new JLabel();
        this.atlasMapsDone = new JLabel(I18nUtils.localizedStringForKey("dlg_download_map_done_count_default", new Object[0]));
        this.atlasPercent = new JLabel(String.format(TEXT_TENTHPERCENT, 100.0));
        this.atlasTimeLeft = new JLabel(I18nUtils.localizedStringForKey("dlg_download_remain_time_default", new Object[0]), 4);
        this.atlasProgressBar = new JProgressBar();
        this.mapDownloadTitle = new JLabel(TEXT_MAP_DOWNLOAD + "000");
        this.mapDownloadElementsDone = new JLabel(I18nUtils.localizedStringForKey("dlg_download_tile_done_count_default", new Object[0]));
        this.mapDownloadPercent = new JLabel(String.format(TEXT_PERCENT, 100));
        this.mapDownloadTimeLeft = new JLabel(I18nUtils.localizedStringForKey("dlg_download_remain_time_default", new Object[0]), 4);
        this.mapDownloadProgressBar = new JProgressBar();
        this.mapCreation = new JLabel(I18nUtils.localizedStringForKey("dlg_download_map_create_title", new Object[0]));
        this.mapCreationProgressBar = new JProgressBar();
        this.nrOfDownloadedBytesPerSecond = new JLabel(I18nUtils.localizedStringForKey("dlg_download_avg_speed", new Object[0]));
        this.nrOfDownloadedBytesPerSecondValue = new JLabel();
        this.nrOfDownloadedBytes = new JLabel(I18nUtils.localizedStringForKey("dlg_download_total_bytes", new Object[0]));
        this.nrOfDownloadedBytesValue = new JLabel();
        this.nrOfCacheBytes = new JLabel(I18nUtils.localizedStringForKey("dlg_download_bytes_from_cache", new Object[0]));
        this.nrOfCacheBytesValue = new JLabel();
        this.activeDownloads = new JLabel(I18nUtils.localizedStringForKey("dlg_download_thread_count", new Object[0]));
        this.activeDownloadsValue = new JLabel();
        this.retryableDownloadErrors = new JLabel(I18nUtils.localizedStringForKey("dlg_download_retry_count", new Object[0]));
        this.retryableDownloadErrors.setToolTipText(I18nUtils.localizedStringForKey("dlg_download_error_tips", new Object[0]));
        this.retryableDownloadErrorsValue = new JLabel();
        this.retryableDownloadErrorsValue.setToolTipText(this.retryableDownloadErrors.getToolTipText());
        this.permanentDownloadErrors = new JLabel(I18nUtils.localizedStringForKey("dlg_download_failed_count", new Object[0]));
        this.permanentDownloadErrors.setToolTipText(I18nUtils.localizedStringForKey("dlg_download_error_tips", new Object[0]));
        this.permanentDownloadErrorsValue = new JLabel();
        this.permanentDownloadErrorsValue.setToolTipText(this.permanentDownloadErrors.getToolTipText());
        this.totalDownloadTime = new JLabel(I18nUtils.localizedStringForKey("dlg_download_total_time", new Object[0]));
        this.totalDownloadTimeValue = new JLabel();
        this.ignoreDlErrors = new JCheckBox(I18nUtils.localizedStringForKey("dlg_download_checkbox_ignore_error", new Object[0]), Settings.getInstance().ignoreDlErrors);
        this.statusLabel = new JLabel(I18nUtils.localizedStringForKey("dlg_download_status_title", new Object[0]));
        Font f = this.statusLabel.getFont();
        this.statusLabel.setFont(f.deriveFont(1));
        this.abortAtlasCreationButton = new JButton(I18nUtils.localizedStringForKey("dlg_download_btn_abort", new Object[0]));
        this.abortAtlasCreationButton.setToolTipText(I18nUtils.localizedStringForKey("dlg_download_btn_abort_tips", new Object[0]));
        this.dismissWindowButton = new JButton(I18nUtils.localizedStringForKey("dlg_download_btn_close_win", new Object[0]));
        this.dismissWindowButton.setToolTipText(I18nUtils.localizedStringForKey("dlg_download_btn_close_win_tips_disable", new Object[0]));
        this.dismissWindowButton.setVisible(false);
        this.openProgramFolderButton = new JButton(I18nUtils.localizedStringForKey("dlg_download_btn_open_folder", new Object[0]));
        this.openProgramFolderButton.setToolTipText(I18nUtils.localizedStringForKey("dlg_download_btn_open_folder_tips_disabled", new Object[0]));
        this.openProgramFolderButton.setEnabled(false);
        this.pauseResumeDownloadButton = new JButton(I18nUtils.localizedStringForKey("dlg_download_btn_pause_resume", new Object[0]));
        GBC gbcRIF = GBC.std().insets(0, 0, 20, 0).fill(2);
        GBC gbcEol = GBC.eol();
        GBC gbcEolFill = GBC.eol().fill(2);
        GBC gbcEolFillI = GBC.eol().fill(2).insets(0, 5, 0, 0);
        this.background.add((Component)this.mapInfoLabel, gbcEolFill);
        this.background.add(Box.createVerticalStrut(20), gbcEol);
        this.background.add((Component)this.title, gbcRIF);
        this.background.add((Component)this.atlasMapsDone, gbcRIF);
        this.background.add((Component)this.atlasPercent, gbcRIF);
        this.background.add((Component)this.atlasTimeLeft, gbcEolFill);
        this.background.add((Component)this.atlasProgressBar, gbcEolFillI);
        this.background.add(Box.createVerticalStrut(20), gbcEol);
        this.background.add((Component)this.mapDownloadTitle, gbcRIF);
        this.background.add((Component)this.mapDownloadElementsDone, gbcRIF);
        this.background.add((Component)this.mapDownloadPercent, gbcRIF);
        this.background.add((Component)this.mapDownloadTimeLeft, gbcEolFill);
        this.background.add((Component)this.mapDownloadProgressBar, gbcEolFillI);
        this.background.add(Box.createVerticalStrut(20), gbcEol);
        this.background.add((Component)this.mapCreation, gbcEol);
        this.background.add((Component)this.mapCreationProgressBar, gbcEolFillI);
        this.background.add(Box.createVerticalStrut(10), gbcEol);
        JPanel infoPanel = new JPanel(new GridBagLayout());
        GBC gbci = GBC.std().insets(0, 3, 3, 3);
        infoPanel.add((Component)this.nrOfDownloadedBytes, gbci);
        infoPanel.add((Component)this.nrOfDownloadedBytesValue, gbci.toggleEol());
        infoPanel.add((Component)this.nrOfCacheBytes, gbci.toggleEol());
        infoPanel.add((Component)this.nrOfCacheBytesValue, gbci.toggleEol());
        infoPanel.add((Component)this.nrOfDownloadedBytesPerSecond, gbci.toggleEol());
        infoPanel.add((Component)this.nrOfDownloadedBytesPerSecondValue, gbci.toggleEol());
        infoPanel.add((Component)this.activeDownloads, gbci.toggleEol());
        infoPanel.add((Component)this.activeDownloadsValue, gbci.toggleEol());
        infoPanel.add((Component)this.retryableDownloadErrors, gbci.toggleEol());
        infoPanel.add((Component)this.retryableDownloadErrorsValue, gbci.toggleEol());
        infoPanel.add((Component)this.permanentDownloadErrors, gbci.toggleEol());
        infoPanel.add((Component)this.permanentDownloadErrorsValue, gbci.toggleEol());
        infoPanel.add((Component)this.totalDownloadTime, gbci.toggleEol());
        infoPanel.add((Component)this.totalDownloadTimeValue, gbci.toggleEol());
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        bottomPanel.add((Component)infoPanel, GBC.std().gridheight(2).fillH());
        bottomPanel.add((Component)this.ignoreDlErrors, GBC.eol().anchor(13));
        bottomPanel.add((Component)this.statusLabel, GBC.eol().anchor(10));
        GBC gbcRight = GBC.std().anchor(14).insets(5, 0, 0, 0);
        bottomPanel.add(Box.createHorizontalGlue(), GBC.std().fill(2));
        bottomPanel.add((Component)this.abortAtlasCreationButton, gbcRight);
        bottomPanel.add((Component)this.dismissWindowButton, gbcRight);
        bottomPanel.add((Component)this.pauseResumeDownloadButton, gbcRight);
        bottomPanel.add((Component)this.openProgramFolderButton, gbcRight);
        this.background.add((Component)bottomPanel, gbcEolFillI);
        JPanel borderPanel = new JPanel(new GridBagLayout());
        borderPanel.add((Component)this.background, GBC.std().insets(10, 10, 10, 10).fill());
        this.add((Component)borderPanel, GBC.std().fill());
        this.abortAtlasCreationButton.addActionListener(this);
        this.dismissWindowButton.addActionListener(this);
        this.openProgramFolderButton.addActionListener(this);
        this.pauseResumeDownloadButton.addActionListener(this);
    }

    public void initAtlas(AtlasInterface atlasInterface) {
        this.data.atlasInterface = atlasInterface;
        this.data.totalNumberOfTiles = atlasInterface.getOutputFormat().equals(AtlasOutputFormat.TILESTORE) ? (int)atlasInterface.calculateTilesToDownload() : (int)atlasInterface.calculateTilesToDownload() * 2;
        int mapCount = 0;
        int tileCount = 0;
        this.mapInfos = new ArrayList(100);
        for (LayerInterface layer : atlasInterface) {
            mapCount += layer.getMapCount();
            for (MapInterface map : layer) {
                int before = tileCount;
                int mapTiles = (int)map.calculateTilesToDownload();
                this.mapInfos.add(new MapInfo(map, before, tileCount += mapTiles + mapTiles));
            }
        }
        this.mapInfos.trimToSize();
        this.data.totalNumberOfMaps = mapCount;
        this.initialTotalTime = System.currentTimeMillis();
        this.initialMapDownloadTime = -1L;
        this.updateGUI();
        this.setVisible(true);
        TIMER.schedule((TimerTask)this.updateTask, 0L, 500L);
    }

    public void initMapDownload(MapInterface map) {
        int index = this.mapInfos.indexOf(new MapInfo(map, 0, 0));
        this.data.mapInfo = this.mapInfos.get(index);
        this.data.totalProgress = this.data.mapInfo.tileCountOnStart;
        this.data.map = map;
        this.data.mapDownloadNumberOfTiles = (int)map.calculateTilesToDownload();
        this.initialMapDownloadTime = System.currentTimeMillis();
        this.data.prevMapsPermanentErrors += this.data.mapPermanentErrors;
        this.data.prevMapsRetryErrors += this.data.mapRetryErrors;
        this.data.mapCreationProgress = 0;
        this.data.mapDownloadProgress = 0;
        this.data.currentMapNumber = index + 1;
        this.updateGUI();
    }

    public void initMapCreation(int maxTilesToProcess) {
        this.data.mapCreationProgress = 0;
        this.data.mapCreationMax = maxTilesToProcess;
        this.initialMapDownloadTime = -1L;
        this.updateGUI();
    }

    public void setErrorCounter(int retryErrors, int permanentErrors) {
        this.data.mapRetryErrors = retryErrors;
        this.data.mapPermanentErrors = permanentErrors;
        this.updateGUI();
    }

    public void incMapDownloadProgress() {
        ++this.data.mapDownloadProgress;
        ++this.data.totalProgress;
        this.updateGUI();
    }

    public void incMapCreationProgress() {
        this.setMapCreationProgress(this.data.mapCreationProgress + 1);
    }

    public void incMapCreationProgress(int stepSize) {
        this.setMapCreationProgress(this.data.mapCreationProgress + stepSize);
    }

    public void setMapCreationProgress(int progress) {
        this.data.mapCreationProgress = progress;
        this.data.totalProgress = this.data.mapInfo.tileCountOnStart + this.data.mapInfo.mapTiles + (int)((long)this.data.mapInfo.mapTiles * (long)this.data.mapCreationProgress / (long)this.data.mapCreationMax);
        this.updateGUI();
    }

    public boolean ignoreDownloadErrors() {
        return this.ignoreDlErrors.isSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tileDownloaded(int size) {
        Data data = this.data;
        synchronized (data) {
            this.data.numberOfDownloadedBytes += (long)size;
        }
        this.updateGUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tileLoadedFromCache(int size) {
        Data data = this.data;
        synchronized (data) {
            this.data.numberOfBytesLoadedFromCache += (long)size;
        }
        this.updateGUI();
    }

    private String formatTime(long longSeconds) {
        String timeString = "";
        if (longSeconds < 0L) {
            timeString = I18nUtils.localizedStringForKey("dlg_download_time_unknown", new Object[0]);
        } else {
            int minutes = (int)(longSeconds / 60L);
            int seconds = (int)(longSeconds % 60L);
            if (minutes > 0) {
                timeString = timeString + Integer.toString(minutes) + " " + (minutes == 1 ? I18nUtils.localizedStringForKey("minute", new Object[0]) : I18nUtils.localizedStringForKey("minutes", new Object[0])) + " ";
            }
            timeString = timeString + Integer.toString(seconds) + " " + (seconds == 1 ? I18nUtils.localizedStringForKey("second", new Object[0]) : I18nUtils.localizedStringForKey("seconds", new Object[0]));
        }
        return timeString;
    }

    public void setZoomLevel(int theZoomLevel) {
        this.mapDownloadTitle.setText(TEXT_MAP_DOWNLOAD + Integer.toString(theZoomLevel));
    }

    public void atlasCreationFinished() {
        this.finished = true;
        this.stopUpdateTask();
        this.forceUpdateGUI();
        this.downloadControlListener = null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AtlasProgress.this.abortAtlasCreationButton.setEnabled(false);
                if (AtlasProgress.this.aborted) {
                    AtlasProgress.this.windowTitle.setText(I18nUtils.localizedStringForKey("dlg_download_abort_window_title", new Object[0]));
                    AtlasProgress.this.setTitle(I18nUtils.localizedStringForKey("dlg_download_abort_title", new Object[0]));
                } else {
                    AtlasProgress.this.windowTitle.setText(I18nUtils.localizedStringForKey("dlg_download_succeed_window_title", new Object[0]));
                    AtlasProgress.this.setTitle(I18nUtils.localizedStringForKey("dlg_download_succeed_title", new Object[0]));
                }
                AtlasProgress.this.atlasMapsDone.setText(String.format(I18nUtils.localizedStringForKey("dlg_download_map_done_count", new Object[0]), ((AtlasProgress)AtlasProgress.this).data.currentMapNumber, ((AtlasProgress)AtlasProgress.this).data.totalNumberOfMaps));
                AtlasProgress.this.abortAtlasCreationButton.setVisible(false);
                AtlasProgress.this.dismissWindowButton.setToolTipText(I18nUtils.localizedStringForKey("dlg_download_btn_close_win_tips_enable", new Object[0]));
                AtlasProgress.this.dismissWindowButton.setVisible(true);
                if (!AtlasProgress.this.aborted) {
                    AtlasProgress.this.openProgramFolderButton.setToolTipText(I18nUtils.localizedStringForKey("dlg_download_btn_open_folder_tips_enabled", new Object[0]));
                    AtlasProgress.this.openProgramFolderButton.setEnabled(true);
                }
            }
        });
    }

    private synchronized void stopUpdateTask() {
        try {
            this.updateTask.cancel();
            this.updateTask = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWindow() {
        try {
            this.stopUpdateTask();
            this.downloadControlListener = null;
            this.setVisible(false);
        }
        finally {
            this.dispose();
        }
    }

    public void setDownloadControlerListener(AtlasCreationController threadControlListener) {
        this.downloadControlListener = threadControlListener;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        File atlasFolder = Settings.getInstance().getAtlasOutputDirectory();
        if (this.openProgramFolderButton.equals(source)) {
            try {
                OSUtilities.openFolderBrowser(atlasFolder);
            }
            catch (Exception e) {
                log.error("", e);
            }
        } else if (this.dismissWindowButton.equals(source)) {
            this.downloadControlListener = null;
            this.closeWindow();
        } else if (this.abortAtlasCreationButton.equals(source)) {
            this.aborted = true;
            this.stopUpdateTask();
            if (this.downloadControlListener != null) {
                this.downloadControlListener.abortAtlasCreation();
            } else {
                this.closeWindow();
            }
        } else if (this.pauseResumeDownloadButton.equals(source) && this.downloadControlListener != null) {
            this.downloadControlListener.pauseResumeAtlasCreation();
        }
    }

    public void updateGUI() {
        this.guiUpdater.updateAsynchronously();
    }

    public void forceUpdateGUI() {
        SwingUtilities.invokeLater(this.guiUpdater);
    }

    public static interface AtlasCreationController {
        public void abortAtlasCreation();

        public void pauseResumeAtlasCreation();
    }

    protected static class MapInfo {
        final MapInterface map;
        final int tileCountOnStart;
        final int tileCountOnEnd;
        final int mapTiles;

        public MapInfo(MapInterface map, int tileCountOnStart, int tileCountOnEnd) {
            this.map = map;
            this.tileCountOnStart = tileCountOnStart;
            this.tileCountOnEnd = tileCountOnEnd;
            this.mapTiles = (int)map.calculateTilesToDownload();
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MapInfo)) {
                return false;
            }
            return this.map.equals(((MapInfo)obj).map);
        }
    }

    private class CloseListener
    extends WindowAdapter {
        private CloseListener() {
        }

        public void windowClosing(WindowEvent e) {
            log.debug("Closing event detected for atlas progress window");
            AtlasCreationController listener = AtlasProgress.this.downloadControlListener;
            if (listener != null) {
                listener.abortAtlasCreation();
            }
        }
    }

    private class UpdateTask
    extends TimerTask {
        private UpdateTask() {
        }

        public void run() {
            AtlasProgress.this.updateGUI();
        }
    }

    private class GUIUpdater
    implements Runnable {
        int scheduledCounter = 0;

        private GUIUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateAsynchronously() {
            GUIUpdater gUIUpdater = this;
            synchronized (gUIUpdater) {
                if (this.scheduledCounter > 0) {
                    return;
                }
                ++this.scheduledCounter;
            }
            SwingUtilities.invokeLater(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            GUIUpdater gUIUpdater = this;
            synchronized (gUIUpdater) {
                --this.scheduledCounter;
            }
            if (((AtlasProgress)AtlasProgress.this).data.map != null) {
                String text = String.format(I18nUtils.localizedStringForKey("dlg_download_map_info_label", new Object[0]), ((AtlasProgress)AtlasProgress.this).data.map.getName(), ((AtlasProgress)AtlasProgress.this).data.map.getLayer().getName(), ((AtlasProgress)AtlasProgress.this).data.map.getMapSource().toString());
                AtlasProgress.this.mapInfoLabel.setText(text);
            }
            AtlasProgress.this.atlasProgressBar.setMaximum(((AtlasProgress)AtlasProgress.this).data.totalNumberOfTiles);
            AtlasProgress.this.atlasProgressBar.setValue(((AtlasProgress)AtlasProgress.this).data.totalProgress);
            int newTenthPercent = (int)((double)((AtlasProgress)AtlasProgress.this).data.totalProgress * 1000.0 / (double)((AtlasProgress)AtlasProgress.this).data.totalNumberOfTiles);
            try {
                boolean pauseState = AtlasProgress.this.atlasThread.isPaused();
                String statusText = I18nUtils.localizedStringForKey("dlg_download_status_running", new Object[0]);
                statusText = AtlasProgress.this.aborted ? I18nUtils.localizedStringForKey("dlg_download_status_aborted", new Object[0]) : (AtlasProgress.this.finished ? I18nUtils.localizedStringForKey("dlg_download_status_finished", new Object[0]) : (pauseState ? I18nUtils.localizedStringForKey("dlg_download_status_paused", new Object[0]) : I18nUtils.localizedStringForKey("dlg_download_status_running", new Object[0])));
                AtlasProgress.this.statusLabel.setText(I18nUtils.localizedStringForKey("dlg_download_status_title", new Object[0]) + " " + statusText);
                if (((AtlasProgress)AtlasProgress.this).data.totalProgressTenthPercent != newTenthPercent || pauseState != ((AtlasProgress)AtlasProgress.this).data.paused) {
                    ((AtlasProgress)AtlasProgress.this).data.totalProgressTenthPercent = newTenthPercent;
                    AtlasProgress.this.atlasPercent.setText(String.format(TEXT_TENTHPERCENT, (double)((AtlasProgress)AtlasProgress.this).data.totalProgressTenthPercent / 10.0));
                    if (((AtlasProgress)AtlasProgress.this).data.atlasInterface != null) {
                        String text = String.format(I18nUtils.localizedStringForKey("dlg_download_atlas_progress", new Object[0]), ((AtlasProgress)AtlasProgress.this).data.totalProgressTenthPercent / 10, ((AtlasProgress)AtlasProgress.this).data.atlasInterface.getName(), ((AtlasProgress)AtlasProgress.this).data.atlasInterface.getOutputFormat());
                        if (pauseState) {
                            text = text + " [" + I18nUtils.localizedStringForKey("dlg_download_status_paused", new Object[0]) + "]";
                        }
                        AtlasProgress.this.setTitle(text);
                    }
                }
                ((AtlasProgress)AtlasProgress.this).data.paused = pauseState;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            long seconds = -1L;
            int totalProgress = ((AtlasProgress)AtlasProgress.this).data.totalProgress;
            if (totalProgress != 0) {
                int totalTilesRemaining = ((AtlasProgress)AtlasProgress.this).data.totalNumberOfTiles - totalProgress;
                long totalElapsedTime = System.currentTimeMillis() - AtlasProgress.this.initialTotalTime;
                seconds = totalElapsedTime * (long)totalTilesRemaining / (1000L * (long)totalProgress);
            }
            AtlasProgress.this.atlasTimeLeft.setText(String.format(I18nUtils.localizedStringForKey("dlg_download_remain_time", new Object[0]), AtlasProgress.this.formatTime(seconds)));
            AtlasProgress.this.mapDownloadProgressBar.setMaximum(((AtlasProgress)AtlasProgress.this).data.mapDownloadNumberOfTiles);
            AtlasProgress.this.mapDownloadProgressBar.setValue(((AtlasProgress)AtlasProgress.this).data.mapDownloadProgress);
            AtlasProgress.this.mapDownloadPercent.setText(String.format(TEXT_PERCENT, (int)(AtlasProgress.this.mapDownloadProgressBar.getPercentComplete() * 100.0)));
            AtlasProgress.this.mapDownloadElementsDone.setText(String.format(I18nUtils.localizedStringForKey("dlg_download_tile_done_count", new Object[0]), ((AtlasProgress)AtlasProgress.this).data.mapDownloadProgress, ((AtlasProgress)AtlasProgress.this).data.mapDownloadNumberOfTiles));
            seconds = -1L;
            int mapDlProgress = ((AtlasProgress)AtlasProgress.this).data.mapDownloadProgress;
            if (mapDlProgress != 0 && AtlasProgress.this.initialMapDownloadTime > 0L) {
                seconds = (System.currentTimeMillis() - AtlasProgress.this.initialMapDownloadTime) * (long)(((AtlasProgress)AtlasProgress.this).data.mapDownloadNumberOfTiles - mapDlProgress) / (1000L * (long)mapDlProgress);
            }
            AtlasProgress.this.mapDownloadTimeLeft.setText(String.format(I18nUtils.localizedStringForKey("dlg_download_remain_time", new Object[0]), AtlasProgress.this.formatTime(seconds)));
            AtlasProgress.this.mapCreation.setText(I18nUtils.localizedStringForKey("dlg_download_map_create_title", new Object[0]));
            AtlasProgress.this.mapCreationProgressBar.setValue(((AtlasProgress)AtlasProgress.this).data.mapCreationProgress);
            AtlasProgress.this.mapCreationProgressBar.setMaximum(((AtlasProgress)AtlasProgress.this).data.mapCreationMax);
            AtlasProgress.this.atlasMapsDone.setText(String.format(I18nUtils.localizedStringForKey("dlg_download_map_done_count", new Object[0]), ((AtlasProgress)AtlasProgress.this).data.currentMapNumber - 1, ((AtlasProgress)AtlasProgress.this).data.totalNumberOfMaps));
            long rate = ((AtlasProgress)AtlasProgress.this).data.numberOfDownloadedBytes * 1000L;
            long time = System.currentTimeMillis() - AtlasProgress.this.initialMapDownloadTime;
            if (((AtlasProgress)AtlasProgress.this).data.mapCreationProgress == 0 && AtlasProgress.this.initialMapDownloadTime > 0L) {
                if (time == 0L) {
                    AtlasProgress.this.nrOfDownloadedBytesPerSecondValue.setText("??");
                } else {
                    AtlasProgress.this.nrOfDownloadedBytesPerSecondValue.setText(String.format(I18nUtils.localizedStringForKey("dlg_download_avg_speed_value", new Object[0]), Utilities.formatBytes(rate /= time)));
                }
            }
            AtlasProgress.this.nrOfDownloadedBytesValue.setText(": " + Utilities.formatBytes(((AtlasProgress)AtlasProgress.this).data.numberOfDownloadedBytes));
            AtlasProgress.this.nrOfCacheBytesValue.setText(": " + Utilities.formatBytes(((AtlasProgress)AtlasProgress.this).data.numberOfBytesLoadedFromCache));
            long totalSeconds = (System.currentTimeMillis() - AtlasProgress.this.initialTotalTime) / 1000L;
            AtlasProgress.this.totalDownloadTimeValue.setText(": " + AtlasProgress.this.formatTime(totalSeconds));
            AtlasProgress.this.totalDownloadTimeValue.repaint();
            int activeDownloads = AtlasProgress.this.atlasThread == null ? 0 : AtlasProgress.this.atlasThread.getActiveDownloads();
            AtlasProgress.this.activeDownloadsValue.setText(": " + activeDownloads);
            AtlasProgress.this.activeDownloadsValue.repaint();
            int totalRetryableErrors = ((AtlasProgress)AtlasProgress.this).data.prevMapsRetryErrors + ((AtlasProgress)AtlasProgress.this).data.mapRetryErrors;
            AtlasProgress.this.retryableDownloadErrorsValue.setText(String.format(I18nUtils.localizedStringForKey("dlg_download_retry_count_value", new Object[0]), ((AtlasProgress)AtlasProgress.this).data.mapRetryErrors, totalRetryableErrors));
            AtlasProgress.this.retryableDownloadErrorsValue.repaint();
            int totalPermanentErrors = ((AtlasProgress)AtlasProgress.this).data.prevMapsPermanentErrors + ((AtlasProgress)AtlasProgress.this).data.mapPermanentErrors;
            AtlasProgress.this.permanentDownloadErrorsValue.setText(String.format(I18nUtils.localizedStringForKey("dlg_download_failed_count_value", new Object[0]), ((AtlasProgress)AtlasProgress.this).data.mapPermanentErrors, totalPermanentErrors));
            AtlasProgress.this.permanentDownloadErrorsValue.repaint();
        }
    }

    private static class Data {
        AtlasInterface atlasInterface;
        MapInterface map;
        MapInfo mapInfo;
        long numberOfDownloadedBytes = 0L;
        long numberOfBytesLoadedFromCache = 0L;
        int totalNumberOfTiles = 0;
        int totalNumberOfMaps = 0;
        int totalProgress = 0;
        int totalProgressTenthPercent = -1;
        int currentMapNumber = 0;
        int mapDownloadProgress = 0;
        int mapDownloadNumberOfTiles = 0;
        int mapCreationProgress = 0;
        int mapCreationMax = 0;
        int mapRetryErrors = 0;
        int mapPermanentErrors = 0;
        int prevMapsRetryErrors = 0;
        int prevMapsPermanentErrors = 0;
        boolean paused = false;

        private Data() {
        }
    }
}

