/*
 * Decompiled with CFR 0.152.
 */
package mobac.externaltools;

import java.io.File;
import java.io.FileInputStream;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import mobac.externaltools.ExternalToolDef;
import mobac.program.DirectoryManager;
import mobac.utilities.GUIExceptionHandler;
import mobac.utilities.Utilities;
import mobac.utilities.file.FileExtFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ExternalToolsLoader {
    public static List<ExternalToolDef> tools = null;

    public static boolean load() {
        try {
            File dir = DirectoryManager.toolsDir;
            if (!dir.isDirectory()) {
                return false;
            }
            File[] files = dir.listFiles(new FileExtFilter(".xml"));
            tools = new LinkedList<ExternalToolDef>();
            for (File f : files) {
                tools.add(ExternalToolsLoader.loadFile(f));
            }
            return true;
        }
        catch (Exception e) {
            GUIExceptionHandler.showExceptionDialog("Failed to load external tools definition", e);
            return false;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ExternalToolDef loadFile(File f) throws JAXBException {
        ExternalToolDef externalToolDef;
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ExternalToolDef.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder loader = factory.newDocumentBuilder();
            Document document = loader.parse(is);
            externalToolDef = (ExternalToolDef)unmarshaller.unmarshal((Node)document);
        }
        catch (JAXBException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new JAXBException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                Utilities.closeStream(is);
                throw throwable;
            }
        }
        Utilities.closeStream(is);
        return externalToolDef;
    }

    static {
        ExternalToolsLoader.load();
    }
}

