/*
 * Decompiled with CFR 0.152.
 */
package mobac.data.gpx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.util.JAXBResult;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import mobac.data.gpx.gpx11.Gpx;
import mobac.utilities.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GPXUtils {
    public static boolean checkJAXBVersion() {
        boolean res = Utilities.checkJAXBVersion();
        if (!res) {
            JOptionPane.showMessageDialog(null, "Outdated Java Runtime Environment and JAXB version", "Mobile Atlas Creator has detected that your used Java Runtime Environment is too old.\n Please update the Java Runtime Environment to at least \nversion 1.6.0_14 and restart Mobile Atlas Creator.", 0);
        }
        return res;
    }

    public static Gpx loadGpxFile(File f) throws JAXBException {
        String namespace;
        FileInputStream is;
        block8: {
            Document document;
            Unmarshaller unmarshaller;
            block7: {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Gpx.class});
                unmarshaller = context.createUnmarshaller();
                is = null;
                is = new FileInputStream(f);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder loader = factory.newDocumentBuilder();
                document = loader.parse(is);
                namespace = document.getDocumentElement().getNamespaceURI();
                if (!"http://www.topografix.com/GPX/1/1".equals(namespace)) break block7;
                Gpx gpx = (Gpx)unmarshaller.unmarshal((Node)document);
                Utilities.closeStream(is);
                return gpx;
            }
            if (!"http://www.topografix.com/GPX/1/0".equals(namespace)) break block8;
            DOMSource xmlSource = new DOMSource(document);
            StreamSource xsltSource = new StreamSource(Utilities.loadResourceAsStream("xsl/gpx10to11.xsl"));
            JAXBResult result = new JAXBResult(unmarshaller);
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.transform(xmlSource, (Result)result);
            Gpx gpx = (Gpx)result.getResult();
            Utilities.closeStream(is);
            return gpx;
        }
        try {
            try {
                throw new JAXBException("Expected GPX 1.0 or GPX1.1 namespace but found \n\"" + namespace + "\"");
            }
            catch (JAXBException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JAXBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Utilities.closeStream(is);
            throw throwable;
        }
    }

    public static void saveGpxFile(Gpx gpx, File f) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Gpx.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(f);
            marshaller.marshal((Object)gpx, (OutputStream)os);
        }
        catch (FileNotFoundException e) {
            try {
                throw new JAXBException((Throwable)e);
            }
            catch (Throwable throwable) {
                Utilities.closeStream(os);
                throw throwable;
            }
        }
        Utilities.closeStream(os);
    }
}

