/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.ForeignKeyDeleteAction;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.Sequence;
import com.sleepycat.je.SequenceConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.DatabaseNamer;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SecondaryIndex;
import com.sleepycat.persist.StoreConfig;
import com.sleepycat.persist.evolve.Converter;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistCatalog;
import com.sleepycat.persist.impl.PersistComparator;
import com.sleepycat.persist.impl.PersistEntityBinding;
import com.sleepycat.persist.impl.PersistKeyAssigner;
import com.sleepycat.persist.impl.PersistKeyBinding;
import com.sleepycat.persist.impl.PersistKeyCreator;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.DeleteAction;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.model.FieldMetadata;
import com.sleepycat.persist.model.ModelInternal;
import com.sleepycat.persist.model.PrimaryKeyMetadata;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKeyMetadata;
import com.sleepycat.persist.raw.RawObject;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Store {
    private static Map<Environment, Map<String, PersistCatalog>> catalogPool = new WeakHashMap<Environment, Map<String, PersistCatalog>>();
    private static SyncHook syncHook;
    private Environment env;
    private boolean rawAccess;
    private PersistCatalog catalog;
    private EntityModel model;
    private Mutations mutations;
    private StoreConfig storeConfig;
    private String storeName;
    private String storePrefix;
    private Map<String, PrimaryIndex> priIndexMap;
    private Map<String, SecondaryIndex> secIndexMap;
    private Map<String, DatabaseConfig> priConfigMap;
    private Map<String, SecondaryConfig> secConfigMap;
    private Map<String, PersistKeyBinding> keyBindingMap;
    private Map<String, Sequence> sequenceMap;
    private Map<String, SequenceConfig> sequenceConfigMap;
    private Database sequenceDb;
    private IdentityHashMap<Database, Object> deferredWriteDatabases;
    private Map<String, Set<String>> inverseRelatedEntityMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Store(Environment env, String storeName, StoreConfig config, boolean rawAccess) throws DatabaseException {
        block16: {
            Object dbConfig;
            block18: {
                this.env = env;
                this.storeName = storeName;
                this.rawAccess = rawAccess;
                if (env == null) throw new NullPointerException("env and storeName parameters must not be null");
                if (storeName == null) {
                    throw new NullPointerException("env and storeName parameters must not be null");
                }
                if (config != null) {
                    this.model = config.getModel();
                    this.mutations = config.getMutations();
                }
                this.storeConfig = config == null ? StoreConfig.DEFAULT : config.cloneConfig();
                this.storePrefix = "persist#" + storeName + "#";
                this.priIndexMap = new HashMap<String, PrimaryIndex>();
                this.secIndexMap = new HashMap<String, SecondaryIndex>();
                this.priConfigMap = new HashMap<String, DatabaseConfig>();
                this.secConfigMap = new HashMap<String, SecondaryConfig>();
                this.keyBindingMap = new HashMap<String, PersistKeyBinding>();
                this.sequenceMap = new HashMap<String, Sequence>();
                this.sequenceConfigMap = new HashMap<String, SequenceConfig>();
                this.deferredWriteDatabases = new IdentityHashMap();
                if (!rawAccess) break block18;
                if (this.model != null) {
                    throw new IllegalArgumentException("A model may not be specified when opening a RawStore");
                }
                dbConfig = new DatabaseConfig();
                ((DatabaseConfig)dbConfig).setReadOnly(true);
                ((DatabaseConfig)dbConfig).setTransactional(this.storeConfig.getTransactional());
                this.catalog = new PersistCatalog(null, env, this.storePrefix, this.storePrefix + "com.sleepycat.persist.formats", (DatabaseConfig)dbConfig, this.model, this.mutations, rawAccess, this);
                break block16;
            }
            dbConfig = catalogPool;
            synchronized (dbConfig) {
                Transaction txn;
                block17: {
                    Map<String, PersistCatalog> catalogMap = catalogPool.get(env);
                    if (catalogMap == null) {
                        catalogMap = new HashMap<String, PersistCatalog>();
                        catalogPool.put(env, catalogMap);
                    }
                    this.catalog = catalogMap.get(storeName);
                    if (this.catalog != null) {
                        this.catalog.openExisting();
                    } else {
                        txn = null;
                        if (this.storeConfig.getTransactional() && DbCompat.getThreadTransaction(env) == null) {
                            txn = env.beginTransaction(null, null);
                        }
                        boolean success = false;
                        try {
                            DatabaseConfig dbConfig2 = new DatabaseConfig();
                            dbConfig2.setAllowCreate(this.storeConfig.getAllowCreate());
                            dbConfig2.setTemporary(this.storeConfig.getTemporary());
                            dbConfig2.setReadOnly(this.storeConfig.getReadOnly());
                            dbConfig2.setTransactional(this.storeConfig.getTransactional());
                            DbCompat.setTypeBtree(dbConfig2);
                            this.catalog = new PersistCatalog(txn, env, this.storePrefix, this.storePrefix + "com.sleepycat.persist.formats", dbConfig2, this.model, this.mutations, rawAccess, this);
                            catalogMap.put(storeName, this.catalog);
                            success = true;
                            Object var11_11 = null;
                            if (txn == null) break block16;
                            if (!success) break block17;
                        }
                        catch (Throwable throwable) {
                            Object var11_12 = null;
                            if (txn == null) throw throwable;
                            if (success) {
                                txn.commit();
                                throw throwable;
                            }
                            txn.abort();
                            throw throwable;
                        }
                        txn.commit();
                    }
                    break block16;
                }
                txn.abort();
            }
        }
        this.mutations = this.catalog.getMutations();
        this.model = this.catalog.getResolvedModel();
        ModelInternal.setCatalog(this.model, this.catalog);
        for (Converter converter : this.mutations.getConverters()) {
            converter.getConversion().initialize(this.model);
        }
        this.inverseRelatedEntityMap = new HashMap<String, Set<String>>();
        ArrayList<Format> entityFormats = new ArrayList<Format>();
        this.catalog.getEntityFormats(entityFormats);
        Iterator i$ = entityFormats.iterator();
        block5: while (i$.hasNext()) {
            Format entityFormat = (Format)i$.next();
            EntityMetadata entityMeta = entityFormat.getEntityMetadata();
            Iterator<SecondaryKeyMetadata> i$2 = entityMeta.getSecondaryKeys().values().iterator();
            while (true) {
                if (!i$2.hasNext()) continue block5;
                SecondaryKeyMetadata secKeyMeta = i$2.next();
                String relatedClsName = secKeyMeta.getRelatedEntity();
                if (relatedClsName == null) continue;
                Set<String> inverseClassNames = this.inverseRelatedEntityMap.get(relatedClsName);
                if (inverseClassNames == null) {
                    inverseClassNames = new HashSet<String>();
                    this.inverseRelatedEntityMap.put(relatedClsName, inverseClassNames);
                }
                inverseClassNames.add(entityMeta.getClassName());
            }
            break;
        }
        return;
    }

    public Environment getEnvironment() {
        return this.env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized <PK, E> PrimaryIndex<PK, E> getPrimaryIndex(Class<PK> primaryKeyClass, String primaryKeyClassName, Class<E> entityClass, String entityClassName) throws DatabaseException {
        PrimaryOpenState priOpenState;
        Transaction txn;
        PrimaryIndex<PK, E> priIndex;
        block22: {
            if (!($assertionsDisabled || this.rawAccess && entityClass == RawObject.class)) {
                if (this.rawAccess) throw new AssertionError();
                if (entityClass == RawObject.class) {
                    throw new AssertionError();
                }
            }
            if (!($assertionsDisabled || this.rawAccess && primaryKeyClassName == null)) {
                if (this.rawAccess) throw new AssertionError();
                if (primaryKeyClassName == null) {
                    throw new AssertionError();
                }
            }
            this.checkOpen();
            priIndex = this.priIndexMap.get(entityClassName);
            if (priIndex != null) return priIndex;
            EntityMetadata entityMeta = this.checkEntityClass(entityClassName);
            PrimaryKeyMetadata priKeyMeta = entityMeta.getPrimaryKey();
            if (primaryKeyClassName == null) {
                primaryKeyClassName = priKeyMeta.getClassName();
            } else {
                String expectClsName = SimpleCatalog.keyClassName(priKeyMeta.getClassName());
                if (!primaryKeyClassName.equals(expectClsName)) {
                    throw new IllegalArgumentException("Wrong primary key class: " + primaryKeyClassName + " Correct class is: " + expectClsName);
                }
            }
            PersistEntityBinding entityBinding = new PersistEntityBinding(this.catalog, entityClassName, this.rawAccess);
            PersistKeyBinding keyBinding = this.getKeyBinding(primaryKeyClassName);
            String seqName = priKeyMeta.getSequenceName();
            if (!this.storeConfig.getReadOnly() && seqName != null) {
                entityBinding.keyAssigner = new PersistKeyAssigner(keyBinding, entityBinding, this.getSequence(seqName));
            }
            txn = null;
            DatabaseConfig dbConfig = this.getPrimaryConfig(entityMeta);
            if (dbConfig.getTransactional() && DbCompat.getThreadTransaction(this.env) == null) {
                txn = this.env.beginTransaction(null, null);
            }
            priOpenState = new PrimaryOpenState(entityClassName);
            boolean success = false;
            try {
                Database db;
                String[] fileAndDbNames = this.parseDbName(this.storePrefix + entityClassName);
                try {
                    db = DbCompat.openDatabase(this.env, txn, fileAndDbNames[0], fileAndDbNames[1], dbConfig);
                }
                catch (FileNotFoundException e) {
                    throw new DatabaseException(e);
                }
                priOpenState.addDatabase(db);
                priIndex = new PrimaryIndex<PK, E>(db, primaryKeyClass, keyBinding, entityClass, entityBinding);
                this.priIndexMap.put(entityClassName, priIndex);
                if (DbCompat.getDeferredWrite(dbConfig)) {
                    this.deferredWriteDatabases.put(db, null);
                }
                if (!dbConfig.getReadOnly()) {
                    this.openSecondaryIndexes(txn, entityMeta, priOpenState);
                    Set<String> inverseClassNames = this.inverseRelatedEntityMap.get(entityClassName);
                    if (inverseClassNames != null) {
                        for (String relatedClsName : inverseClassNames) {
                            this.getRelatedIndex(relatedClsName);
                        }
                    }
                }
                success = true;
                Object var21_21 = null;
                if (!success) break block22;
                if (txn == null) return priIndex;
            }
            catch (Throwable throwable) {
                Object var21_22 = null;
                if (success) {
                    if (txn == null) throw throwable;
                    txn.commit();
                    throw throwable;
                }
                if (txn != null) {
                    txn.abort();
                } else {
                    priOpenState.closeDatabases();
                }
                priOpenState.undoState();
                throw throwable;
            }
            txn.commit();
            return priIndex;
        }
        if (txn != null) {
            txn.abort();
        } else {
            priOpenState.closeDatabases();
        }
        priOpenState.undoState();
        return priIndex;
    }

    private PrimaryIndex getRelatedIndex(String relatedClsName) throws DatabaseException {
        PrimaryIndex relatedIndex = this.priIndexMap.get(relatedClsName);
        if (relatedIndex == null) {
            String relatedKeyClsName;
            Class relatedKeyCls;
            Class relatedCls;
            EntityMetadata relatedEntityMeta = this.checkEntityClass(relatedClsName);
            if (this.rawAccess) {
                relatedCls = RawObject.class;
                relatedKeyCls = Object.class;
                relatedKeyClsName = null;
            } else {
                try {
                    relatedCls = EntityModel.classForName(relatedClsName);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Related entity class not found: " + relatedClsName);
                }
                relatedKeyClsName = SimpleCatalog.keyClassName(relatedEntityMeta.getPrimaryKey().getClassName());
                relatedKeyCls = SimpleCatalog.keyClassForName(relatedKeyClsName);
            }
            relatedIndex = this.getPrimaryIndex(relatedKeyCls, relatedKeyClsName, relatedCls, relatedClsName);
        }
        return relatedIndex;
    }

    synchronized void openSecondaryIndexes(Transaction txn, EntityMetadata entityMeta, PrimaryOpenState priOpenState) throws DatabaseException {
        String entityClassName = entityMeta.getClassName();
        PrimaryIndex priIndex = this.priIndexMap.get(entityClassName);
        assert (priIndex != null);
        Class entityClass = priIndex.getEntityClass();
        for (SecondaryKeyMetadata secKeyMeta : entityMeta.getSecondaryKeys().values()) {
            String keyName = secKeyMeta.getKeyName();
            String secName = Store.makeSecName(entityClassName, keyName);
            SecondaryIndex secIndex = this.secIndexMap.get(secName);
            if (secIndex != null) continue;
            String keyClassName = this.getSecKeyClass(secKeyMeta);
            Class keyClass = SimpleCatalog.keyClassForName(keyClassName);
            this.openSecondaryIndex(txn, priIndex, entityClass, entityMeta, keyClass, keyClassName, secKeyMeta, Store.makeSecName(entityClassName, secKeyMeta.getKeyName()), this.storeConfig.getSecondaryBulkLoad(), priOpenState);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <SK, PK, E1, E2 extends E1> SecondaryIndex<SK, PK, E2> openSecondaryIndex(Transaction txn, PrimaryIndex<PK, E1> primaryIndex, Class<E2> entityClass, EntityMetadata entityMeta, Class<SK> keyClass, String keyClassName, SecondaryKeyMetadata secKeyMeta, String secName, boolean doNotCreate, PrimaryOpenState priOpenState) throws DatabaseException {
        SecondaryDatabase db;
        PersistKeyBinding keyBinding;
        SecondaryConfig config;
        block14: {
            assert (!this.secIndexMap.containsKey(secName));
            String[] fileAndDbNames = this.parseDbName(this.storePrefix + secName);
            config = this.getSecondaryConfig(secName, entityMeta, keyClassName, secKeyMeta);
            Database priDb = primaryIndex.getDatabase();
            DatabaseConfig priConfig = priDb.getConfig();
            String relatedClsName = secKeyMeta.getRelatedEntity();
            if (relatedClsName != null) {
                PrimaryIndex relatedIndex = this.getRelatedIndex(relatedClsName);
                config.setForeignKeyDatabase(relatedIndex.getDatabase());
            }
            if (config.getTransactional() != priConfig.getTransactional() || DbCompat.getDeferredWrite(config) != DbCompat.getDeferredWrite(priConfig) || config.getReadOnly() != priConfig.getReadOnly()) {
                throw new IllegalArgumentException("One of these properties was changed to be inconsistent with the associated primary database:  Transactional, DeferredWrite, ReadOnly");
            }
            keyBinding = this.getKeyBinding(keyClassName);
            boolean saveAllowCreate = config.getAllowCreate();
            try {
                try {
                    if (doNotCreate) {
                        config.setAllowCreate(false);
                    }
                    db = DbCompat.openSecondaryDatabase(this.env, txn, fileAndDbNames[0], fileAndDbNames[1], priDb, config);
                }
                catch (DatabaseNotFoundException e) {
                    if (doNotCreate) {
                        SecondaryIndex<SK, PK, E2> secondaryIndex = null;
                        Object var22_20 = null;
                        if (!doNotCreate) return secondaryIndex;
                        config.setAllowCreate(saveAllowCreate);
                        return secondaryIndex;
                    }
                    throw e;
                }
                catch (FileNotFoundException e) {
                    if (doNotCreate) {
                        SecondaryIndex<SK, PK, E2> secondaryIndex = null;
                        Object var22_21 = null;
                        if (!doNotCreate) return secondaryIndex;
                        config.setAllowCreate(saveAllowCreate);
                        return secondaryIndex;
                    }
                    throw new DatabaseException(e);
                }
                Object var22_19 = null;
                if (!doNotCreate) break block14;
            }
            catch (Throwable throwable) {
                Object var22_22 = null;
                if (doNotCreate) {
                    config.setAllowCreate(saveAllowCreate);
                }
                throw throwable;
            }
            config.setAllowCreate(saveAllowCreate);
        }
        SecondaryIndex<SK, PK, E1> secIndex = new SecondaryIndex<SK, PK, E1>(db, null, primaryIndex, keyClass, keyBinding);
        this.secIndexMap.put(secName, secIndex);
        if (DbCompat.getDeferredWrite(config)) {
            this.deferredWriteDatabases.put(db, null);
        }
        if (priOpenState != null) {
            priOpenState.addDatabase(db);
            priOpenState.addSecondaryName(secName);
        }
        return secIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws DatabaseException {
        ArrayList<Database> dbs = new ArrayList<Database>();
        Store store = this;
        synchronized (store) {
            dbs.addAll(this.deferredWriteDatabases.keySet());
        }
        int nDbs = dbs.size();
        if (nDbs > 0) {
            for (int i = 0; i < nDbs; ++i) {
                Database db = (Database)dbs.get(i);
                boolean flushLog = i == nDbs - 1;
                DbCompat.syncDeferredWrite(db, flushLog);
                if (syncHook == null) continue;
                syncHook.onSync(db, flushLog);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws DatabaseException {
        DatabaseException firstException;
        block13: {
            this.checkOpen();
            firstException = null;
            try {
                if (this.rawAccess) {
                    boolean allClosed = this.catalog.close();
                    assert (allClosed);
                } else {
                    Map<Environment, Map<String, PersistCatalog>> allClosed = catalogPool;
                    synchronized (allClosed) {
                        Map<String, PersistCatalog> map = catalogPool.get(this.env);
                        assert (map != null);
                        if (this.catalog.close()) {
                            map.remove(this.storeName);
                        }
                    }
                }
                this.catalog = null;
            }
            catch (DatabaseException e) {
                if (firstException != null) break block13;
                firstException = e;
            }
        }
        firstException = this.closeDb(this.sequenceDb, firstException);
        for (SecondaryIndex secondaryIndex : this.secIndexMap.values()) {
            firstException = this.closeDb(secondaryIndex.getDatabase(), firstException);
            firstException = this.closeDb(secondaryIndex.getKeysDatabase(), firstException);
        }
        for (PrimaryIndex primaryIndex : this.priIndexMap.values()) {
            firstException = this.closeDb(primaryIndex.getDatabase(), firstException);
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public synchronized Sequence getSequence(String name) throws DatabaseException {
        this.checkOpen();
        if (this.storeConfig.getReadOnly()) {
            throw new IllegalStateException("Store is read-only");
        }
        Sequence seq = this.sequenceMap.get(name);
        if (seq == null) {
            if (this.sequenceDb == null) {
                String[] fileAndDbNames = this.parseDbName(this.storePrefix + "com.sleepycat.persist.sequences");
                DatabaseConfig dbConfig = new DatabaseConfig();
                dbConfig.setTransactional(this.storeConfig.getTransactional());
                dbConfig.setAllowCreate(true);
                dbConfig.setTemporary(this.storeConfig.getTemporary());
                DbCompat.setTypeBtree(dbConfig);
                try {
                    this.sequenceDb = DbCompat.openDatabase(this.env, null, fileAndDbNames[0], fileAndDbNames[1], dbConfig);
                }
                catch (FileNotFoundException e) {
                    throw new DatabaseException(e);
                }
            }
            DatabaseEntry entry = new DatabaseEntry();
            StringBinding.stringToEntry(name, entry);
            seq = this.sequenceDb.openSequence(null, entry, this.getSequenceConfig(name));
            this.sequenceMap.put(name, seq);
        }
        return seq;
    }

    public synchronized SequenceConfig getSequenceConfig(String name) {
        this.checkOpen();
        SequenceConfig config = this.sequenceConfigMap.get(name);
        if (config == null) {
            config = new SequenceConfig();
            config.setInitialValue(1L);
            config.setRange(1L, Long.MAX_VALUE);
            config.setCacheSize(100);
            config.setAutoCommitNoSync(true);
            config.setAllowCreate(!this.storeConfig.getReadOnly());
            this.sequenceConfigMap.put(name, config);
        }
        return config;
    }

    private synchronized DatabaseConfig getPrimaryConfig(EntityMetadata meta) {
        String clsName = meta.getClassName();
        DatabaseConfig config = this.priConfigMap.get(clsName);
        if (config == null) {
            config = new DatabaseConfig();
            config.setTransactional(this.storeConfig.getTransactional());
            config.setAllowCreate(!this.storeConfig.getReadOnly());
            config.setReadOnly(this.storeConfig.getReadOnly());
            DbCompat.setTypeBtree(config);
            config.setTemporary(this.storeConfig.getTemporary());
            config.setDeferredWrite(this.storeConfig.getDeferredWrite());
            this.setBtreeComparator(config, meta.getPrimaryKey().getClassName());
            this.priConfigMap.put(clsName, config);
        }
        return config;
    }

    private SecondaryConfig getSecondaryConfig(String secName, EntityMetadata entityMeta, String keyClassName, SecondaryKeyMetadata secKeyMeta) {
        SecondaryConfig config = this.secConfigMap.get(secName);
        if (config == null) {
            DatabaseConfig priConfig = this.getPrimaryConfig(entityMeta);
            config = new SecondaryConfig();
            config.setTransactional(priConfig.getTransactional());
            config.setAllowCreate(!priConfig.getReadOnly());
            config.setReadOnly(priConfig.getReadOnly());
            DbCompat.setTypeBtree(config);
            config.setTemporary(priConfig.getTemporary());
            config.setDeferredWrite(priConfig.getDeferredWrite());
            config.setAllowPopulate(true);
            Relationship rel = secKeyMeta.getRelationship();
            config.setSortedDuplicates(rel == Relationship.MANY_TO_ONE || rel == Relationship.MANY_TO_MANY);
            this.setBtreeComparator(config, secKeyMeta.getClassName());
            PersistKeyCreator keyCreator = new PersistKeyCreator(this.catalog, entityMeta, keyClassName, secKeyMeta, this.rawAccess);
            if (rel == Relationship.ONE_TO_MANY || rel == Relationship.MANY_TO_MANY) {
                config.setMultiKeyCreator(keyCreator);
            } else {
                config.setKeyCreator(keyCreator);
            }
            DeleteAction deleteAction = secKeyMeta.getDeleteAction();
            if (deleteAction != null) {
                ForeignKeyDeleteAction baseDeleteAction;
                switch (deleteAction) {
                    case ABORT: {
                        baseDeleteAction = ForeignKeyDeleteAction.ABORT;
                        break;
                    }
                    case CASCADE: {
                        baseDeleteAction = ForeignKeyDeleteAction.CASCADE;
                        break;
                    }
                    case NULLIFY: {
                        baseDeleteAction = ForeignKeyDeleteAction.NULLIFY;
                        break;
                    }
                    default: {
                        throw new IllegalStateException(deleteAction.toString());
                    }
                }
                config.setForeignKeyDeleteAction(baseDeleteAction);
                if (deleteAction == DeleteAction.NULLIFY) {
                    config.setForeignMultiKeyNullifier(keyCreator);
                }
            }
            this.secConfigMap.put(secName, config);
        }
        return config;
    }

    private static String makeSecName(String entityClsName, String keyName) {
        return entityClsName + "#" + keyName;
    }

    static String makePriDbName(String storePrefix, String entityClsName) {
        return storePrefix + entityClsName;
    }

    static String makeSecDbName(String storePrefix, String entityClsName, String keyName) {
        return storePrefix + Store.makeSecName(entityClsName, keyName);
    }

    public String[] parseDbName(String wholeName) {
        return Store.parseDbName(wholeName, this.storeConfig.getDatabaseNamer());
    }

    public static String[] parseDbName(String wholeName, DatabaseNamer namer) {
        String[] result = new String[]{null, wholeName};
        return result;
    }

    private void checkOpen() {
        if (this.catalog == null) {
            throw new IllegalStateException("Store has been closed");
        }
    }

    private EntityMetadata checkEntityClass(String clsName) {
        EntityMetadata meta = this.model.getEntityMetadata(clsName);
        if (meta == null) {
            throw new IllegalArgumentException("Class could not be loaded or is not an entity class: " + clsName);
        }
        return meta;
    }

    private String getSecKeyClass(SecondaryKeyMetadata secKeyMeta) {
        String clsName = secKeyMeta.getElementClassName();
        if (clsName == null) {
            clsName = secKeyMeta.getClassName();
        }
        return SimpleCatalog.keyClassName(clsName);
    }

    private PersistKeyBinding getKeyBinding(String keyClassName) {
        PersistKeyBinding binding = this.keyBindingMap.get(keyClassName);
        if (binding == null) {
            binding = new PersistKeyBinding(this.catalog, keyClassName, this.rawAccess);
            this.keyBindingMap.put(keyClassName, binding);
        }
        return binding;
    }

    private void setBtreeComparator(DatabaseConfig config, String clsName) {
        Class keyClass;
        List<FieldMetadata> compositeKeyFields;
        ClassMetadata meta;
        if (!this.rawAccess && (meta = this.model.getClassMetadata(clsName)) != null && (compositeKeyFields = meta.getCompositeKeyFields()) != null && Comparable.class.isAssignableFrom(keyClass = SimpleCatalog.keyClassForName(clsName))) {
            PersistComparator cmp = new PersistComparator(clsName, compositeKeyFields, this.getKeyBinding(clsName));
            config.setBtreeComparator(cmp);
        }
    }

    private DatabaseException closeDb(Database db, DatabaseException firstException) {
        block3: {
            if (db != null) {
                try {
                    db.close();
                }
                catch (DatabaseException e) {
                    if (firstException != null) break block3;
                    firstException = e;
                }
            }
        }
        return firstException;
    }

    public static interface SyncHook {
        public void onSync(Database var1, boolean var2);
    }

    private class PrimaryOpenState {
        private String entityClassName;
        private IdentityHashMap<Database, Object> databases;
        private Set<String> secNames;

        PrimaryOpenState(String entityClassName) {
            this.entityClassName = entityClassName;
            this.databases = new IdentityHashMap();
            this.secNames = new HashSet<String>();
        }

        void addDatabase(Database db) {
            this.databases.put(db, null);
        }

        void addSecondaryName(String secName) {
            this.secNames.add(secName);
        }

        void closeDatabases() {
            for (Database db : this.databases.keySet()) {
                try {
                    db.close();
                }
                catch (Exception exception) {}
            }
        }

        void undoState() {
            Store.this.priIndexMap.remove(this.entityClassName);
            for (String secName : this.secNames) {
                Store.this.secIndexMap.remove(secName);
            }
            for (Database db : this.databases.keySet()) {
                Store.this.deferredWriteDatabases.remove(db);
            }
        }
    }
}

