/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockAttemptResult;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockImpl;
import com.sleepycat.je.txn.LockInfo;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.LockUpgrade;
import com.sleepycat.je.txn.Locker;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThinLockImpl
extends LockInfo
implements Lock {
    public ThinLockImpl() {
        super(null, null);
    }

    @Override
    public List<LockInfo> getWaitersListClone() {
        return Collections.emptyList();
    }

    @Override
    public void flushWaiter(Locker locker, MemoryBudget mb, int lockTableIndex) {
    }

    @Override
    public Set<LockInfo> getOwnersClone() {
        HashSet<LockInfo> ret = new HashSet<LockInfo>();
        if (this.locker != null) {
            ret.add(this);
        }
        return ret;
    }

    @Override
    public boolean isOwner(Locker locker, LockType lockType) {
        if (locker == this.locker) {
            LockUpgrade upgrade;
            if (lockType == this.lockType) {
                return true;
            }
            return this.lockType != null && !(upgrade = this.lockType.getUpgrade(lockType)).getPromotion();
        }
        return false;
    }

    @Override
    public int nWaiters() {
        return 0;
    }

    @Override
    public int nOwners() {
        return this.locker == null ? 0 : 1;
    }

    @Override
    public LockAttemptResult lock(LockType requestType, Locker locker, boolean nonBlockingRequest, MemoryBudget mb, int lockTableIndex) throws DatabaseException {
        if (this.locker != null && this.locker != locker) {
            LockImpl newLock = new LockImpl(new LockInfo(this.locker, this.lockType));
            return newLock.lock(requestType, locker, nonBlockingRequest, mb, lockTableIndex);
        }
        LockGrantType grant = null;
        if (this.locker == null) {
            this.locker = locker;
            this.lockType = requestType;
            grant = LockGrantType.NEW;
        } else {
            LockUpgrade upgrade = this.lockType.getUpgrade(requestType);
            if (upgrade.getUpgrade() == null) {
                grant = LockGrantType.EXISTING;
            } else {
                LockType upgradeType = upgrade.getUpgrade();
                assert (upgradeType != null);
                this.lockType = upgradeType;
                grant = upgrade.getPromotion() ? LockGrantType.PROMOTION : LockGrantType.EXISTING;
            }
        }
        return new LockAttemptResult(this, grant, false);
    }

    @Override
    public Set<Locker> release(Locker locker, MemoryBudget mb, int lockTableIndex) {
        if (locker == this.locker) {
            this.locker = null;
            this.lockType = null;
            return Collections.emptySet();
        }
        return null;
    }

    @Override
    public void demote(Locker locker) {
        if (this.lockType.isWriteLock()) {
            this.lockType = this.lockType == LockType.RANGE_WRITE ? LockType.RANGE_READ : LockType.READ;
        }
    }

    @Override
    public Lock transfer(Long nodeId, Locker currentLocker, Locker destLocker, MemoryBudget mb, int lockTableIndex) throws DatabaseException {
        LockImpl newLock = new LockImpl(new LockInfo(this.locker, this.lockType));
        return newLock.transfer(nodeId, currentLocker, destLocker, mb, lockTableIndex);
    }

    @Override
    public Lock transferMultiple(Long nodeId, Locker currentLocker, Locker[] destLockers, MemoryBudget mb, int lockTableIndex) throws DatabaseException {
        LockImpl newLock = new LockImpl(new LockInfo(this.locker, this.lockType));
        return newLock.transferMultiple(nodeId, currentLocker, destLockers, mb, lockTableIndex);
    }

    @Override
    public boolean isThin() {
        return true;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" ThinLockAddr:").append(System.identityHashCode(this));
        sb.append(" Owner:");
        if (this.nOwners() == 0) {
            sb.append(" (none)");
        } else {
            sb.append(this.locker);
        }
        sb.append(" Waiters: (none)");
        return sb.toString();
    }
}

