/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.LockNotGrantedException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.BuddyLocker;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockManager;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.TxnManager;
import com.sleepycat.je.txn.WriteLockInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class Locker {
    private static final String DEBUG_NAME = Locker.class.getName();
    protected EnvironmentImpl envImpl;
    protected LockManager lockManager;
    protected long id;
    protected boolean readUncommittedDefault;
    protected boolean defaultNoWait;
    private long lockTimeoutMillis;
    private long txnTimeoutMillis;
    private long txnStartMillis;
    private Lock waitingFor;
    protected Map<Long, BINReference> deleteInfo;
    protected Map<Long, Set<Database>> handleLockToHandleMap;
    protected Map<Database, Long> handleToHandleLockMap;
    protected Thread thread;
    private boolean isOpen = true;
    private boolean noAPIReadLock = false;

    protected Locker(EnvironmentImpl envImpl, boolean readUncommittedDefault, boolean noWait, long mandatedId) throws DatabaseException {
        this.initLocker(envImpl, readUncommittedDefault, noWait, false, mandatedId);
    }

    protected Locker(EnvironmentImpl envImpl, boolean readUncommittedDefault, boolean noWait, boolean noAPIReadLock, long mandatedId) throws DatabaseException {
        this.initLocker(envImpl, readUncommittedDefault, noWait, noAPIReadLock, mandatedId);
    }

    private void initLocker(EnvironmentImpl envImpl, boolean readUncommittedDefault, boolean noWait, boolean noAPIReadLock, long mandatedId) throws DatabaseException {
        TxnManager txnManager = envImpl.getTxnManager();
        this.lockManager = txnManager.getLockManager();
        this.id = this.generateId(txnManager, mandatedId);
        this.envImpl = envImpl;
        this.readUncommittedDefault = readUncommittedDefault;
        this.waitingFor = null;
        this.defaultNoWait = noWait;
        this.lockTimeoutMillis = envImpl.getLockTimeout();
        this.txnTimeoutMillis = envImpl.getTxnTimeout();
        this.txnStartMillis = this.txnTimeoutMillis != 0L ? System.currentTimeMillis() : 0L;
        this.thread = Thread.currentThread();
        this.noAPIReadLock = noAPIReadLock;
    }

    Locker() {
    }

    protected abstract long generateId(TxnManager var1, long var2);

    public long getId() {
        return this.id;
    }

    public boolean getDefaultNoWait() {
        return this.defaultNoWait;
    }

    public synchronized long getLockTimeout() {
        return this.lockTimeoutMillis;
    }

    public synchronized void setLockTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("the timeout value cannot be negative");
        }
        if ((double)timeout > Math.pow(2.0, 32.0)) {
            throw new IllegalArgumentException("the timeout value cannot be greater than 2^32");
        }
        this.lockTimeoutMillis = timeout;
    }

    public boolean isReadUncommittedDefault() {
        return this.readUncommittedDefault;
    }

    Lock getWaitingFor() {
        return this.waitingFor;
    }

    void setWaitingFor(Lock lock) {
        this.waitingFor = lock;
    }

    public void setOnlyAbortable() {
    }

    public void initApiReadLock() throws DatabaseException {
        if (!this.noAPIReadLock) {
            this.envImpl.acquireAPIReadLock(this);
        }
    }

    abstract LockResult lockInternal(long var1, LockType var3, boolean var4, DatabaseImpl var5) throws DeadlockException, DatabaseException;

    public LockResult lock(long nodeId, LockType lockType, boolean noWait, DatabaseImpl database) throws LockNotGrantedException, DeadlockException, DatabaseException {
        assert (this.isOpen);
        LockResult result = this.lockInternal(nodeId, lockType, noWait, database);
        if (result.getLockGrant() == LockGrantType.DENIED) {
            throw new LockNotGrantedException("Non-blocking lock was denied.");
        }
        return result;
    }

    public LockResult nonBlockingLock(long nodeId, LockType lockType, DatabaseImpl database) throws DatabaseException {
        assert (this.isOpen);
        return this.lockInternal(nodeId, lockType, true, database);
    }

    public boolean releaseLock(long nodeId) throws DatabaseException {
        assert (this.isOpen);
        boolean ret = this.lockManager.release(nodeId, this);
        this.removeLock(nodeId);
        return ret;
    }

    public void demoteLock(long nodeId) throws DatabaseException {
        assert (this.isOpen);
        this.lockManager.demote(nodeId, this);
    }

    public abstract boolean isTransactional();

    public abstract boolean isSerializableIsolation();

    public abstract boolean isReadCommittedIsolation();

    public abstract Txn getTxnLocker();

    public abstract Locker newNonTxnLocker() throws DatabaseException;

    public abstract void releaseNonTxnLocks() throws DatabaseException;

    public abstract void nonTxnOperationEnd() throws DatabaseException;

    public boolean sharesLocksWith(Locker other) {
        if (other instanceof BuddyLocker) {
            BuddyLocker buddy = (BuddyLocker)other;
            return buddy.getBuddy() == this;
        }
        return false;
    }

    public final void operationEnd() throws DatabaseException {
        this.operationEnd(true);
    }

    public final void operationEnd(OperationStatus status) throws DatabaseException {
        this.operationEnd(status == OperationStatus.SUCCESS);
    }

    public abstract void operationEnd(boolean var1) throws DatabaseException;

    void close() throws DatabaseException {
        if (!this.noAPIReadLock) {
            this.envImpl.releaseAPIReadLock(this);
        }
        this.isOpen = false;
    }

    public abstract void setHandleLockOwner(boolean var1, Database var2, boolean var3) throws DatabaseException;

    public abstract void registerCursor(CursorImpl var1) throws DatabaseException;

    public abstract void unRegisterCursor(CursorImpl var1) throws DatabaseException;

    public abstract WriteLockInfo getWriteLockInfo(long var1) throws DatabaseException;

    public abstract void markDeleteAtTxnEnd(DatabaseImpl var1, boolean var2) throws DatabaseException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeleteInfo(BIN bin, Key deletedKey) throws DatabaseException {
        Locker locker = this;
        synchronized (locker) {
            Long nodeId;
            BINReference binRef;
            if (this.deleteInfo == null) {
                this.deleteInfo = new HashMap<Long, BINReference>();
            }
            if ((binRef = this.deleteInfo.get(nodeId = Long.valueOf(bin.getNodeId()))) == null) {
                binRef = bin.createReference();
                this.deleteInfo.put(nodeId, binRef);
            }
            binRef.addDeletedKey(deletedKey);
        }
    }

    protected abstract void addLock(Long var1, LockType var2, LockGrantType var3) throws DatabaseException;

    public abstract boolean createdNode(long var1) throws DatabaseException;

    abstract void removeLock(long var1) throws DatabaseException;

    abstract void moveWriteToReadLock(long var1, Lock var3);

    public boolean isTimedOut() throws DatabaseException {
        long diff;
        long timeout = this.getTxnTimeout();
        return timeout != 0L && (diff = System.currentTimeMillis() - this.txnStartMillis) > timeout;
    }

    public synchronized long getTxnTimeout() {
        return this.txnTimeoutMillis;
    }

    long getTxnStartMillis() {
        return this.txnStartMillis;
    }

    void unregisterHandle(Database dbHandle) {
        if (this.handleToHandleLockMap != null) {
            this.handleToHandleLockMap.remove(dbHandle);
        }
    }

    public void addToHandleMaps(Long handleLockId, Database databaseHandle) {
        Set<Database> dbHandleSet = null;
        if (this.handleLockToHandleMap == null) {
            this.handleLockToHandleMap = new Hashtable<Long, Set<Database>>();
            this.handleToHandleLockMap = new Hashtable<Database, Long>();
        } else {
            dbHandleSet = this.handleLockToHandleMap.get(handleLockId);
        }
        if (dbHandleSet == null) {
            dbHandleSet = new HashSet<Database>();
            this.handleLockToHandleMap.put(handleLockId, dbHandleSet);
        }
        dbHandleSet.add(databaseHandle);
        this.handleToHandleLockMap.put(databaseHandle, handleLockId);
    }

    void transferHandleLockToHandle(Database dbHandle) throws DatabaseException {
        BasicLocker holderTxn = BasicLocker.createBasicLocker(this.envImpl, false, true);
        this.transferHandleLock(dbHandle, holderTxn, true);
    }

    public void transferHandleLock(Database dbHandle, Locker destLocker, boolean demoteToRead) throws DatabaseException {
        Long handleLockId;
        if (DbInternal.dbGetDatabaseImpl(dbHandle) != null && (handleLockId = this.handleToHandleLockMap.get(dbHandle)) != null) {
            long nodeId = handleLockId;
            this.lockManager.transfer(nodeId, this, destLocker, demoteToRead);
            destLocker.addToHandleMaps(handleLockId, dbHandle);
            Set<Database> dbHandleSet = this.handleLockToHandleMap.get(handleLockId);
            Iterator<Database> iter = dbHandleSet.iterator();
            while (iter.hasNext()) {
                if (iter.next() != dbHandle) continue;
                iter.remove();
                break;
            }
            if (dbHandleSet.size() == 0) {
                this.handleLockToHandleMap.remove(handleLockId);
            }
            DbInternal.dbSetHandleLocker(dbHandle, destLocker);
        }
    }

    public String toString() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        return System.identityHashCode(this) + " " + Long.toString(this.id) + "_" + (this.thread == null ? "" : this.thread.getName()) + "_" + className;
    }
}

