/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.latch.LatchNotHeldException;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.TreeUtils;
import java.nio.ByteBuffer;

public abstract class Node
implements Loggable {
    private long nodeId;

    protected Node() {
    }

    protected Node(EnvironmentImpl envImpl, boolean replicated) {
        this.nodeId = replicated ? envImpl.getNodeSequence().getNextReplicatedNodeId() : envImpl.getNodeSequence().getNextLocalNodeId();
    }

    public void postFetchInit(DatabaseImpl db, long sourceLsn) throws DatabaseException {
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public void latchShared() throws DatabaseException {
    }

    public void latchShared(CacheMode ignore) throws DatabaseException {
    }

    public void releaseLatch() throws LatchNotHeldException {
    }

    public void verify(byte[] maxKey) throws DatabaseException {
    }

    public boolean containsDuplicates() {
        return false;
    }

    public int getLevel() {
        return 0;
    }

    boolean matchLNByNodeId(TreeLocation location, long nodeId, CacheMode cachemode) throws DatabaseException {
        throw new DatabaseException("matchLNByNodeId called on non DIN/DBIN");
    }

    abstract void rebuildINList(INList var1) throws DatabaseException;

    abstract void accountForSubtreeRemoval(INList var1, LocalUtilizationTracker var2) throws DatabaseException;

    abstract boolean isValidForDelete() throws DatabaseException;

    protected abstract boolean isSoughtNode(long var1, CacheMode var3) throws DatabaseException;

    protected abstract boolean canBeAncestor(boolean var1);

    protected long getMemorySizeIncludedByParent() {
        return 0L;
    }

    public String toString() {
        return this.dumpString(0, true);
    }

    private String beginTag() {
        return "<node>";
    }

    private String endTag() {
        return "</node>";
    }

    String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer self = new StringBuffer();
        self.append(TreeUtils.indent(nSpaces));
        if (dumpTags) {
            self.append(this.beginTag());
        }
        self.append(this.nodeId);
        if (dumpTags) {
            self.append(this.endTag());
        }
        return self.toString();
    }

    public abstract LogEntryType getLogType();

    public int getLogSize() {
        return LogUtils.getPackedLongLogSize(this.nodeId);
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writePackedLong(logBuffer, this.nodeId);
    }

    public void readFromLog(ByteBuffer itemBuffer, byte entryVersion) throws LogException {
        this.nodeId = LogUtils.readLong(itemBuffer, entryVersion < 6);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<node>");
        sb.append(this.nodeId);
        sb.append("</node>");
    }
}

