/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.log.Loggable;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DbOperationType implements Loggable
{
    NONE(0),
    CREATE(1),
    REMOVE(2),
    TRUNCATE(3),
    RENAME(4);

    private byte value;

    private DbOperationType(byte value) {
        this.value = value;
    }

    public static DbOperationType readTypeFromLog(ByteBuffer entryBuffer, byte entryVersion) {
        byte opVal = entryBuffer.get();
        switch (opVal) {
            case 1: {
                return CREATE;
            }
            case 2: {
                return REMOVE;
            }
            case 3: {
                return TRUNCATE;
            }
            case 4: {
                return RENAME;
            }
        }
        return NONE;
    }

    @Override
    public int getLogSize() {
        return 1;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        logBuffer.put(this.value);
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, byte entryVersion) {
        this.value = itemBuffer.get();
    }

    @Override
    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<DbOp val=\"").append(this).append("\"/>");
    }
}

