/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import java.io.File;
import java.io.FilenameFilter;
import java.util.StringTokenizer;

class JEFileFilter
implements FilenameFilter {
    String[] suffix;
    long minFileNumber = 0L;
    long maxFileNumber = -1L;

    JEFileFilter(String[] suffix) {
        this.suffix = suffix;
    }

    private boolean matches(String fileSuffix) {
        for (int i = 0; i < this.suffix.length; ++i) {
            if (!fileSuffix.equalsIgnoreCase(this.suffix[i])) continue;
            return true;
        }
        return false;
    }

    public boolean accept(File dir, String name) {
        boolean ok = false;
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        int nTokens = tokenizer.countTokens();
        if (nTokens == 2 || nTokens == 3) {
            String fileVersion;
            boolean hasVersion = nTokens == 3;
            String fileNumber = tokenizer.nextToken();
            String fileSuffix = "." + tokenizer.nextToken();
            String string = fileVersion = hasVersion ? tokenizer.nextToken() : null;
            if (fileNumber.length() == 8 && this.matches(fileSuffix)) {
                try {
                    long fileNum = Long.parseLong(fileNumber, 16);
                    if (fileNum < this.minFileNumber) {
                        ok = false;
                    } else if (fileNum <= this.maxFileNumber || this.maxFileNumber == -1L) {
                        ok = true;
                    }
                }
                catch (NumberFormatException e) {
                    ok = false;
                }
                if (hasVersion) {
                    try {
                        Integer.parseInt(fileVersion);
                        ok = true;
                    }
                    catch (NumberFormatException e) {
                        ok = false;
                    }
                }
            }
        }
        return ok;
    }
}

