/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import java.nio.ByteBuffer;

public class ReplicatedDatabaseConfig
implements Loggable {
    private byte flags;
    private int maxMainTreeEntriesPerNode;
    private int maxDupTreeEntriesPerNode;
    private byte[] btreeComparatorBytes = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
    private byte[] duplicateComparatorBytes = LogUtils.ZERO_LENGTH_BYTE_ARRAY;

    public ReplicatedDatabaseConfig() {
    }

    ReplicatedDatabaseConfig(byte flags, int maxMainTreeEntriesPerNode, int maxDupTreeEntriesPerNode, byte[] btreeComparatorBytes, byte[] duplicateComparatorBytes) {
        this.flags = flags;
        this.maxMainTreeEntriesPerNode = maxMainTreeEntriesPerNode;
        this.maxDupTreeEntriesPerNode = maxDupTreeEntriesPerNode;
        if (btreeComparatorBytes != null) {
            this.btreeComparatorBytes = btreeComparatorBytes;
        }
        if (duplicateComparatorBytes != null) {
            this.duplicateComparatorBytes = duplicateComparatorBytes;
        }
    }

    public int getLogSize() {
        return 1 + LogUtils.getPackedIntLogSize(this.maxMainTreeEntriesPerNode) + LogUtils.getPackedIntLogSize(this.maxDupTreeEntriesPerNode) + LogUtils.getByteArrayLogSize(this.btreeComparatorBytes) + LogUtils.getByteArrayLogSize(this.duplicateComparatorBytes);
    }

    public void writeToLog(ByteBuffer logBuffer) {
        logBuffer.put(this.flags);
        LogUtils.writePackedInt(logBuffer, this.maxMainTreeEntriesPerNode);
        LogUtils.writePackedInt(logBuffer, this.maxDupTreeEntriesPerNode);
        LogUtils.writeByteArray(logBuffer, this.btreeComparatorBytes);
        LogUtils.writeByteArray(logBuffer, this.duplicateComparatorBytes);
    }

    public void readFromLog(ByteBuffer itemBuffer, byte entryVersion) throws LogException {
        this.flags = itemBuffer.get();
        this.maxMainTreeEntriesPerNode = LogUtils.readInt(itemBuffer, false);
        this.maxDupTreeEntriesPerNode = LogUtils.readInt(itemBuffer, false);
        this.btreeComparatorBytes = LogUtils.readByteArray(itemBuffer, false);
        this.duplicateComparatorBytes = LogUtils.readByteArray(itemBuffer, false);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<config ");
        DatabaseImpl.dumpFlags(sb, verbose, this.flags);
        sb.append(" btcmpSet=\"").append(this.btreeComparatorBytes != LogUtils.ZERO_LENGTH_BYTE_ARRAY);
        sb.append("\" dupcmpSet=\"").append(this.duplicateComparatorBytes != LogUtils.ZERO_LENGTH_BYTE_ARRAY).append("\"");
        sb.append(" />");
    }
}

