/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.config;

import com.sleepycat.je.config.EnvironmentParams;

public class ConfigParam {
    protected String name;
    private String defaultValue;
    private boolean mutable;
    private boolean forReplication;
    private boolean isMultiValueParam;

    public ConfigParam(String configName, String configDefault, boolean mutable, boolean forReplication) throws IllegalArgumentException {
        if (configName == null) {
            this.name = null;
        } else {
            int mvFlagIdx = configName.indexOf(".#");
            if (mvFlagIdx < 0) {
                this.name = configName;
                this.isMultiValueParam = false;
            } else {
                this.name = configName.substring(0, mvFlagIdx);
                this.isMultiValueParam = true;
            }
        }
        this.defaultValue = configDefault;
        this.mutable = mutable;
        this.forReplication = forReplication;
        this.validateName(configName);
        this.validateValue(configDefault);
        EnvironmentParams.addSupportedParam(this);
    }

    public static String multiValueParamName(String paramName) {
        int mvParamIdx = paramName.lastIndexOf(46);
        if (mvParamIdx < 0) {
            return null;
        }
        return paramName.substring(0, mvParamIdx);
    }

    public String getName() {
        return this.name;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean isForReplication() {
        return this.forReplication;
    }

    public boolean isMultiValueParam() {
        return this.isMultiValueParam;
    }

    private void validateName(String name) throws IllegalArgumentException {
        if (name == null || name.length() < 1) {
            throw new IllegalArgumentException(" A configuration parameter name can't be null or 0 length");
        }
    }

    public void validateValue(String value) throws IllegalArgumentException {
    }

    public String toString() {
        return this.name;
    }
}

