/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.ExceptionListener;
import com.sleepycat.je.cleaner.FileProcessor;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.cleaner.LNInfo;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.PropUtil;
import com.sleepycat.je.utilint.Tracer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cleaner
implements EnvConfigObserver {
    static final CacheMode UPDATE_GENERATION = CacheMode.UNCHANGED;
    long nCleanerRuns = 0L;
    long nCleanerDeletions = 0L;
    long nINsObsolete = 0L;
    long nINsCleaned = 0L;
    long nINsDead = 0L;
    long nINsMigrated = 0L;
    long nLNsObsolete = 0L;
    long nLNsCleaned = 0L;
    long nLNsDead = 0L;
    long nLNsLocked = 0L;
    long nLNsMigrated = 0L;
    long nLNsMarked = 0L;
    long nLNQueueHits = 0L;
    long nPendingLNsProcessed = 0L;
    long nMarkedLNsProcessed = 0L;
    long nToBeCleanedLNsProcessed = 0L;
    long nClusterLNsProcessed = 0L;
    long nPendingLNsLocked = 0L;
    long nEntriesRead = 0L;
    long nRepeatIteratorReads = 0L;
    long lockTimeout;
    int readBufferSize;
    int lookAheadCacheSize;
    long nDeadlockRetries;
    boolean expunge;
    boolean clusterResident;
    boolean clusterAll;
    int maxBatchFiles;
    Level detailedTraceLevel;
    long cleanerBytesInterval;
    boolean trackDetail;
    boolean fetchObsoleteSize;
    boolean lazyMigration;
    private Set<Long> toBeCleanedFiles = Collections.emptySet();
    private Set<Long> lowUtilizationFiles = Collections.emptySet();
    private String name;
    private EnvironmentImpl env;
    private UtilizationProfile profile;
    private UtilizationTracker tracker;
    private FileSelector fileSelector;
    private FileProcessor[] threads;
    private Object deleteFileLock;
    private int deleteProhibited;

    public Cleaner(EnvironmentImpl env, String name) throws DatabaseException {
        this.env = env;
        this.name = name;
        this.tracker = new UtilizationTracker(env, this);
        this.profile = new UtilizationProfile(env, this.tracker);
        this.fileSelector = new FileSelector();
        this.threads = new FileProcessor[0];
        this.deleteFileLock = new Object();
        this.trackDetail = env.getConfigManager().getBoolean(EnvironmentParams.CLEANER_TRACK_DETAIL);
        this.envConfigUpdate(env.getConfigManager(), null);
        env.addConfigObserver(this);
    }

    public void envConfigUpdate(DbConfigManager cm, EnvironmentMutableConfig ignore) throws DatabaseException {
        this.lockTimeout = PropUtil.microsToMillis(cm.getLong(EnvironmentParams.CLEANER_LOCK_TIMEOUT));
        this.readBufferSize = cm.getInt(EnvironmentParams.CLEANER_READ_SIZE);
        if (this.readBufferSize <= 0) {
            this.readBufferSize = cm.getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        }
        this.lookAheadCacheSize = cm.getInt(EnvironmentParams.CLEANER_LOOK_AHEAD_CACHE_SIZE);
        this.nDeadlockRetries = cm.getInt(EnvironmentParams.CLEANER_DEADLOCK_RETRY);
        this.expunge = cm.getBoolean(EnvironmentParams.CLEANER_REMOVE);
        this.clusterResident = cm.getBoolean(EnvironmentParams.CLEANER_CLUSTER);
        this.clusterAll = cm.getBoolean(EnvironmentParams.CLEANER_CLUSTER_ALL);
        this.maxBatchFiles = cm.getInt(EnvironmentParams.CLEANER_MAX_BATCH_FILES);
        this.detailedTraceLevel = Tracer.parseLevel(this.env, EnvironmentParams.JE_LOGGING_LEVEL_CLEANER);
        if (this.clusterResident && this.clusterAll) {
            throw new IllegalArgumentException("Both " + EnvironmentParams.CLEANER_CLUSTER + " and " + EnvironmentParams.CLEANER_CLUSTER_ALL + " may not be set to true.");
        }
        int nThreads = cm.getInt(EnvironmentParams.CLEANER_THREADS);
        assert (nThreads > 0);
        if (nThreads != this.threads.length) {
            int i;
            for (int i2 = nThreads; i2 < this.threads.length; ++i2) {
                if (this.threads[i2] == null) continue;
                this.threads[i2].shutdown();
                this.threads[i2] = null;
            }
            FileProcessor[] newThreads = new FileProcessor[nThreads];
            for (i = 0; i < nThreads && i < this.threads.length; ++i) {
                newThreads[i] = this.threads[i];
            }
            this.threads = newThreads;
            for (i = 0; i < nThreads; ++i) {
                if (this.threads[i] != null) continue;
                this.threads[i] = new FileProcessor(this.name + '-' + (i + 1), this.env, this, this.profile, this.fileSelector);
            }
        }
        this.cleanerBytesInterval = cm.getLong(EnvironmentParams.CLEANER_BYTES_INTERVAL);
        if (this.cleanerBytesInterval == 0L) {
            this.cleanerBytesInterval = cm.getLong(EnvironmentParams.LOG_FILE_MAX) / 4L;
        }
        this.fetchObsoleteSize = cm.getBoolean(EnvironmentParams.CLEANER_FETCH_OBSOLETE_SIZE);
        this.lazyMigration = !cm.getBoolean(EnvironmentParams.CHECKPOINTER_HIGH_PRIORITY);
    }

    public UtilizationTracker getUtilizationTracker() {
        return this.tracker;
    }

    public UtilizationProfile getUtilizationProfile() {
        return this.profile;
    }

    public boolean getFetchObsoleteSize() {
        return this.fetchObsoleteSize;
    }

    public void runOrPause(boolean run) {
        if (!this.env.isNoLocking()) {
            for (int i = 0; i < this.threads.length; ++i) {
                FileProcessor processor = this.threads[i];
                if (processor == null) continue;
                processor.runOrPause(run);
            }
        }
    }

    public void wakeup() {
        for (int i = 0; i < this.threads.length; ++i) {
            if (this.threads[i] == null) continue;
            this.threads[i].wakeup();
        }
    }

    public void requestShutdown() {
        for (int i = 0; i < this.threads.length; ++i) {
            if (this.threads[i] == null) continue;
            this.threads[i].requestShutdown();
        }
    }

    public void shutdown() {
        for (int i = 0; i < this.threads.length; ++i) {
            if (this.threads[i] == null) continue;
            this.threads[i].shutdown();
            this.threads[i].clearEnv();
            this.threads[i] = null;
        }
    }

    private boolean areThreadsRunning() {
        for (int i = 0; i < this.threads.length; ++i) {
            if (this.threads[i] == null) continue;
            return this.threads[i].isRunning();
        }
        return false;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        for (int i = 0; i < this.threads.length; ++i) {
            if (this.threads[i] == null) continue;
            this.threads[i].setExceptionListener(exceptionListener);
        }
    }

    public int doClean(boolean cleanMultipleFiles, boolean forceCleaning) throws DatabaseException {
        FileProcessor processor = new FileProcessor("", this.env, this, this.profile, this.fileSelector);
        return processor.doClean(false, cleanMultipleFiles, forceCleaning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteSafeToDeleteFiles() throws DatabaseException {
        Object object = this.deleteFileLock;
        synchronized (object) {
            if (this.deleteProhibited > 0) {
                return;
            }
            Set<Long> safeFiles = this.fileSelector.copySafeToDeleteFiles();
            if (safeFiles == null) {
                return;
            }
            this.env.checkIfInvalid();
            if (this.env.mayNotWrite()) {
                return;
            }
            if (!this.env.getFileManager().lockEnvironment(false, true)) {
                Tracer.trace(Level.SEVERE, this.env, "Cleaner has " + safeFiles.size() + " files not deleted because of read-only processes.");
                return;
            }
            try {
                for (Long fileNum : safeFiles) {
                    long fileNumValue = fileNum;
                    boolean deleted = false;
                    try {
                        if (this.expunge) {
                            this.env.getFileManager().deleteFile(fileNumValue);
                        } else {
                            this.env.getFileManager().renameFile(fileNumValue, ".del");
                        }
                        deleted = true;
                    }
                    catch (DatabaseException e) {
                        this.traceFileNotDeleted(e, fileNumValue);
                    }
                    catch (IOException e) {
                        this.traceFileNotDeleted(e, fileNumValue);
                    }
                    if (deleted) {
                        Tracer.trace(Level.SEVERE, this.env, "Cleaner deleted file 0x" + Long.toHexString(fileNumValue));
                        try {
                            this.profile.removeFile(fileNum, this.fileSelector.getCleanedDatabases(fileNum));
                        }
                        finally {
                            this.fileSelector.removeDeletedFile(fileNum, this.env.getMemoryBudget());
                        }
                    }
                    ++this.nCleanerDeletions;
                }
            }
            finally {
                this.env.getFileManager().releaseExclusiveLock();
            }
        }
    }

    private void traceFileNotDeleted(Throwable e, long fileNum) throws DatabaseException {
        String msg = "Cleaner deleteSafeToDeleteFilesLog file 0x" + Long.toHexString(fileNum) + " could not be " + (this.expunge ? "deleted" : "renamed") + ".  This operation will be retried at the next checkpoint." + e.toString() + " FileSelector: " + this.fileSelector;
        Tracer.trace(this.env, "Cleaner", "deleteSafeToDeleteFiles", msg, e);
    }

    public FileSelector.CheckpointStartCleanerState getFilesAtCheckpointStart() throws DatabaseException {
        this.processPending();
        return this.fileSelector.getFilesAtCheckpointStart();
    }

    public void updateFilesAtCheckpointEnd(FileSelector.CheckpointStartCleanerState info) throws DatabaseException {
        this.fileSelector.updateFilesAtCheckpointEnd(info);
        this.deleteSafeToDeleteFiles();
    }

    public void updateReadOnlyFileCollections() {
        this.toBeCleanedFiles = this.fileSelector.getToBeCleanedFiles();
        this.lowUtilizationFiles = this.fileSelector.getLowUtilizationFiles();
    }

    final int getBacklog() {
        return this.toBeCleanedFiles.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processPending() throws DatabaseException {
        DatabaseId[] pendingDBs;
        int i;
        DbTree dbMapTree = this.env.getDbTree();
        LNInfo[] pendingLNs = this.fileSelector.getPendingLNs();
        if (pendingLNs != null) {
            TreeLocation location = new TreeLocation();
            for (i = 0; i < pendingLNs.length; ++i) {
                LNInfo info = pendingLNs[i];
                DatabaseId dbId = info.getDbId();
                DatabaseImpl db = dbMapTree.getDb(dbId, this.lockTimeout);
                try {
                    byte[] key = info.getKey();
                    byte[] dupKey = info.getDupKey();
                    LN ln = info.getLN();
                    this.env.getEvictor().doCriticalEviction(true);
                    this.processPendingLN(ln, db, key, dupKey, location);
                }
                finally {
                    dbMapTree.releaseDb(db);
                }
                this.env.sleepAfterBackgroundIO();
            }
        }
        if ((pendingDBs = this.fileSelector.getPendingDBs()) != null) {
            for (i = 0; i < pendingDBs.length; ++i) {
                DatabaseId dbId = pendingDBs[i];
                DatabaseImpl db = dbMapTree.getDb(dbId, this.lockTimeout);
                try {
                    if (db != null && !db.isDeleteFinished()) continue;
                    this.fileSelector.removePendingDB(dbId);
                    continue;
                }
                finally {
                    dbMapTree.releaseDb(db);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processPendingLN(LN ln, DatabaseImpl db, byte[] key, byte[] dupKey, TreeLocation location) throws DatabaseException {
        IN parentDIN;
        IN bin;
        Locker locker;
        boolean completed;
        boolean obsolete;
        boolean lockDenied;
        boolean processedHere;
        block34: {
            block33: {
                block32: {
                    block30: {
                        block31: {
                            boolean parentFound = false;
                            processedHere = true;
                            lockDenied = false;
                            obsolete = false;
                            completed = false;
                            locker = null;
                            bin = null;
                            parentDIN = null;
                            try {
                                try {
                                    ++this.nPendingLNsProcessed;
                                    if (db == null || db.isDeleted()) {
                                        this.addPendingDB(db);
                                        ++this.nLNsDead;
                                        obsolete = true;
                                        completed = true;
                                        Object var19_14 = null;
                                        if (parentDIN == null) break block30;
                                        break block31;
                                    }
                                    Tree tree = db.getTree();
                                    assert (tree != null);
                                    locker = BasicLocker.createBasicLocker(this.env, false, true);
                                    LockResult lockRet = locker.nonBlockingLock(ln.getNodeId(), LockType.READ, db);
                                    if (lockRet.getLockGrant() == LockGrantType.DENIED) {
                                        ++this.nPendingLNsLocked;
                                        lockDenied = true;
                                        completed = true;
                                        break block32;
                                    }
                                    parentFound = tree.getParentBINForChildLN(location, key, dupKey, ln, false, true, true, UPDATE_GENERATION);
                                    bin = location.bin;
                                    int index = location.index;
                                    if (!parentFound) {
                                        ++this.nLNsDead;
                                        obsolete = true;
                                        completed = true;
                                        break block33;
                                    }
                                    if (ln.containsDuplicates()) {
                                        parentDIN = (DIN)bin.fetchTarget(index);
                                        parentDIN.latch(UPDATE_GENERATION);
                                        ChildReference dclRef = ((DIN)parentDIN).getDupCountLNRef();
                                        processedHere = false;
                                        this.migrateDupCountLN(db, dclRef.getLsn(), (DIN)parentDIN, dclRef, true, true, ln.getNodeId(), "CleanPendingLN:");
                                    } else {
                                        processedHere = false;
                                        this.migrateLN(db, bin.getLsn(index), (BIN)bin, index, true, true, ln.getNodeId(), true, "CleanPendingLN:");
                                    }
                                    completed = true;
                                    break block34;
                                }
                                catch (DatabaseException DBE) {
                                    DBE.printStackTrace();
                                    Tracer.trace(this.env, "com.sleepycat.je.cleaner.Cleaner", "processLN", "Exception thrown: ", DBE);
                                    throw DBE;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var19_18 = null;
                                if (parentDIN != null) {
                                    parentDIN.releaseLatch();
                                }
                                if (bin != null) {
                                    bin.releaseLatch();
                                }
                                if (locker != null) {
                                    locker.operationEnd();
                                }
                                if (!processedHere) throw throwable;
                                if (completed && !lockDenied) {
                                    this.fileSelector.removePendingLN(ln.getNodeId());
                                }
                                this.trace(this.detailedTraceLevel, "CleanPendingLN:", ln, -1L, completed, obsolete, false);
                                throw throwable;
                            }
                        }
                        parentDIN.releaseLatch();
                    }
                    if (bin != null) {
                        bin.releaseLatch();
                    }
                    if (locker != null) {
                        locker.operationEnd();
                    }
                    if (!processedHere) return;
                    if (completed && !lockDenied) {
                        this.fileSelector.removePendingLN(ln.getNodeId());
                    }
                    this.trace(this.detailedTraceLevel, "CleanPendingLN:", ln, -1L, completed, obsolete, false);
                    return;
                }
                Object var19_15 = null;
                if (parentDIN != null) {
                    parentDIN.releaseLatch();
                }
                if (bin != null) {
                    bin.releaseLatch();
                }
                if (locker != null) {
                    locker.operationEnd();
                }
                if (!processedHere) return;
                if (completed && !lockDenied) {
                    this.fileSelector.removePendingLN(ln.getNodeId());
                }
                this.trace(this.detailedTraceLevel, "CleanPendingLN:", ln, -1L, completed, obsolete, false);
                return;
            }
            Object var19_16 = null;
            if (parentDIN != null) {
                parentDIN.releaseLatch();
            }
            if (bin != null) {
                bin.releaseLatch();
            }
            if (locker != null) {
                locker.operationEnd();
            }
            if (!processedHere) return;
            if (completed && !lockDenied) {
                this.fileSelector.removePendingLN(ln.getNodeId());
            }
            this.trace(this.detailedTraceLevel, "CleanPendingLN:", ln, -1L, completed, obsolete, false);
            return;
        }
        Object var19_17 = null;
        if (parentDIN != null) {
            parentDIN.releaseLatch();
        }
        if (bin != null) {
            bin.releaseLatch();
        }
        if (locker != null) {
            locker.operationEnd();
        }
        if (!processedHere) return;
        if (completed && !lockDenied) {
            this.fileSelector.removePendingLN(ln.getNodeId());
        }
        this.trace(this.detailedTraceLevel, "CleanPendingLN:", ln, -1L, completed, obsolete, false);
    }

    public boolean isEvictable(BIN bin, int index) {
        if (bin.getDirty()) {
            if (bin.getMigrate(index)) {
                return false;
            }
            long lsn = bin.getLsn(index);
            if (lsn == -1L) {
                return true;
            }
            boolean isResident = bin.getTarget(index) != null;
            Long fileNum = DbLsn.getFileNumber(lsn);
            if (this.toBeCleanedFiles.contains(fileNum)) {
                return false;
            }
            if ((this.clusterAll || this.clusterResident && isResident) && this.lowUtilizationFiles.contains(fileNum)) {
                return false;
            }
        }
        return true;
    }

    public void lazyMigrateLNs(final BIN bin, boolean proactiveMigration, boolean backgroundIO) throws DatabaseException {
        DatabaseImpl db = bin.getDatabase();
        boolean isBinInDupDb = db.getSortedDuplicates() && !bin.containsDuplicates();
        Integer[] sortedIndices = null;
        int nSortedIndices = 0;
        int nEntries = bin.getNEntries();
        for (int index = 0; index < nEntries; ++index) {
            boolean migrateFlag = bin.getMigrate(index);
            boolean isResident = bin.getTarget(index) != null;
            long childLsn = bin.getLsn(index);
            if (childLsn == -1L || !this.shouldMigrateLN(migrateFlag, isResident, proactiveMigration, isBinInDupDb, childLsn)) continue;
            if (isResident) {
                this.migrateLN(db, childLsn, bin, index, migrateFlag, false, 0L, backgroundIO, "CleanMigrateLN:");
                continue;
            }
            if (sortedIndices == null) {
                sortedIndices = new Integer[nEntries];
            }
            sortedIndices[nSortedIndices++] = index;
        }
        if (sortedIndices != null) {
            Arrays.sort(sortedIndices, 0, nSortedIndices, new Comparator<Integer>(){

                @Override
                public int compare(Integer int1, Integer int2) {
                    return DbLsn.compareTo(bin.getLsn(int1), bin.getLsn(int2));
                }
            });
            for (int i = 0; i < nSortedIndices; ++i) {
                int index = sortedIndices[i].intValue();
                long childLsn = bin.getLsn(index);
                boolean migrateFlag = bin.getMigrate(index);
                this.migrateLN(db, childLsn, bin, index, migrateFlag, false, 0L, backgroundIO, "CleanMigrateLN:");
            }
        }
    }

    public void lazyMigrateDupCountLN(DIN din, ChildReference dclRef, boolean proactiveMigration) throws DatabaseException {
        long childLsn;
        boolean isBinInDupDb;
        boolean isResident;
        DatabaseImpl db = din.getDatabase();
        boolean migrateFlag = dclRef.getMigrate();
        if (this.shouldMigrateLN(migrateFlag, isResident = dclRef.getTarget() != null, proactiveMigration, isBinInDupDb = false, childLsn = dclRef.getLsn())) {
            this.migrateDupCountLN(db, childLsn, din, dclRef, migrateFlag, false, 0L, "CleanMigrateLN:");
        }
    }

    private boolean shouldMigrateLN(boolean migrateFlag, boolean isResident, boolean proactiveMigration, boolean isBinInDupDb, long childLsn) {
        boolean doMigration = false;
        if (migrateFlag) {
            doMigration = true;
            ++this.nMarkedLNsProcessed;
        } else if (proactiveMigration && !isBinInDupDb && !this.env.isClosing()) {
            Long fileNum = DbLsn.getFileNumber(childLsn);
            if (this.toBeCleanedFiles.contains(fileNum)) {
                doMigration = true;
                ++this.nToBeCleanedLNsProcessed;
            } else if ((this.clusterAll || this.clusterResident && isResident) && this.lowUtilizationFiles.contains(fileNum)) {
                doMigration = true;
                ++this.nClusterLNsProcessed;
            }
        }
        return doMigration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void migrateLN(DatabaseImpl db, long lsn, BIN bin, int index, boolean wasCleaned, boolean isPending, long lockedPendingNodeId, boolean backgroundIO, String cleanAction) throws DatabaseException {
        LN ln;
        Locker locker;
        boolean clearTarget;
        boolean completed;
        boolean lockDenied;
        boolean migrated;
        boolean obsolete;
        block65: {
            block64: {
                block63: {
                    block62: {
                        block61: {
                            block60: {
                                block59: {
                                    obsolete = false;
                                    migrated = false;
                                    lockDenied = false;
                                    completed = false;
                                    clearTarget = false;
                                    locker = null;
                                    ln = null;
                                    try {
                                        Long fileNum;
                                        LockResult lockRet;
                                        if (lsn == -1L) {
                                            completed = true;
                                            Object var23_17 = null;
                                            if (!isPending) break block59;
                                            if (completed && !lockDenied) {
                                                this.fileSelector.removePendingLN(lockedPendingNodeId);
                                            }
                                            break block60;
                                        }
                                        if (!bin.isEntryKnownDeleted(index) && (ln = (LN)bin.getTarget(index)) == null) {
                                            ln = (LN)bin.fetchTarget(index);
                                            boolean bl = clearTarget = !db.getId().equals(DbTree.ID_DB_ID);
                                        }
                                        if (ln == null) {
                                            if (wasCleaned) {
                                                ++this.nLNsDead;
                                            }
                                            obsolete = true;
                                            completed = true;
                                            break block61;
                                        }
                                        if (lockedPendingNodeId != ln.getNodeId() && (lockRet = (locker = BasicLocker.createBasicLocker(this.env, false, true)).nonBlockingLock(ln.getNodeId(), LockType.READ, db)).getLockGrant() == LockGrantType.DENIED) {
                                            if (wasCleaned) {
                                                ++this.nLNsLocked;
                                            }
                                            lockDenied = true;
                                            completed = true;
                                            break block62;
                                        }
                                        if (ln.isDeleted()) {
                                            bin.setKnownDeletedLeaveTarget(index);
                                            if (wasCleaned) {
                                                ++this.nLNsDead;
                                            }
                                            obsolete = true;
                                            completed = true;
                                            break block63;
                                        }
                                        if (bin.getMigrate(index) && !this.fileSelector.isFileCleaningInProgress(fileNum = Long.valueOf(DbLsn.getFileNumber(lsn)))) {
                                            obsolete = true;
                                            completed = true;
                                            if (wasCleaned) {
                                                ++this.nLNsDead;
                                            }
                                            break block64;
                                        }
                                        byte[] key = this.getLNMainKey(bin, index);
                                        long newLNLsn = ln.log(this.env, db, key, lsn, locker, backgroundIO, ReplicationContext.NO_REPLICATE);
                                        bin.updateEntry(index, newLNLsn);
                                        ++this.nLNsMigrated;
                                        migrated = true;
                                        completed = true;
                                        break block65;
                                    }
                                    catch (Throwable throwable) {
                                        Object var23_23 = null;
                                        if (isPending) {
                                            if (completed && !lockDenied) {
                                                this.fileSelector.removePendingLN(lockedPendingNodeId);
                                            }
                                        } else if (bin.getMigrate(index) && (!completed || lockDenied) && ln != null) {
                                            byte[] key = this.getLNMainKey(bin, index);
                                            byte[] dupKey = this.getLNDupKey(bin, index, ln);
                                            this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                                            if (!this.areThreadsRunning()) {
                                                this.env.getUtilizationTracker().activateCleaner();
                                            }
                                            clearTarget = false;
                                        }
                                        bin.setMigrate(index, false);
                                        if (clearTarget) {
                                            bin.updateNode(index, null, null);
                                        }
                                        if (locker != null) {
                                            locker.operationEnd();
                                        }
                                        this.trace(this.detailedTraceLevel, cleanAction, ln, lsn, completed, obsolete, migrated);
                                        throw throwable;
                                    }
                                }
                                if (bin.getMigrate(index) && (!completed || lockDenied) && ln != null) {
                                    byte[] key = this.getLNMainKey(bin, index);
                                    byte[] dupKey = this.getLNDupKey(bin, index, ln);
                                    this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                                    if (!this.areThreadsRunning()) {
                                        this.env.getUtilizationTracker().activateCleaner();
                                    }
                                    clearTarget = false;
                                }
                            }
                            bin.setMigrate(index, false);
                            if (clearTarget) {
                                bin.updateNode(index, null, null);
                            }
                            if (locker != null) {
                                locker.operationEnd();
                            }
                            this.trace(this.detailedTraceLevel, cleanAction, ln, lsn, completed, obsolete, migrated);
                            return;
                        }
                        Object var23_18 = null;
                        if (isPending) {
                            if (completed && !lockDenied) {
                                this.fileSelector.removePendingLN(lockedPendingNodeId);
                            }
                        } else if (bin.getMigrate(index) && (!completed || lockDenied) && ln != null) {
                            byte[] key = this.getLNMainKey(bin, index);
                            byte[] dupKey = this.getLNDupKey(bin, index, ln);
                            this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                            if (!this.areThreadsRunning()) {
                                this.env.getUtilizationTracker().activateCleaner();
                            }
                            clearTarget = false;
                        }
                        bin.setMigrate(index, false);
                        if (clearTarget) {
                            bin.updateNode(index, null, null);
                        }
                        if (locker != null) {
                            locker.operationEnd();
                        }
                        this.trace(this.detailedTraceLevel, cleanAction, ln, lsn, completed, obsolete, migrated);
                        return;
                    }
                    Object var23_19 = null;
                    if (isPending) {
                        if (completed && !lockDenied) {
                            this.fileSelector.removePendingLN(lockedPendingNodeId);
                        }
                    } else if (bin.getMigrate(index) && (!completed || lockDenied) && ln != null) {
                        byte[] key = this.getLNMainKey(bin, index);
                        byte[] dupKey = this.getLNDupKey(bin, index, ln);
                        this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                        if (!this.areThreadsRunning()) {
                            this.env.getUtilizationTracker().activateCleaner();
                        }
                        clearTarget = false;
                    }
                    bin.setMigrate(index, false);
                    if (clearTarget) {
                        bin.updateNode(index, null, null);
                    }
                    if (locker != null) {
                        locker.operationEnd();
                    }
                    this.trace(this.detailedTraceLevel, cleanAction, ln, lsn, completed, obsolete, migrated);
                    return;
                }
                Object var23_20 = null;
                if (isPending) {
                    if (completed && !lockDenied) {
                        this.fileSelector.removePendingLN(lockedPendingNodeId);
                    }
                } else if (bin.getMigrate(index) && (!completed || lockDenied) && ln != null) {
                    byte[] key = this.getLNMainKey(bin, index);
                    byte[] dupKey = this.getLNDupKey(bin, index, ln);
                    this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                    if (!this.areThreadsRunning()) {
                        this.env.getUtilizationTracker().activateCleaner();
                    }
                    clearTarget = false;
                }
                bin.setMigrate(index, false);
                if (clearTarget) {
                    bin.updateNode(index, null, null);
                }
                if (locker != null) {
                    locker.operationEnd();
                }
                this.trace(this.detailedTraceLevel, cleanAction, ln, lsn, completed, obsolete, migrated);
                return;
            }
            Object var23_21 = null;
            if (isPending) {
                if (completed && !lockDenied) {
                    this.fileSelector.removePendingLN(lockedPendingNodeId);
                }
            } else if (bin.getMigrate(index) && (!completed || lockDenied) && ln != null) {
                byte[] key = this.getLNMainKey(bin, index);
                byte[] dupKey = this.getLNDupKey(bin, index, ln);
                this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                if (!this.areThreadsRunning()) {
                    this.env.getUtilizationTracker().activateCleaner();
                }
                clearTarget = false;
            }
            bin.setMigrate(index, false);
            if (clearTarget) {
                bin.updateNode(index, null, null);
            }
            if (locker != null) {
                locker.operationEnd();
            }
            this.trace(this.detailedTraceLevel, cleanAction, ln, lsn, completed, obsolete, migrated);
            return;
        }
        Object var23_22 = null;
        if (isPending) {
            if (completed && !lockDenied) {
                this.fileSelector.removePendingLN(lockedPendingNodeId);
            }
        } else if (bin.getMigrate(index) && (!completed || lockDenied) && ln != null) {
            byte[] key = this.getLNMainKey(bin, index);
            byte[] dupKey = this.getLNDupKey(bin, index, ln);
            this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
            if (!this.areThreadsRunning()) {
                this.env.getUtilizationTracker().activateCleaner();
            }
            clearTarget = false;
        }
        bin.setMigrate(index, false);
        if (clearTarget) {
            bin.updateNode(index, null, null);
        }
        if (locker != null) {
            locker.operationEnd();
        }
        this.trace(this.detailedTraceLevel, cleanAction, ln, lsn, completed, obsolete, migrated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void migrateDupCountLN(DatabaseImpl db, long lsn, DIN parentDIN, ChildReference dclRef, boolean wasCleaned, boolean isPending, long lockedPendingNodeId, String cleanAction) throws DatabaseException {
        LN ln;
        Locker locker;
        boolean clearTarget;
        boolean completed;
        boolean lockDenied;
        boolean migrated;
        boolean obsolete;
        block46: {
            block45: {
                block44: {
                    block42: {
                        block43: {
                            obsolete = false;
                            migrated = false;
                            lockDenied = false;
                            completed = false;
                            clearTarget = false;
                            locker = null;
                            ln = null;
                            try {
                                LockResult lockRet;
                                if (lsn == -1L) {
                                    completed = true;
                                    Object var23_16 = null;
                                    if (isPending) {
                                        if (completed && !lockDenied) {
                                            this.fileSelector.removePendingLN(lockedPendingNodeId);
                                        }
                                        break block42;
                                    }
                                    if (!dclRef.getMigrate() || completed && !lockDenied || ln == null) break block42;
                                    byte[] key = parentDIN.getDupKey();
                                    byte[] dupKey = null;
                                    this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                                    break block43;
                                }
                                ln = (LN)dclRef.getTarget();
                                if (ln == null) {
                                    ln = (LN)dclRef.fetchTarget(db, parentDIN);
                                    assert (ln != null);
                                    boolean bl = clearTarget = !db.getId().equals(DbTree.ID_DB_ID);
                                }
                                if (lockedPendingNodeId != ln.getNodeId() && (lockRet = (locker = BasicLocker.createBasicLocker(this.env, false, true)).nonBlockingLock(ln.getNodeId(), LockType.READ, db)).getLockGrant() == LockGrantType.DENIED) {
                                    if (wasCleaned) {
                                        ++this.nLNsLocked;
                                    }
                                    lockDenied = true;
                                    completed = true;
                                    break block44;
                                }
                                Long fileNum = DbLsn.getFileNumber(lsn);
                                if (!this.fileSelector.isFileCleaningInProgress(fileNum)) {
                                    obsolete = true;
                                    completed = true;
                                    if (wasCleaned) {
                                        ++this.nLNsDead;
                                    }
                                    break block45;
                                }
                                byte[] key = parentDIN.getDupKey();
                                long newLNLsn = ln.log(this.env, db, key, lsn, locker, false, ReplicationContext.NO_REPLICATE);
                                parentDIN.updateDupCountLNRef(newLNLsn);
                                ++this.nLNsMigrated;
                                migrated = true;
                                completed = true;
                                break block46;
                            }
                            catch (Throwable throwable) {
                                Object var23_20 = null;
                                if (isPending) {
                                    if (completed && !lockDenied) {
                                        this.fileSelector.removePendingLN(lockedPendingNodeId);
                                    }
                                } else if (dclRef.getMigrate() && (!completed || lockDenied) && ln != null) {
                                    byte[] key = parentDIN.getDupKey();
                                    byte[] dupKey = null;
                                    this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                                    if (!this.areThreadsRunning()) {
                                        this.env.getUtilizationTracker().activateCleaner();
                                    }
                                    clearTarget = false;
                                }
                                dclRef.setMigrate(false);
                                if (clearTarget) {
                                    parentDIN.updateDupCountLN(null);
                                }
                                if (locker != null) {
                                    locker.operationEnd();
                                }
                                this.trace(this.detailedTraceLevel, cleanAction, ln, lsn, completed, obsolete, migrated);
                                throw throwable;
                            }
                        }
                        if (!this.areThreadsRunning()) {
                            this.env.getUtilizationTracker().activateCleaner();
                        }
                        clearTarget = false;
                    }
                    dclRef.setMigrate(false);
                    if (clearTarget) {
                        parentDIN.updateDupCountLN(null);
                    }
                    if (locker != null) {
                        locker.operationEnd();
                    }
                    this.trace(this.detailedTraceLevel, cleanAction, ln, lsn, completed, obsolete, migrated);
                    return;
                }
                Object var23_17 = null;
                if (isPending) {
                    if (completed && !lockDenied) {
                        this.fileSelector.removePendingLN(lockedPendingNodeId);
                    }
                } else if (dclRef.getMigrate() && (!completed || lockDenied) && ln != null) {
                    byte[] key = parentDIN.getDupKey();
                    byte[] dupKey = null;
                    this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                    if (!this.areThreadsRunning()) {
                        this.env.getUtilizationTracker().activateCleaner();
                    }
                    clearTarget = false;
                }
                dclRef.setMigrate(false);
                if (clearTarget) {
                    parentDIN.updateDupCountLN(null);
                }
                if (locker != null) {
                    locker.operationEnd();
                }
                this.trace(this.detailedTraceLevel, cleanAction, ln, lsn, completed, obsolete, migrated);
                return;
            }
            Object var23_18 = null;
            if (isPending) {
                if (completed && !lockDenied) {
                    this.fileSelector.removePendingLN(lockedPendingNodeId);
                }
            } else if (dclRef.getMigrate() && (!completed || lockDenied) && ln != null) {
                byte[] key = parentDIN.getDupKey();
                byte[] dupKey = null;
                this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                if (!this.areThreadsRunning()) {
                    this.env.getUtilizationTracker().activateCleaner();
                }
                clearTarget = false;
            }
            dclRef.setMigrate(false);
            if (clearTarget) {
                parentDIN.updateDupCountLN(null);
            }
            if (locker != null) {
                locker.operationEnd();
            }
            this.trace(this.detailedTraceLevel, cleanAction, ln, lsn, completed, obsolete, migrated);
            return;
        }
        Object var23_19 = null;
        if (isPending) {
            if (completed && !lockDenied) {
                this.fileSelector.removePendingLN(lockedPendingNodeId);
            }
        } else if (dclRef.getMigrate() && (!completed || lockDenied) && ln != null) {
            byte[] key = parentDIN.getDupKey();
            byte[] dupKey = null;
            this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
            if (!this.areThreadsRunning()) {
                this.env.getUtilizationTracker().activateCleaner();
            }
            clearTarget = false;
        }
        dclRef.setMigrate(false);
        if (clearTarget) {
            parentDIN.updateDupCountLN(null);
        }
        if (locker != null) {
            locker.operationEnd();
        }
        this.trace(this.detailedTraceLevel, cleanAction, ln, lsn, completed, obsolete, migrated);
    }

    byte[] getLNMainKey(BIN bin, int index) throws DatabaseException {
        if (bin.containsDuplicates()) {
            return bin.getDupKey();
        }
        return bin.getKey(index);
    }

    private byte[] getLNDupKey(BIN bin, int index, LN ln) throws DatabaseException {
        DatabaseImpl db = bin.getDatabase();
        if (!db.getSortedDuplicates() || ln.containsDuplicates()) {
            return null;
        }
        if (bin.containsDuplicates()) {
            return bin.getKey(index);
        }
        return ln.getData();
    }

    void addPendingDB(DatabaseImpl db) {
        DatabaseId id;
        if (db != null && db.isDeleted() && !db.isDeleteFinished() && this.fileSelector.addPendingDB(id = db.getId())) {
            Tracer.trace(this.detailedTraceLevel, this.env, "CleanAddPendingDB " + id);
        }
    }

    void trace(Level level, String action, Node node, long logLsn, boolean completed, boolean obsolete, boolean dirtiedMigrated) {
        Logger logger = this.env.getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(action);
            if (node != null) {
                sb.append(" node=");
                sb.append(node.getNodeId());
            }
            sb.append(" logLsn=");
            sb.append(DbLsn.getNoFormatString(logLsn));
            sb.append(" complete=").append(completed);
            sb.append(" obsolete=").append(obsolete);
            sb.append(" dirtiedOrMigrated=").append(dirtiedMigrated);
            logger.log(level, sb.toString());
        }
    }

    public void close() {
        this.profile.close();
        this.tracker.close();
        this.fileSelector.close(this.env.getMemoryBudget());
    }
}

