/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.utilint.DatabaseUtil;
import java.util.logging.Level;

public class JoinCursor {
    private Cursor priCursor;
    private Cursor[] secCursors;
    private DatabaseEntry[] cursorScratchEntries;
    private DatabaseEntry scratchEntry;

    public void close() throws DatabaseException {
        if (this.priCursor == null) {
            throw new DatabaseException("Already closed");
        }
        this.close(null);
    }

    private void close(DatabaseException firstException) throws DatabaseException {
        if (this.priCursor != null) {
            block7: {
                try {
                    this.priCursor.close();
                }
                catch (DatabaseException e) {
                    if (firstException != null) break block7;
                    firstException = e;
                }
            }
            this.priCursor = null;
        }
        for (int i = 0; i < this.secCursors.length; ++i) {
            block8: {
                if (this.secCursors[i] == null) continue;
                try {
                    this.secCursors[i].close();
                }
                catch (DatabaseException e) {
                    if (firstException != null) break block8;
                    firstException = e;
                }
            }
            this.secCursors[i] = null;
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.priCursor.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", false);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.priCursor.trace(Level.FINEST, "JoinCursor.getNext(key,data): ", lockMode);
        return this.retrieveNext(key, data, lockMode);
    }

    private OperationStatus retrieveNext(DatabaseEntry keyParam, DatabaseEntry dataParam, LockMode lockMode) throws DatabaseException {
        OperationStatus status;
        DatabaseEntry candidateKey;
        block0: while (true) {
            Cursor secCursor = this.secCursors[0];
            candidateKey = this.cursorScratchEntries[0];
            if (candidateKey == null) {
                this.cursorScratchEntries[0] = candidateKey = new DatabaseEntry();
                status = secCursor.getCurrentInternal(this.scratchEntry, candidateKey, lockMode);
            } else {
                status = secCursor.retrieveNext(this.scratchEntry, candidateKey, lockMode, GetMode.NEXT_DUP);
            }
            if (status != OperationStatus.SUCCESS) {
                return status;
            }
            for (int i = 1; i < this.secCursors.length; ++i) {
                secCursor = this.secCursors[i];
                DatabaseEntry secKey = this.cursorScratchEntries[i];
                if (secKey == null) {
                    this.cursorScratchEntries[i] = secKey = new DatabaseEntry();
                    status = secCursor.getCurrentInternal(secKey, this.scratchEntry, lockMode);
                    assert (status == OperationStatus.SUCCESS);
                }
                this.scratchEntry.setData(secKey.getData(), secKey.getOffset(), secKey.getSize());
                status = secCursor.search(this.scratchEntry, candidateKey, lockMode, CursorImpl.SearchMode.BOTH);
                if (status != OperationStatus.SUCCESS) continue block0;
            }
            break;
        }
        if (dataParam != null && (status = this.priCursor.search(candidateKey, dataParam, lockMode, CursorImpl.SearchMode.SET)) != OperationStatus.SUCCESS) {
            throw new DatabaseException("Secondary corrupt");
        }
        keyParam.setData(candidateKey.getData(), candidateKey.getOffset(), candidateKey.getSize());
        return OperationStatus.SUCCESS;
    }
}

