/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.utilint.DbLsn;
import java.io.Serializable;
import java.text.DecimalFormat;

public class EnvironmentStats
implements Serializable {
    private long splitBins;
    private long dbClosedBins;
    private long cursorsBins;
    private long nonEmptyBins;
    private long processedBins;
    private long inCompQueueSize;
    private long nEvictPasses;
    private long nNodesSelected;
    private long nNodesScanned;
    private long nNodesExplicitlyEvicted;
    private long nRootNodesEvicted;
    private long nBINsStripped;
    private long requiredEvictBytes;
    private long nCheckpoints;
    private long lastCheckpointId;
    private long nFullINFlush;
    private long nFullBINFlush;
    private long nDeltaINFlush;
    private long lastCheckpointStart;
    private long lastCheckpointEnd;
    private long endOfLog;
    private int cleanerBacklog;
    private long nCleanerRuns;
    private long nCleanerDeletions;
    private long nINsObsolete;
    private long nINsCleaned;
    private long nINsDead;
    private long nINsMigrated;
    private long nLNsObsolete;
    private long nLNsCleaned;
    private long nLNsDead;
    private long nLNsLocked;
    private long nLNsMigrated;
    private long nLNsMarked;
    private long nLNQueueHits;
    private long nPendingLNsProcessed;
    private long nMarkedLNsProcessed;
    private long nToBeCleanedLNsProcessed;
    private long nClusterLNsProcessed;
    private long nPendingLNsLocked;
    private long nCleanerEntriesRead;
    private int nSharedCacheEnvironments;
    private long sharedCacheTotalBytes;
    private long cacheTotalBytes;
    private long bufferBytes;
    private long dataBytes;
    private long adminBytes;
    private long lockBytes;
    private long nNotResident;
    private long nCacheMiss;
    private int nLogBuffers;
    private long nRandomReads;
    private long nRandomWrites;
    private long nSequentialReads;
    private long nSequentialWrites;
    private long nRandomReadBytes;
    private long nRandomWriteBytes;
    private long nSequentialReadBytes;
    private long nSequentialWriteBytes;
    private long nFSyncs;
    private long nFSyncRequests;
    private long nFSyncTimeouts;
    private long nRepeatFaultReads;
    private long nTempBufferWrites;
    private long nRepeatIteratorReads;
    private int nFileOpens;
    private int nOpenFiles;
    private long totalLogSize;

    public EnvironmentStats() {
        this.reset();
    }

    private void reset() {
        this.splitBins = 0L;
        this.dbClosedBins = 0L;
        this.cursorsBins = 0L;
        this.nonEmptyBins = 0L;
        this.processedBins = 0L;
        this.inCompQueueSize = 0L;
        this.nEvictPasses = 0L;
        this.nNodesSelected = 0L;
        this.nNodesScanned = 0L;
        this.nNodesExplicitlyEvicted = 0L;
        this.nRootNodesEvicted = 0L;
        this.nBINsStripped = 0L;
        this.requiredEvictBytes = 0L;
        this.nCheckpoints = 0L;
        this.lastCheckpointId = 0L;
        this.nFullINFlush = 0L;
        this.nFullBINFlush = 0L;
        this.nDeltaINFlush = 0L;
        this.lastCheckpointStart = -1L;
        this.lastCheckpointEnd = -1L;
        this.endOfLog = -1L;
        this.cleanerBacklog = 0;
        this.nCleanerRuns = 0L;
        this.nCleanerDeletions = 0L;
        this.nINsObsolete = 0L;
        this.nINsCleaned = 0L;
        this.nINsDead = 0L;
        this.nINsMigrated = 0L;
        this.nLNsObsolete = 0L;
        this.nLNsCleaned = 0L;
        this.nLNsDead = 0L;
        this.nLNsLocked = 0L;
        this.nLNsMigrated = 0L;
        this.nLNsMarked = 0L;
        this.nLNQueueHits = 0L;
        this.nPendingLNsProcessed = 0L;
        this.nMarkedLNsProcessed = 0L;
        this.nToBeCleanedLNsProcessed = 0L;
        this.nClusterLNsProcessed = 0L;
        this.nPendingLNsLocked = 0L;
        this.nCleanerEntriesRead = 0L;
        this.nSharedCacheEnvironments = 0;
        this.sharedCacheTotalBytes = 0L;
        this.cacheTotalBytes = 0L;
        this.nNotResident = 0L;
        this.nCacheMiss = 0L;
        this.nLogBuffers = 0;
        this.bufferBytes = 0L;
        this.nRandomReads = 0L;
        this.nRandomWrites = 0L;
        this.nSequentialReads = 0L;
        this.nSequentialWrites = 0L;
        this.nRandomReadBytes = 0L;
        this.nRandomWriteBytes = 0L;
        this.nSequentialReadBytes = 0L;
        this.nSequentialWriteBytes = 0L;
        this.nFSyncs = 0L;
        this.nFSyncRequests = 0L;
        this.nFSyncTimeouts = 0L;
        this.nRepeatFaultReads = 0L;
        this.nTempBufferWrites = 0L;
        this.nRepeatIteratorReads = 0L;
        this.nFileOpens = 0;
        this.nOpenFiles = 0;
        this.totalLogSize = 0L;
    }

    public void setSharedCacheTotalBytes(long sharedCacheTotalBytes) {
        this.sharedCacheTotalBytes = sharedCacheTotalBytes;
    }

    public void setCacheTotalBytes(long cacheTotalBytes) {
        this.cacheTotalBytes = cacheTotalBytes;
    }

    public void setDataBytes(long dataBytes) {
        this.dataBytes = dataBytes;
    }

    public void setAdminBytes(long adminBytes) {
        this.adminBytes = adminBytes;
    }

    public void setLockBytes(long lockBytes) {
        this.lockBytes = lockBytes;
    }

    public String toString() {
        DecimalFormat f = new DecimalFormat("###,###,###,###,###,###,###");
        StringBuffer sb = new StringBuffer();
        sb.append("\nCompression stats\n");
        sb.append("splitBins=").append(f.format(this.splitBins)).append('\n');
        sb.append("dbClosedBins=").append(f.format(this.dbClosedBins)).append('\n');
        sb.append("cursorsBins=").append(f.format(this.cursorsBins)).append('\n');
        sb.append("nonEmptyBins=").append(f.format(this.nonEmptyBins)).append('\n');
        sb.append("processedBins=").append(f.format(this.processedBins)).append('\n');
        sb.append("inCompQueueSize=").append(f.format(this.inCompQueueSize)).append('\n');
        sb.append("\nEviction stats\n");
        sb.append("nEvictPasses=").append(f.format(this.nEvictPasses)).append('\n');
        sb.append("nNodesSelected=").append(f.format(this.nNodesSelected)).append('\n');
        sb.append("nNodesScanned=").append(f.format(this.nNodesScanned)).append('\n');
        sb.append("nNodesExplicitlyEvicted=").append(f.format(this.nNodesExplicitlyEvicted)).append('\n');
        sb.append("nRootNodesEvicted=").append(f.format(this.nRootNodesEvicted)).append('\n');
        sb.append("nBINsStripped=").append(f.format(this.nBINsStripped)).append('\n');
        sb.append("requiredEvictBytes=").append(f.format(this.requiredEvictBytes)).append('\n');
        sb.append("\nCheckpoint stats\n");
        sb.append("nCheckpoints=").append(f.format(this.nCheckpoints)).append('\n');
        sb.append("lastCheckpointId=").append(f.format(this.lastCheckpointId)).append('\n');
        sb.append("nFullINFlush=").append(f.format(this.nFullINFlush)).append('\n');
        sb.append("nFullBINFlush=").append(f.format(this.nFullBINFlush)).append('\n');
        sb.append("nDeltaINFlush=").append(f.format(this.nDeltaINFlush)).append('\n');
        sb.append("lastCheckpointStart=").append(DbLsn.getNoFormatString(this.lastCheckpointStart)).append('\n');
        sb.append("lastCheckpointEnd=").append(DbLsn.getNoFormatString(this.lastCheckpointEnd)).append('\n');
        sb.append("endOfLog=").append(DbLsn.getNoFormatString(this.endOfLog)).append('\n');
        sb.append("\nCleaner stats\n");
        sb.append("cleanerBacklog=").append(f.format(this.cleanerBacklog)).append('\n');
        sb.append("nCleanerRuns=").append(f.format(this.nCleanerRuns)).append('\n');
        sb.append("nCleanerDeletions=").append(f.format(this.nCleanerDeletions)).append('\n');
        sb.append("nINsObsolete=").append(f.format(this.nINsObsolete)).append('\n');
        sb.append("nINsCleaned=").append(f.format(this.nINsCleaned)).append('\n');
        sb.append("nINsDead=").append(f.format(this.nINsDead)).append('\n');
        sb.append("nINsMigrated=").append(f.format(this.nINsMigrated)).append('\n');
        sb.append("nLNsObsolete=").append(f.format(this.nLNsObsolete)).append('\n');
        sb.append("nLNsCleaned=").append(f.format(this.nLNsCleaned)).append('\n');
        sb.append("nLNsDead=").append(f.format(this.nLNsDead)).append('\n');
        sb.append("nLNsLocked=").append(f.format(this.nLNsLocked)).append('\n');
        sb.append("nLNsMigrated=").append(f.format(this.nLNsMigrated)).append('\n');
        sb.append("nLNsMarked=").append(f.format(this.nLNsMarked)).append('\n');
        sb.append("nLNQueueHits=").append(f.format(this.nLNQueueHits)).append('\n');
        sb.append("nPendingLNsProcessed=").append(f.format(this.nPendingLNsProcessed)).append('\n');
        sb.append("nMarkedLNsProcessed=").append(f.format(this.nMarkedLNsProcessed)).append('\n');
        sb.append("nToBeCleanedLNsProcessed=").append(f.format(this.nToBeCleanedLNsProcessed)).append('\n');
        sb.append("nClusterLNsProcessed=").append(f.format(this.nClusterLNsProcessed)).append('\n');
        sb.append("nPendingLNsLocked=").append(f.format(this.nPendingLNsLocked)).append('\n');
        sb.append("nCleanerEntriesRead=").append(f.format(this.nCleanerEntriesRead)).append('\n');
        sb.append("\nCache stats\n");
        sb.append("nNotResident=").append(f.format(this.nNotResident)).append('\n');
        sb.append("nCacheMiss=").append(f.format(this.nCacheMiss)).append('\n');
        sb.append("nLogBuffers=").append(f.format(this.nLogBuffers)).append('\n');
        sb.append("bufferBytes=").append(f.format(this.bufferBytes)).append('\n');
        sb.append("dataBytes=").append(f.format(this.dataBytes)).append('\n');
        sb.append("adminBytes=").append(f.format(this.adminBytes)).append('\n');
        sb.append("lockBytes=").append(f.format(this.lockBytes)).append('\n');
        sb.append("cacheTotalBytes=").append(f.format(this.cacheTotalBytes)).append('\n');
        sb.append("sharedCacheTotalBytes=").append(f.format(this.sharedCacheTotalBytes)).append('\n');
        sb.append("nSharedCacheEnvironments=").append(f.format(this.nSharedCacheEnvironments)).append('\n');
        sb.append("\nIO Stats\n");
        sb.append("nRandomReads=").append(f.format(this.nRandomReads)).append('\n');
        sb.append("nRandomWrites=").append(f.format(this.nRandomWrites)).append('\n');
        sb.append("nSequentialReads=").append(f.format(this.nSequentialReads)).append('\n');
        sb.append("nSequentialWrites=").append(f.format(this.nSequentialWrites)).append('\n');
        sb.append("nRandomReadBytes=").append(f.format(this.nRandomReadBytes)).append('\n');
        sb.append("nRandomWriteBytes=").append(f.format(this.nRandomWriteBytes)).append('\n');
        sb.append("nSequentialReadBytes=").append(f.format(this.nSequentialReadBytes)).append('\n');
        sb.append("nSequentialWriteBytes=").append(f.format(this.nSequentialWriteBytes)).append('\n');
        sb.append("\nLogging stats\n");
        sb.append("nFSyncs=").append(f.format(this.nFSyncs)).append('\n');
        sb.append("nFSyncRequests=").append(f.format(this.nFSyncRequests)).append('\n');
        sb.append("nFSyncTimeouts=").append(f.format(this.nFSyncTimeouts)).append('\n');
        sb.append("nRepeatFaultReads=").append(f.format(this.nRepeatFaultReads)).append('\n');
        sb.append("nTempBufferWrite=").append(f.format(this.nTempBufferWrites)).append('\n');
        sb.append("nRepeatIteratorReads=").append(f.format(this.nRepeatIteratorReads)).append('\n');
        sb.append("nFileOpens=").append(f.format(this.nFileOpens)).append('\n');
        sb.append("nOpenFiles=").append(f.format(this.nOpenFiles)).append('\n');
        sb.append("totalLogSize=").append(f.format(this.totalLogSize)).append('\n');
        return sb.toString();
    }
}

