/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseImpl;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseConfig
implements Cloneable {
    public static final DatabaseConfig DEFAULT = new DatabaseConfig();
    private boolean allowCreate = false;
    private boolean exclusiveCreate = false;
    private boolean transactional = false;
    private boolean readOnly = false;
    private boolean duplicatesAllowed = false;
    private boolean deferredWrite = false;
    private boolean temporary = false;
    private boolean keyPrefixingEnabled = false;
    private boolean replicated = true;
    private int nodeMax;
    private int nodeMaxDupTree;
    private Comparator<byte[]> btreeComparator = null;
    private Comparator<byte[]> duplicateComparator = null;
    private boolean btreeComparatorByClassName = false;
    private boolean duplicateComparatorByClassName = false;
    private boolean overrideBtreeComparator = false;
    private boolean overrideDupComparator = false;
    private boolean useExistingConfig = false;

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean getAllowCreate() {
        return this.allowCreate;
    }

    public boolean getExclusiveCreate() {
        return this.exclusiveCreate;
    }

    public void setSortedDuplicates(boolean duplicatesAllowed) {
        this.duplicatesAllowed = duplicatesAllowed;
    }

    public boolean getSortedDuplicates() {
        return this.duplicatesAllowed;
    }

    public boolean getKeyPrefixing() {
        return this.keyPrefixingEnabled;
    }

    public void setKeyPrefixing(boolean keyPrefixingEnabled) {
        this.keyPrefixingEnabled = keyPrefixingEnabled;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public boolean getTransactional() {
        return this.transactional;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public int getNodeMaxEntries() {
        return this.nodeMax;
    }

    public int getNodeMaxDupTreeEntries() {
        return this.nodeMaxDupTree;
    }

    public void setBtreeComparator(Comparator<byte[]> btreeComparator) {
        this.btreeComparator = this.validateComparator(btreeComparator, "Btree");
        this.btreeComparatorByClassName = false;
    }

    public Comparator<byte[]> getBtreeComparator() {
        return this.btreeComparator;
    }

    public boolean getBtreeComparatorByClassName() {
        return this.btreeComparatorByClassName;
    }

    public boolean getOverrideBtreeComparator() {
        return this.overrideBtreeComparator;
    }

    public Comparator<byte[]> getDuplicateComparator() {
        return this.duplicateComparator;
    }

    public boolean getDuplicateComparatorByClassName() {
        return this.duplicateComparatorByClassName;
    }

    public boolean getOverrideDuplicateComparator() {
        return this.overrideDupComparator;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public boolean getTemporary() {
        return this.temporary;
    }

    public void setDeferredWrite(boolean deferredWrite) {
        this.deferredWrite = deferredWrite;
    }

    public boolean getDeferredWrite() {
        return this.deferredWrite;
    }

    void setBtreeComparatorInternal(Comparator<byte[]> comparator, boolean byClassName) {
        this.btreeComparator = comparator;
        this.btreeComparatorByClassName = byClassName;
    }

    void setDuplicateComparatorInternal(Comparator<byte[]> comparator, boolean byClassName) {
        this.duplicateComparator = comparator;
        this.duplicateComparatorByClassName = byClassName;
    }

    boolean getUseExistingConfig() {
        return this.useExistingConfig;
    }

    void setReplicated(boolean replicated) {
        this.replicated = replicated;
    }

    boolean getReplicated() {
        return this.replicated;
    }

    public DatabaseConfig cloneConfig() {
        try {
            return (DatabaseConfig)super.clone();
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    private Comparator<byte[]> validateComparator(Comparator<byte[]> comparator, String type) throws IllegalArgumentException {
        if (comparator == null) {
            return null;
        }
        try {
            return DatabaseImpl.instantiateComparator(comparator, type);
        }
        catch (DatabaseException e) {
            throw new IllegalArgumentException(type + " comparator is not valid: " + e.getMessage() + "\nThe comparator object must be serializable.");
        }
    }

    void validateForNewDb() throws DatabaseException {
        if (this.readOnly) {
            throw new DatabaseException("DatabaseConfig.setReadOnly() must be set to false when creating a Database");
        }
        if (this.transactional && this.deferredWrite) {
            throw new DatabaseException("deferredWrite mode is not yet supported for transactional databases");
        }
    }

    public String toString() {
        return "allowCreate=" + this.allowCreate + "\nexclusiveCreate=" + this.exclusiveCreate + "\ntransactional=" + this.transactional + "\nreadOnly=" + this.readOnly + "\nduplicatesAllowed=" + this.duplicatesAllowed + "\ndeferredWrite=" + this.deferredWrite + "\ntemporary=" + this.temporary + "\nkeyPrefixingEnabled=" + this.keyPrefixingEnabled + "\n";
    }
}

