/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.PngConstants;
import com.sixlegs.png.PngException;
import com.sixlegs.png.PngImage;

class StateMachine {
    private PngImage png;
    private int state = 0;
    private int type;

    public StateMachine(PngImage png) {
        this.png = png;
    }

    public int getState() {
        return this.state;
    }

    public int getType() {
        return this.type;
    }

    public void nextState(int type) throws PngException {
        this.type = type;
        this.state = StateMachine.nextState(this.png, this.state, this.type);
    }

    private static int nextState(PngImage png, int state, int type) throws PngException {
        for (int i = 0; i < 4; ++i) {
            int c = 0xFF & type >>> 8 * i;
            if (c >= 65 && (c <= 90 || c >= 97) && c <= 122) continue;
            throw new PngException("Corrupted chunk type: 0x" + Integer.toHexString(type), true);
        }
        if (PngConstants.isPrivate(type) && !PngConstants.isAncillary(type)) {
            throw new PngException("Private critical chunk encountered: " + PngConstants.getChunkName(type), true);
        }
        switch (state) {
            case 0: {
                if (type == 1229472850) {
                    return 1;
                }
                throw new PngException("IHDR chunk must be first chunk", true);
            }
            case 1: 
            case 2: {
                switch (type) {
                    case 1347179589: {
                        return 3;
                    }
                    case 1229209940: {
                        StateMachine.errorIfPaletted(png);
                        return 4;
                    }
                    case 1649100612: {
                        return 2;
                    }
                    case 1951551059: {
                        StateMachine.errorIfPaletted(png);
                        return 2;
                    }
                    case 1749635924: {
                        throw new PngException("PLTE must precede hIST", true);
                    }
                }
                return state;
            }
            case 3: {
                switch (type) {
                    case 1665684045: 
                    case 1732332865: 
                    case 1766015824: 
                    case 1933723988: 
                    case 1934772034: {
                        throw new PngException(PngConstants.getChunkName(type) + " cannot appear after PLTE", true);
                    }
                    case 1229209940: {
                        return 4;
                    }
                    case 1229278788: {
                        throw new PngException("Required data chunk(s) not found", true);
                    }
                }
                return 3;
            }
        }
        switch (type) {
            case 1347179589: 
            case 1649100612: 
            case 1665684045: 
            case 1732332865: 
            case 1749635924: 
            case 1766015824: 
            case 1866876531: 
            case 1883455820: 
            case 1883789683: 
            case 1933723988: 
            case 1933787468: 
            case 1934642260: 
            case 1934772034: 
            case 1934902610: 
            case 1951551059: {
                throw new PngException(PngConstants.getChunkName(type) + " cannot appear after IDAT", true);
            }
            case 1229278788: {
                return 6;
            }
            case 1229209940: {
                if (state == 4) {
                    return 4;
                }
                throw new PngException("IDAT chunks must be consecutive", true);
            }
        }
        return 5;
    }

    private static void errorIfPaletted(PngImage png) throws PngException {
        if (png.getColorType() == 3) {
            throw new PngException("Required PLTE chunk not found", true);
        }
    }
}

