/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import java.awt.Rectangle;

public final class PngConfig {
    final int readLimit;
    final float defaultGamma;
    final float displayExponent;
    final boolean warningsFatal;
    final boolean progressive;
    final boolean reduce16;
    final boolean gammaCorrect;
    final Rectangle sourceRegion;
    final int[] subsampling;
    final boolean convertIndexed;

    PngConfig(Builder builder) {
        boolean subsampleOn;
        this.readLimit = builder.readLimit;
        this.defaultGamma = builder.defaultGamma;
        this.displayExponent = builder.displayExponent;
        this.warningsFatal = builder.warningsFatal;
        this.progressive = builder.progressive;
        this.reduce16 = builder.reduce16;
        this.gammaCorrect = builder.gammaCorrect;
        this.sourceRegion = builder.sourceRegion;
        this.subsampling = builder.subsampling;
        this.convertIndexed = builder.convertIndexed;
        boolean bl = subsampleOn = this.getSourceXSubsampling() != 1 || this.getSourceYSubsampling() != 1;
        if (this.progressive && (subsampleOn || this.getSourceRegion() != null)) {
            throw new IllegalStateException("Progressive rendering cannot be used with source regions or subsampling");
        }
    }

    public boolean getConvertIndexed() {
        return this.convertIndexed;
    }

    public boolean getReduce16() {
        return this.reduce16;
    }

    public float getDefaultGamma() {
        return this.defaultGamma;
    }

    public boolean getGammaCorrect() {
        return this.gammaCorrect;
    }

    public boolean getProgressive() {
        return this.progressive;
    }

    public float getDisplayExponent() {
        return this.displayExponent;
    }

    public int getReadLimit() {
        return this.readLimit;
    }

    public boolean getWarningsFatal() {
        return this.warningsFatal;
    }

    public Rectangle getSourceRegion() {
        return this.sourceRegion != null ? new Rectangle(this.sourceRegion) : null;
    }

    public int getSourceXSubsampling() {
        return this.subsampling[0];
    }

    public int getSourceYSubsampling() {
        return this.subsampling[1];
    }

    public int getSubsamplingXOffset() {
        return this.subsampling[2];
    }

    public int getSubsamplingYOffset() {
        return this.subsampling[3];
    }

    public static final class Builder {
        private static final int[] DEFAULT_SUBSAMPLING = new int[]{1, 1, 0, 0};
        int readLimit = 0;
        float defaultGamma = 0.45455f;
        float displayExponent = 2.2f;
        boolean warningsFatal;
        boolean progressive;
        boolean reduce16 = true;
        boolean gammaCorrect = true;
        Rectangle sourceRegion;
        int[] subsampling = DEFAULT_SUBSAMPLING;
        boolean convertIndexed;

        public PngConfig build() {
            return new PngConfig(this);
        }
    }
}

