/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNull;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleBookmark {
    static void createOutlineAction(PdfDictionary outline, HashMap<String, Object> map, PdfWriter writer, boolean namedAsNames) {
        try {
            String file;
            String action = (String)map.get("Action");
            if ("GoTo".equals(action)) {
                String p = (String)map.get("Named");
                if (p != null) {
                    if (namedAsNames) {
                        outline.put(PdfName.DEST, new PdfName(p));
                    } else {
                        outline.put(PdfName.DEST, new PdfString(p, null));
                    }
                } else {
                    p = (String)map.get("Page");
                    if (p != null) {
                        PdfArray ar = new PdfArray();
                        StringTokenizer tk = new StringTokenizer(p);
                        int n = Integer.parseInt(tk.nextToken());
                        ar.add(writer.getPageReference(n));
                        if (!tk.hasMoreTokens()) {
                            ar.add(PdfName.XYZ);
                            ar.add(new float[]{0.0f, 10000.0f, 0.0f});
                        } else {
                            String fn = tk.nextToken();
                            if (fn.startsWith("/")) {
                                fn = fn.substring(1);
                            }
                            ar.add(new PdfName(fn));
                            for (int k = 0; k < 4 && tk.hasMoreTokens(); ++k) {
                                fn = tk.nextToken();
                                if (fn.equals("null")) {
                                    ar.add(PdfNull.PDFNULL);
                                    continue;
                                }
                                ar.add(new PdfNumber(fn));
                            }
                        }
                        outline.put(PdfName.DEST, ar);
                    }
                }
            } else if ("GoToR".equals(action)) {
                PdfDictionary dic = new PdfDictionary();
                String p = (String)map.get("Named");
                if (p != null) {
                    dic.put(PdfName.D, new PdfString(p, null));
                } else {
                    p = (String)map.get("NamedN");
                    if (p != null) {
                        dic.put(PdfName.D, new PdfName(p));
                    } else {
                        p = (String)map.get("Page");
                        if (p != null) {
                            PdfArray ar = new PdfArray();
                            StringTokenizer tk = new StringTokenizer(p);
                            ar.add(new PdfNumber(tk.nextToken()));
                            if (!tk.hasMoreTokens()) {
                                ar.add(PdfName.XYZ);
                                ar.add(new float[]{0.0f, 10000.0f, 0.0f});
                            } else {
                                String fn = tk.nextToken();
                                if (fn.startsWith("/")) {
                                    fn = fn.substring(1);
                                }
                                ar.add(new PdfName(fn));
                                for (int k = 0; k < 4 && tk.hasMoreTokens(); ++k) {
                                    fn = tk.nextToken();
                                    if (fn.equals("null")) {
                                        ar.add(PdfNull.PDFNULL);
                                        continue;
                                    }
                                    ar.add(new PdfNumber(fn));
                                }
                            }
                            dic.put(PdfName.D, ar);
                        }
                    }
                }
                String file2 = (String)map.get("File");
                if (dic.size() > 0 && file2 != null) {
                    dic.put(PdfName.S, PdfName.GOTOR);
                    dic.put(PdfName.F, new PdfString(file2));
                    String nw = (String)map.get("NewWindow");
                    if (nw != null) {
                        if (nw.equals("true")) {
                            dic.put(PdfName.NEWWINDOW, PdfBoolean.PDFTRUE);
                        } else if (nw.equals("false")) {
                            dic.put(PdfName.NEWWINDOW, PdfBoolean.PDFFALSE);
                        }
                    }
                    outline.put(PdfName.A, dic);
                }
            } else if ("URI".equals(action)) {
                String uri = (String)map.get("URI");
                if (uri != null) {
                    PdfDictionary dic = new PdfDictionary();
                    dic.put(PdfName.S, PdfName.URI);
                    dic.put(PdfName.URI, new PdfString(uri));
                    outline.put(PdfName.A, dic);
                }
            } else if ("Launch".equals(action) && (file = (String)map.get("File")) != null) {
                PdfDictionary dic = new PdfDictionary();
                dic.put(PdfName.S, PdfName.LAUNCH);
                dic.put(PdfName.F, new PdfString(file));
                outline.put(PdfName.A, dic);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static Object[] iterateOutlines(PdfWriter writer, PdfIndirectReference parent, List<HashMap<String, Object>> kids, boolean namedAsNames) throws IOException {
        PdfIndirectReference[] refs = new PdfIndirectReference[kids.size()];
        for (int k = 0; k < refs.length; ++k) {
            refs[k] = writer.getPdfIndirectReference();
        }
        int ptr = 0;
        int count = 0;
        ListIterator<HashMap<String, Object>> it = kids.listIterator();
        while (it.hasNext()) {
            String style;
            HashMap map = (HashMap)it.next();
            Object[] lower = null;
            List subKid = (List)map.get("Kids");
            if (subKid != null && !subKid.isEmpty()) {
                lower = SimpleBookmark.iterateOutlines(writer, refs[ptr], subKid, namedAsNames);
            }
            PdfDictionary outline = new PdfDictionary();
            ++count;
            if (lower != null) {
                outline.put(PdfName.FIRST, (PdfIndirectReference)lower[0]);
                outline.put(PdfName.LAST, (PdfIndirectReference)lower[1]);
                int n = (Integer)lower[2];
                if ("false".equals(map.get("Open"))) {
                    outline.put(PdfName.COUNT, new PdfNumber(-n));
                } else {
                    outline.put(PdfName.COUNT, new PdfNumber(n));
                    count += n;
                }
            }
            outline.put(PdfName.PARENT, parent);
            if (ptr > 0) {
                outline.put(PdfName.PREV, refs[ptr - 1]);
            }
            if (ptr < refs.length - 1) {
                outline.put(PdfName.NEXT, refs[ptr + 1]);
            }
            outline.put(PdfName.TITLE, new PdfString((String)map.get("Title"), "UnicodeBig"));
            String color = (String)map.get("Color");
            if (color != null) {
                try {
                    PdfArray arr = new PdfArray();
                    StringTokenizer tk = new StringTokenizer(color);
                    for (int k = 0; k < 3; ++k) {
                        float f = Float.parseFloat(tk.nextToken());
                        if (f < 0.0f) {
                            f = 0.0f;
                        }
                        if (f > 1.0f) {
                            f = 1.0f;
                        }
                        arr.add(new PdfNumber(f));
                    }
                    outline.put(PdfName.C, arr);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((style = (String)map.get("Style")) != null) {
                style = style.toLowerCase();
                int bits = 0;
                if (style.indexOf("italic") >= 0) {
                    bits |= 1;
                }
                if (style.indexOf("bold") >= 0) {
                    bits |= 2;
                }
                if (bits != 0) {
                    outline.put(PdfName.F, new PdfNumber(bits));
                }
            }
            SimpleBookmark.createOutlineAction(outline, map, writer, namedAsNames);
            writer.addToBody((PdfObject)outline, refs[ptr]);
            ++ptr;
        }
        return new Object[]{refs[0], refs[refs.length - 1], count};
    }
}

