/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfPCellEvent;
import com.itextpdf.text.pdf.PdfPRow;
import com.itextpdf.text.pdf.PdfPTable;

public class PdfPCell
extends Rectangle {
    private ColumnText column = new ColumnText(null);
    private int verticalAlignment = 4;
    private float paddingLeft = 2.0f;
    private float paddingRight = 2.0f;
    private float paddingTop = 2.0f;
    private float paddingBottom = 2.0f;
    private float fixedHeight = 0.0f;
    private float minimumHeight;
    private boolean noWrap = false;
    private PdfPTable table;
    private int colspan = 1;
    private int rowspan = 1;
    private Image image;
    private PdfPCellEvent cellEvent;
    private boolean useDescender;
    private boolean useBorderPadding = false;
    protected Phrase phrase;
    private int rotation;

    public PdfPCell() {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.borderWidth = 0.5f;
        this.border = 15;
        this.column.setLeading(0.0f, 1.0f);
    }

    public PdfPCell(Phrase phrase) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.borderWidth = 0.5f;
        this.border = 15;
        this.phrase = phrase;
        this.column.addText(this.phrase);
        this.column.setLeading(0.0f, 1.0f);
    }

    public PdfPCell(Image image, boolean fit) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.borderWidth = 0.5f;
        this.border = 15;
        if (fit) {
            this.image = image;
            this.column.setLeading(0.0f, 1.0f);
            this.setPadding(this.borderWidth / 2.0f);
        } else {
            this.phrase = new Phrase(new Chunk(image, 0.0f, 0.0f));
            this.column.addText(this.phrase);
            this.column.setLeading(0.0f, 1.0f);
            this.setPadding(0.0f);
        }
    }

    public PdfPCell(PdfPCell cell) {
        super(cell.llx, cell.lly, cell.urx, cell.ury);
        this.cloneNonPositionParameters(cell);
        this.verticalAlignment = cell.verticalAlignment;
        this.paddingLeft = cell.paddingLeft;
        this.paddingRight = cell.paddingRight;
        this.paddingTop = cell.paddingTop;
        this.paddingBottom = cell.paddingBottom;
        this.phrase = cell.phrase;
        this.fixedHeight = cell.fixedHeight;
        this.minimumHeight = cell.minimumHeight;
        this.noWrap = cell.noWrap;
        this.colspan = cell.colspan;
        this.rowspan = cell.rowspan;
        if (cell.table != null) {
            this.table = new PdfPTable(cell.table);
        }
        this.image = Image.getInstance(cell.image);
        this.cellEvent = cell.cellEvent;
        this.useDescender = cell.useDescender;
        this.column = ColumnText.duplicate(cell.column);
        this.useBorderPadding = cell.useBorderPadding;
        this.rotation = cell.rotation;
    }

    public void addElement(Element element) {
        if (this.table != null) {
            this.table = null;
            this.column.setText(null);
        }
        this.column.addElement(element);
    }

    public void setPhrase(Phrase phrase) {
        this.table = null;
        this.image = null;
        this.phrase = phrase;
        this.column.setText(this.phrase);
    }

    public int getHorizontalAlignment() {
        return this.column.getAlignment();
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public float getEffectivePaddingLeft() {
        if (this.isUseBorderPadding()) {
            float border = this.getBorderWidthLeft() / (this.isUseVariableBorders() ? 1.0f : 2.0f);
            return this.paddingLeft + border;
        }
        return this.paddingLeft;
    }

    public float getEffectivePaddingRight() {
        if (this.isUseBorderPadding()) {
            float border = this.getBorderWidthRight() / (this.isUseVariableBorders() ? 1.0f : 2.0f);
            return this.paddingRight + border;
        }
        return this.paddingRight;
    }

    public float getEffectivePaddingTop() {
        if (this.isUseBorderPadding()) {
            float border = this.getBorderWidthTop() / (this.isUseVariableBorders() ? 1.0f : 2.0f);
            return this.paddingTop + border;
        }
        return this.paddingTop;
    }

    public float getEffectivePaddingBottom() {
        if (this.isUseBorderPadding()) {
            float border = this.getBorderWidthBottom() / (this.isUseVariableBorders() ? 1.0f : 2.0f);
            return this.paddingBottom + border;
        }
        return this.paddingBottom;
    }

    public void setPadding(float padding) {
        this.paddingBottom = padding;
        this.paddingTop = padding;
        this.paddingLeft = padding;
        this.paddingRight = padding;
    }

    public boolean isUseBorderPadding() {
        return this.useBorderPadding;
    }

    public void setFixedHeight(float fixedHeight) {
        this.fixedHeight = fixedHeight;
        this.minimumHeight = 0.0f;
    }

    public float getFixedHeight() {
        return this.fixedHeight;
    }

    public boolean hasFixedHeight() {
        return this.getFixedHeight() > 0.0f;
    }

    public void setMinimumHeight(float minimumHeight) {
        this.minimumHeight = minimumHeight;
        this.fixedHeight = 0.0f;
    }

    public float getMinimumHeight() {
        return this.minimumHeight;
    }

    public boolean hasMinimumHeight() {
        return this.getMinimumHeight() > 0.0f;
    }

    public boolean isNoWrap() {
        return this.noWrap;
    }

    public int getColspan() {
        return this.colspan;
    }

    public void setColspan(int colspan) {
        this.colspan = colspan;
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public void setRowspan(int rowspan) {
        this.rowspan = rowspan;
    }

    public void setRunDirection(int runDirection) {
        this.column.setRunDirection(runDirection);
    }

    public int getRunDirection() {
        return this.column.getRunDirection();
    }

    public Image getImage() {
        return this.image;
    }

    public PdfPCellEvent getCellEvent() {
        return this.cellEvent;
    }

    public boolean isUseDescender() {
        return this.useDescender;
    }

    public ColumnText getColumn() {
        return this.column;
    }

    public void setColumn(ColumnText column) {
        this.column = column;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        if ((rotation %= 360) < 0) {
            rotation += 360;
        }
        if (rotation % 90 != 0) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("rotation.must.be.a.multiple.of.90", new Object[0]));
        }
        this.rotation = rotation;
    }

    public float getMaxHeight() {
        boolean pivoted = this.getRotation() == 90 || this.getRotation() == 270;
        Image img = this.getImage();
        if (img != null) {
            img.scalePercent(100.0f);
            float refWidth = pivoted ? img.getScaledHeight() : img.getScaledWidth();
            float scale = (this.getRight() - this.getEffectivePaddingRight() - this.getEffectivePaddingLeft() - this.getLeft()) / refWidth;
            img.scalePercent(scale * 100.0f);
            float refHeight = pivoted ? img.getScaledWidth() : img.getScaledHeight();
            this.setBottom(this.getTop() - this.getEffectivePaddingTop() - this.getEffectivePaddingBottom() - refHeight);
        } else if (pivoted && this.hasFixedHeight()) {
            this.setBottom(this.getTop() - this.getFixedHeight());
        } else {
            float bottom;
            float left;
            float top;
            float right;
            ColumnText ct = ColumnText.duplicate(this.getColumn());
            if (pivoted) {
                right = 20000.0f;
                top = this.getRight() - this.getEffectivePaddingRight();
                left = 0.0f;
                bottom = this.getLeft() + this.getEffectivePaddingLeft();
            } else {
                right = this.isNoWrap() ? 20000.0f : this.getRight() - this.getEffectivePaddingRight();
                top = this.getTop() - this.getEffectivePaddingTop();
                left = this.getLeft() + this.getEffectivePaddingLeft();
                bottom = this.hasFixedHeight() ? this.getTop() + this.getEffectivePaddingBottom() - this.getFixedHeight() : -1.0737418E9f;
            }
            PdfPRow.setColumn(ct, left, bottom, right, top);
            try {
                ct.go(true);
            }
            catch (DocumentException e) {
                throw new ExceptionConverter(e);
            }
            if (pivoted) {
                this.setBottom(this.getTop() - this.getEffectivePaddingTop() - this.getEffectivePaddingBottom() - ct.getFilledWidth());
            } else {
                float yLine = ct.getYLine();
                if (this.isUseDescender()) {
                    yLine += ct.getDescender();
                }
                this.setBottom(yLine - this.getEffectivePaddingBottom());
            }
        }
        float height = this.getHeight();
        if (this.hasFixedHeight()) {
            height = this.getFixedHeight();
        } else if (this.hasMinimumHeight() && height < this.getMinimumHeight()) {
            height = this.getMinimumHeight();
        }
        return height;
    }
}

