/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNull;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfArray
extends PdfObject {
    protected ArrayList<PdfObject> arrayList;

    public PdfArray() {
        super(5);
        this.arrayList = new ArrayList();
    }

    public PdfArray(PdfObject object) {
        super(5);
        this.arrayList = new ArrayList();
        this.arrayList.add(object);
    }

    public PdfArray(float[] values) {
        super(5);
        this.arrayList = new ArrayList();
        this.add(values);
    }

    public PdfArray(int[] values) {
        super(5);
        this.arrayList = new ArrayList();
        this.add(values);
    }

    public PdfArray(PdfArray array) {
        super(5);
        this.arrayList = new ArrayList<PdfObject>(array.arrayList);
    }

    @Override
    public void toPdf(PdfWriter writer, OutputStream os) throws IOException {
        PdfObject object;
        os.write(91);
        Iterator<PdfObject> i = this.arrayList.iterator();
        int type = 0;
        if (i.hasNext()) {
            object = i.next();
            if (object == null) {
                object = PdfNull.PDFNULL;
            }
            object.toPdf(writer, os);
        }
        while (i.hasNext()) {
            object = i.next();
            if (object == null) {
                object = PdfNull.PDFNULL;
            }
            if ((type = object.type()) != 5 && type != 6 && type != 4 && type != 3) {
                os.write(32);
            }
            object.toPdf(writer, os);
        }
        os.write(93);
    }

    @Override
    public String toString() {
        return this.arrayList.toString();
    }

    public PdfObject set(int idx, PdfObject obj) {
        return this.arrayList.set(idx, obj);
    }

    @Deprecated
    public ArrayList<PdfObject> getArrayList() {
        return this.arrayList;
    }

    public int size() {
        return this.arrayList.size();
    }

    public boolean isEmpty() {
        return this.arrayList.isEmpty();
    }

    public boolean add(PdfObject object) {
        return this.arrayList.add(object);
    }

    public boolean add(float[] values) {
        for (int k = 0; k < values.length; ++k) {
            this.arrayList.add(new PdfNumber(values[k]));
        }
        return true;
    }

    public boolean add(int[] values) {
        for (int k = 0; k < values.length; ++k) {
            this.arrayList.add(new PdfNumber(values[k]));
        }
        return true;
    }

    public void addFirst(PdfObject object) {
        this.arrayList.add(0, object);
    }

    public boolean contains(PdfObject object) {
        return this.arrayList.contains(object);
    }

    public ListIterator<PdfObject> listIterator() {
        return this.arrayList.listIterator();
    }

    public PdfObject getPdfObject(int idx) {
        return this.arrayList.get(idx);
    }

    public PdfObject getDirectObject(int idx) {
        return PdfReader.getPdfObject(this.getPdfObject(idx));
    }

    public PdfDictionary getAsDict(int idx) {
        PdfDictionary dict = null;
        PdfObject orig = this.getDirectObject(idx);
        if (orig != null && orig.isDictionary()) {
            dict = (PdfDictionary)orig;
        }
        return dict;
    }

    public PdfName getAsName(int idx) {
        PdfName name = null;
        PdfObject orig = this.getDirectObject(idx);
        if (orig != null && orig.isName()) {
            name = (PdfName)orig;
        }
        return name;
    }
}

