/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.error_messages.MessageLocalization;

public class RectangleReadOnly
extends Rectangle {
    public RectangleReadOnly(float urx, float ury) {
        super(0.0f, 0.0f, urx, ury);
    }

    public RectangleReadOnly(float urx, float ury, int rotation) {
        super(0.0f, 0.0f, urx, ury);
        super.setRotation(rotation);
    }

    private void throwReadOnlyError() {
        throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("rectanglereadonly.this.rectangle.is.read.only", new Object[0]));
    }

    public void setRotation(int rotation) {
        this.throwReadOnlyError();
    }

    public void setLeft(float llx) {
        this.throwReadOnlyError();
    }

    public void setRight(float urx) {
        this.throwReadOnlyError();
    }

    public void setTop(float ury) {
        this.throwReadOnlyError();
    }

    public void setBottom(float lly) {
        this.throwReadOnlyError();
    }

    public void setBackgroundColor(BaseColor value) {
        this.throwReadOnlyError();
    }

    public void setBorder(int border) {
        this.throwReadOnlyError();
    }

    public void setBorderWidth(float borderWidth) {
        this.throwReadOnlyError();
    }

    public void setBorderColor(BaseColor borderColor) {
        this.throwReadOnlyError();
    }

    public void cloneNonPositionParameters(Rectangle rect) {
        this.throwReadOnlyError();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("RectangleReadOnly: ");
        buf.append(this.getWidth());
        buf.append('x');
        buf.append(this.getHeight());
        buf.append(" (rot: ");
        buf.append(this.rotation);
        buf.append(" degrees)");
        return buf.toString();
    }
}

