/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.ElementListener;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.TextElementArray;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class List
implements TextElementArray {
    protected ArrayList<Element> list = new ArrayList();
    protected boolean numbered = false;
    protected boolean lettered = false;
    protected boolean lowercase = false;
    protected boolean autoindent = false;
    protected boolean alignindent = false;
    protected int first = 1;
    protected Chunk symbol = new Chunk("- ");
    protected String preSymbol = "";
    protected String postSymbol = ". ";
    protected float indentationLeft = 0.0f;
    protected float indentationRight = 0.0f;
    protected float symbolIndent = 0.0f;

    public List() {
        this(false, false);
    }

    public List(boolean numbered, boolean lettered) {
        this.numbered = numbered;
        this.lettered = lettered;
        this.autoindent = true;
        this.alignindent = true;
    }

    @Override
    public boolean process(ElementListener listener) {
        try {
            for (Element element : this.list) {
                listener.add(element);
            }
            return true;
        }
        catch (DocumentException de) {
            return false;
        }
    }

    @Override
    public int type() {
        return 14;
    }

    @Override
    public java.util.List<Chunk> getChunks() {
        ArrayList<Chunk> tmp = new ArrayList<Chunk>();
        for (Element element : this.list) {
            tmp.addAll(element.getChunks());
        }
        return tmp;
    }

    public void normalizeIndentation() {
        float max = 0.0f;
        for (Element o : this.list) {
            if (!(o instanceof ListItem)) continue;
            max = Math.max(max, ((ListItem)o).getIndentationLeft());
        }
        for (Element o : this.list) {
            if (!(o instanceof ListItem)) continue;
            ((ListItem)o).setIndentationLeft(max);
        }
    }

    public void setIndentationLeft(float indentation) {
        this.indentationLeft = indentation;
    }

    public void setIndentationRight(float indentation) {
        this.indentationRight = indentation;
    }

    public ArrayList<Element> getItems() {
        return this.list;
    }

    public boolean isAlignindent() {
        return this.alignindent;
    }

    public float getIndentationLeft() {
        return this.indentationLeft;
    }

    public float getIndentationRight() {
        return this.indentationRight;
    }

    @Override
    public boolean isContent() {
        return true;
    }

    @Override
    public boolean isNestable() {
        return true;
    }
}

