/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.pdf.BaseFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Font
implements Comparable<Font> {
    private FontFamily family = FontFamily.UNDEFINED;
    private float size = -1.0f;
    private int style = -1;
    private BaseColor color = null;
    private BaseFont baseFont = null;

    public Font(Font other) {
        this.family = other.family;
        this.size = other.size;
        this.style = other.style;
        this.color = other.color;
        this.baseFont = other.baseFont;
    }

    public Font(FontFamily family, float size, int style, BaseColor color) {
        this.family = family;
        this.size = size;
        this.style = style;
        this.color = color;
    }

    public Font(BaseFont bf, float size, int style, BaseColor color) {
        this.baseFont = bf;
        this.size = size;
        this.style = style;
        this.color = color;
    }

    public Font() {
        this(FontFamily.UNDEFINED, -1.0f, -1, null);
    }

    @Override
    public int compareTo(Font font) {
        if (font == null) {
            return -1;
        }
        try {
            if (this.baseFont != null && !this.baseFont.equals(font.getBaseFont())) {
                return -2;
            }
            if (this.family != font.getFamily()) {
                return 1;
            }
            if (this.size != font.getSize()) {
                return 2;
            }
            if (this.style != font.getStyle()) {
                return 3;
            }
            if (this.color == null) {
                if (font.color == null) {
                    return 0;
                }
                return 4;
            }
            if (font.color == null) {
                return 4;
            }
            if (this.color.equals(font.getColor())) {
                return 0;
            }
            return 4;
        }
        catch (ClassCastException cce) {
            return -3;
        }
    }

    public FontFamily getFamily() {
        return this.family;
    }

    public String getFamilyname() {
        String tmp = "unknown";
        switch (this.getFamily()) {
            case COURIER: {
                return "Courier";
            }
            case HELVETICA: {
                return "Helvetica";
            }
            case TIMES_ROMAN: {
                return "Times-Roman";
            }
            case SYMBOL: {
                return "Symbol";
            }
            case ZAPFDINGBATS: {
                return "ZapfDingbats";
            }
        }
        if (this.baseFont != null) {
            String[][] names;
            for (String[] name : names = this.baseFont.getFamilyFontName()) {
                if ("0".equals(name[2])) {
                    return name[3];
                }
                if ("1033".equals(name[2])) {
                    tmp = name[3];
                }
                if (!"".equals(name[2])) continue;
                tmp = name[3];
            }
        }
        return tmp;
    }

    public float getSize() {
        return this.size;
    }

    public float getCalculatedSize() {
        float s = this.size;
        if (s == -1.0f) {
            s = 12.0f;
        }
        return s;
    }

    public float getCalculatedLeading(float linespacing) {
        return linespacing * this.getCalculatedSize();
    }

    public int getStyle() {
        return this.style;
    }

    public boolean isUnderlined() {
        if (this.style == -1) {
            return false;
        }
        return (this.style & 4) == 4;
    }

    public boolean isStrikethru() {
        if (this.style == -1) {
            return false;
        }
        return (this.style & 8) == 8;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public BaseColor getColor() {
        return this.color;
    }

    public BaseFont getBaseFont() {
        return this.baseFont;
    }

    public BaseFont getCalculatedBaseFont(boolean specialEncoding) {
        if (this.baseFont != null) {
            return this.baseFont;
        }
        int style = this.style;
        if (style == -1) {
            style = 0;
        }
        String fontName = "Helvetica";
        String encoding = "Cp1252";
        BaseFont cfont = null;
        block1 : switch (this.family) {
            case COURIER: {
                switch (style & 3) {
                    case 1: {
                        fontName = "Courier-Bold";
                        break block1;
                    }
                    case 2: {
                        fontName = "Courier-Oblique";
                        break block1;
                    }
                    case 3: {
                        fontName = "Courier-BoldOblique";
                        break block1;
                    }
                }
                fontName = "Courier";
                break;
            }
            case TIMES_ROMAN: {
                switch (style & 3) {
                    case 1: {
                        fontName = "Times-Bold";
                        break block1;
                    }
                    case 2: {
                        fontName = "Times-Italic";
                        break block1;
                    }
                    case 3: {
                        fontName = "Times-BoldItalic";
                        break block1;
                    }
                }
                fontName = "Times-Roman";
                break;
            }
            case SYMBOL: {
                fontName = "Symbol";
                if (!specialEncoding) break;
                encoding = "Symbol";
                break;
            }
            case ZAPFDINGBATS: {
                fontName = "ZapfDingbats";
                if (!specialEncoding) break;
                encoding = "ZapfDingbats";
                break;
            }
            default: {
                switch (style & 3) {
                    case 1: {
                        fontName = "Helvetica-Bold";
                        break block1;
                    }
                    case 2: {
                        fontName = "Helvetica-Oblique";
                        break block1;
                    }
                    case 3: {
                        fontName = "Helvetica-BoldOblique";
                        break block1;
                    }
                }
                fontName = "Helvetica";
            }
        }
        try {
            cfont = BaseFont.createFont(fontName, encoding, false);
        }
        catch (Exception ee) {
            throw new ExceptionConverter(ee);
        }
        return cfont;
    }

    public boolean isStandardFont() {
        return this.family == FontFamily.UNDEFINED && this.size == -1.0f && this.style == -1 && this.color == null && this.baseFont == null;
    }

    public Font difference(Font font) {
        BaseColor dColor;
        if (font == null) {
            return this;
        }
        float dSize = font.size;
        if (dSize == -1.0f) {
            dSize = this.size;
        }
        int dStyle = -1;
        int style1 = this.style;
        int style2 = font.getStyle();
        if (style1 != -1 || style2 != -1) {
            if (style1 == -1) {
                style1 = 0;
            }
            if (style2 == -1) {
                style2 = 0;
            }
            dStyle = style1 | style2;
        }
        if ((dColor = font.color) == null) {
            dColor = this.color;
        }
        if (font.baseFont != null) {
            return new Font(font.baseFont, dSize, dStyle, dColor);
        }
        if (font.getFamily() != FontFamily.UNDEFINED) {
            return new Font(font.family, dSize, dStyle, dColor);
        }
        if (this.baseFont != null) {
            if (dStyle == style1) {
                return new Font(this.baseFont, dSize, dStyle, dColor);
            }
            return FontFactory.getFont(this.getFamilyname(), dSize, dStyle, dColor);
        }
        return new Font(this.family, dSize, dStyle, dColor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FontFamily {
        COURIER,
        HELVETICA,
        TIMES_ROMAN,
        SYMBOL,
        ZAPFDINGBATS,
        UNDEFINED;

    }
}

