/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.ElementListener;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.HyphenationEvent;
import com.itextpdf.text.pdf.PdfAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chunk
implements Element {
    public static final Chunk NEWLINE = new Chunk("\n");
    public static final Chunk NEXTPAGE = new Chunk("");
    protected StringBuffer content = null;
    protected Font font = null;
    protected HashMap<String, Object> attributes = null;

    public Chunk() {
        this.content = new StringBuffer();
        this.font = new Font();
    }

    public Chunk(String content, Font font) {
        this.content = new StringBuffer(content);
        this.font = font;
    }

    public Chunk(String content) {
        this(content, new Font());
    }

    public Chunk(Image image, float offsetX, float offsetY) {
        this("\ufffc", new Font());
        Image copyImage = Image.getInstance(image);
        copyImage.setAbsolutePosition(Float.NaN, Float.NaN);
        this.setAttribute("IMAGE", new Object[]{copyImage, new Float(offsetX), new Float(offsetY), Boolean.FALSE});
    }

    @Override
    public boolean process(ElementListener listener) {
        try {
            return listener.add(this);
        }
        catch (DocumentException de) {
            return false;
        }
    }

    @Override
    public int type() {
        return 10;
    }

    @Override
    public List<Chunk> getChunks() {
        ArrayList<Chunk> tmp = new ArrayList<Chunk>();
        tmp.add(this);
        return tmp;
    }

    public StringBuffer append(String string) {
        return this.content.append(string);
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public String getContent() {
        return this.content.toString();
    }

    public String toString() {
        return this.getContent();
    }

    public boolean isEmpty() {
        return this.content.toString().trim().length() == 0 && this.content.toString().indexOf("\n") == -1 && this.attributes == null;
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    public HashMap<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(HashMap<String, Object> attributes) {
        this.attributes = attributes;
    }

    private Chunk setAttribute(String name, Object obj) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, obj);
        return this;
    }

    public Chunk setHyphenation(HyphenationEvent hyphenation) {
        return this.setAttribute("HYPHENATION", hyphenation);
    }

    public Chunk setLocalGoto(String name) {
        return this.setAttribute("LOCALGOTO", name);
    }

    public Chunk setLocalDestination(String name) {
        return this.setAttribute("LOCALDESTINATION", name);
    }

    public Chunk setAnchor(String url) {
        return this.setAttribute("ACTION", new PdfAction(url));
    }

    public Chunk setNewPage() {
        return this.setAttribute("NEWPAGE", null);
    }

    @Override
    public boolean isContent() {
        return true;
    }

    @Override
    public boolean isNestable() {
        return true;
    }

    public HyphenationEvent getHyphenation() {
        if (this.attributes == null) {
            return null;
        }
        return (HyphenationEvent)this.attributes.get("HYPHENATION");
    }

    static {
        NEXTPAGE.setNewPage();
    }
}

