/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.InterpreterError;
import bsh.ParserConstants;
import bsh.Reflect;
import bsh.Types;
import bsh.UtilEvalError;
import bsh.UtilTargetError;
import java.io.Serializable;
import java.util.Hashtable;

public final class Primitive
implements ParserConstants,
Serializable {
    static Hashtable wrapperMap = new Hashtable();
    private Object value;
    public static final Primitive NULL;
    public static final Primitive VOID;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$bsh$Primitive;

    public Primitive(Object object) {
        if (object == null) {
            throw new InterpreterError("Use Primitve.NULL instead of Primitive(null)");
        }
        if (object != Special.NULL_VALUE && object != Special.VOID_TYPE && !Primitive.isWrapperType(object.getClass())) {
            throw new InterpreterError("Not a wrapper type: " + object);
        }
        this.value = object;
    }

    public Primitive(boolean bl) {
        this(new Boolean(bl));
    }

    public Primitive(byte by) {
        this(new Byte(by));
    }

    public Primitive(short s) {
        this(new Short(s));
    }

    public Primitive(char c) {
        this(new Character(c));
    }

    public Primitive(int n) {
        this(new Integer(n));
    }

    public Primitive(long l) {
        this(new Long(l));
    }

    public Primitive(float f) {
        this(new Float(f));
    }

    public Primitive(double d) {
        this(new Double(d));
    }

    public Object getValue() {
        if (this.value == Special.NULL_VALUE) {
            return null;
        }
        if (this.value == Special.VOID_TYPE) {
            throw new InterpreterError("attempt to unwrap void type");
        }
        return this.value;
    }

    public String toString() {
        if (this.value == Special.NULL_VALUE) {
            return "null";
        }
        if (this.value == Special.VOID_TYPE) {
            return "void";
        }
        return this.value.toString();
    }

    public Class getType() {
        if (this == VOID) {
            return Void.TYPE;
        }
        if (this == NULL) {
            return null;
        }
        return Primitive.unboxType(this.value.getClass());
    }

    public static Object binaryOperation(Object object, Object object2, int n) throws UtilEvalError {
        Object object3;
        if (object == NULL || object2 == NULL) {
            throw new UtilEvalError("Null value or 'null' literal in binary operation");
        }
        if (object == VOID || object2 == VOID) {
            throw new UtilEvalError("Undefined variable, class, or 'void' literal in binary operation");
        }
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = object2.getClass();
        if (object instanceof Primitive) {
            object = ((Primitive)object).getValue();
        }
        if (object2 instanceof Primitive) {
            object2 = ((Primitive)object2).getValue();
        }
        Object[] objectArray = Primitive.promotePrimitives(object, object2);
        Object object4 = objectArray[0];
        Object object5 = objectArray[1];
        if (object4.getClass() != object5.getClass()) {
            throw new UtilEvalError("Type mismatch in operator.  " + object4.getClass() + " cannot be used with " + object5.getClass());
        }
        try {
            object3 = Primitive.binaryOperationImpl(object4, object5, n);
        }
        catch (ArithmeticException arithmeticException) {
            throw new UtilTargetError("Arithemetic Exception in binary op", arithmeticException);
        }
        if (clazz == (class$bsh$Primitive == null ? (class$bsh$Primitive = Primitive.class$("bsh.Primitive")) : class$bsh$Primitive) && clazz2 == (class$bsh$Primitive == null ? (class$bsh$Primitive = Primitive.class$("bsh.Primitive")) : class$bsh$Primitive) || object3 instanceof Boolean) {
            return new Primitive(object3);
        }
        return object3;
    }

    static Object binaryOperationImpl(Object object, Object object2, int n) throws UtilEvalError {
        if (object instanceof Boolean) {
            return Primitive.booleanBinaryOperation((Boolean)object, (Boolean)object2, n);
        }
        if (object instanceof Integer) {
            return Primitive.intBinaryOperation((Integer)object, (Integer)object2, n);
        }
        if (object instanceof Long) {
            return Primitive.longBinaryOperation((Long)object, (Long)object2, n);
        }
        if (object instanceof Float) {
            return Primitive.floatBinaryOperation((Float)object, (Float)object2, n);
        }
        if (object instanceof Double) {
            return Primitive.doubleBinaryOperation((Double)object, (Double)object2, n);
        }
        throw new UtilEvalError("Invalid types in binary operator");
    }

    static Boolean booleanBinaryOperation(Boolean bl, Boolean bl2, int n) {
        boolean bl3 = bl;
        boolean bl4 = bl2;
        switch (n) {
            case 90: {
                return new Boolean(bl3 == bl4);
            }
            case 95: {
                return new Boolean(bl3 != bl4);
            }
            case 96: 
            case 97: {
                return new Boolean(bl3 || bl4);
            }
            case 98: 
            case 99: {
                return new Boolean(bl3 && bl4);
            }
        }
        throw new InterpreterError("unimplemented binary operator");
    }

    static Object longBinaryOperation(Long l, Long l2, int n) {
        long l3 = l;
        long l4 = l2;
        switch (n) {
            case 84: 
            case 85: {
                return new Boolean(l3 < l4);
            }
            case 82: 
            case 83: {
                return new Boolean(l3 > l4);
            }
            case 90: {
                return new Boolean(l3 == l4);
            }
            case 91: 
            case 92: {
                return new Boolean(l3 <= l4);
            }
            case 93: 
            case 94: {
                return new Boolean(l3 >= l4);
            }
            case 95: {
                return new Boolean(l3 != l4);
            }
            case 102: {
                return new Long(l3 + l4);
            }
            case 103: {
                return new Long(l3 - l4);
            }
            case 104: {
                return new Long(l3 * l4);
            }
            case 105: {
                return new Long(l3 / l4);
            }
            case 111: {
                return new Long(l3 % l4);
            }
            case 112: 
            case 113: {
                return new Long(l3 << (int)l4);
            }
            case 114: 
            case 115: {
                return new Long(l3 >> (int)l4);
            }
            case 116: 
            case 117: {
                return new Long(l3 >>> (int)l4);
            }
            case 106: 
            case 107: {
                return new Long(l3 & l4);
            }
            case 108: 
            case 109: {
                return new Long(l3 | l4);
            }
            case 110: {
                return new Long(l3 ^ l4);
            }
        }
        throw new InterpreterError("Unimplemented binary long operator");
    }

    static Object intBinaryOperation(Integer n, Integer n2, int n3) {
        int n4 = n;
        int n5 = n2;
        switch (n3) {
            case 84: 
            case 85: {
                return new Boolean(n4 < n5);
            }
            case 82: 
            case 83: {
                return new Boolean(n4 > n5);
            }
            case 90: {
                return new Boolean(n4 == n5);
            }
            case 91: 
            case 92: {
                return new Boolean(n4 <= n5);
            }
            case 93: 
            case 94: {
                return new Boolean(n4 >= n5);
            }
            case 95: {
                return new Boolean(n4 != n5);
            }
            case 102: {
                return new Integer(n4 + n5);
            }
            case 103: {
                return new Integer(n4 - n5);
            }
            case 104: {
                return new Integer(n4 * n5);
            }
            case 105: {
                return new Integer(n4 / n5);
            }
            case 111: {
                return new Integer(n4 % n5);
            }
            case 112: 
            case 113: {
                return new Integer(n4 << n5);
            }
            case 114: 
            case 115: {
                return new Integer(n4 >> n5);
            }
            case 116: 
            case 117: {
                return new Integer(n4 >>> n5);
            }
            case 106: 
            case 107: {
                return new Integer(n4 & n5);
            }
            case 108: 
            case 109: {
                return new Integer(n4 | n5);
            }
            case 110: {
                return new Integer(n4 ^ n5);
            }
        }
        throw new InterpreterError("Unimplemented binary integer operator");
    }

    static Object doubleBinaryOperation(Double d, Double d2, int n) throws UtilEvalError {
        double d3 = d;
        double d4 = d2;
        switch (n) {
            case 84: 
            case 85: {
                return new Boolean(d3 < d4);
            }
            case 82: 
            case 83: {
                return new Boolean(d3 > d4);
            }
            case 90: {
                return new Boolean(d3 == d4);
            }
            case 91: 
            case 92: {
                return new Boolean(d3 <= d4);
            }
            case 93: 
            case 94: {
                return new Boolean(d3 >= d4);
            }
            case 95: {
                return new Boolean(d3 != d4);
            }
            case 102: {
                return new Double(d3 + d4);
            }
            case 103: {
                return new Double(d3 - d4);
            }
            case 104: {
                return new Double(d3 * d4);
            }
            case 105: {
                return new Double(d3 / d4);
            }
            case 111: {
                return new Double(d3 % d4);
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                throw new UtilEvalError("Can't shift doubles");
            }
        }
        throw new InterpreterError("Unimplemented binary double operator");
    }

    static Object floatBinaryOperation(Float f, Float f2, int n) throws UtilEvalError {
        float f3 = f.floatValue();
        float f4 = f2.floatValue();
        switch (n) {
            case 84: 
            case 85: {
                return new Boolean(f3 < f4);
            }
            case 82: 
            case 83: {
                return new Boolean(f3 > f4);
            }
            case 90: {
                return new Boolean(f3 == f4);
            }
            case 91: 
            case 92: {
                return new Boolean(f3 <= f4);
            }
            case 93: 
            case 94: {
                return new Boolean(f3 >= f4);
            }
            case 95: {
                return new Boolean(f3 != f4);
            }
            case 102: {
                return new Float(f3 + f4);
            }
            case 103: {
                return new Float(f3 - f4);
            }
            case 104: {
                return new Float(f3 * f4);
            }
            case 105: {
                return new Float(f3 / f4);
            }
            case 111: {
                return new Float(f3 % f4);
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                throw new UtilEvalError("Can't shift floats ");
            }
        }
        throw new InterpreterError("Unimplemented binary float operator");
    }

    static Object promoteToInteger(Object object) {
        if (object instanceof Character) {
            return new Integer(((Character)object).charValue());
        }
        if (object instanceof Byte || object instanceof Short) {
            return new Integer(((Number)object).intValue());
        }
        return object;
    }

    static Object[] promotePrimitives(Object object, Object object2) {
        object = Primitive.promoteToInteger(object);
        object2 = Primitive.promoteToInteger(object2);
        if (object instanceof Number && object2 instanceof Number) {
            Number number = (Number)object;
            Number number2 = (Number)object2;
            boolean bl = number instanceof Double;
            if (bl || number2 instanceof Double) {
                if (bl) {
                    object2 = new Double(number2.doubleValue());
                } else {
                    object = new Double(number.doubleValue());
                }
            } else {
                bl = number instanceof Float;
                if (bl || number2 instanceof Float) {
                    if (bl) {
                        object2 = new Float(number2.floatValue());
                    } else {
                        object = new Float(number.floatValue());
                    }
                } else {
                    bl = number instanceof Long;
                    if (bl || number2 instanceof Long) {
                        if (bl) {
                            object2 = new Long(number2.longValue());
                        } else {
                            object = new Long(number.longValue());
                        }
                    }
                }
            }
        }
        return new Object[]{object, object2};
    }

    public static Primitive unaryOperation(Primitive primitive, int n) throws UtilEvalError {
        if (primitive == NULL) {
            throw new UtilEvalError("illegal use of null object or 'null' literal");
        }
        if (primitive == VOID) {
            throw new UtilEvalError("illegal use of undefined object or 'void' literal");
        }
        Class clazz = primitive.getType();
        Object object = Primitive.promoteToInteger(primitive.getValue());
        if (object instanceof Boolean) {
            return new Primitive(Primitive.booleanUnaryOperation((Boolean)object, n));
        }
        if (object instanceof Integer) {
            int n2 = Primitive.intUnaryOperation((Integer)object, n);
            if (n == 100 || n == 101) {
                if (clazz == Byte.TYPE) {
                    return new Primitive((byte)n2);
                }
                if (clazz == Short.TYPE) {
                    return new Primitive((short)n2);
                }
                if (clazz == Character.TYPE) {
                    return new Primitive((char)n2);
                }
            }
            return new Primitive(n2);
        }
        if (object instanceof Long) {
            return new Primitive(Primitive.longUnaryOperation((Long)object, n));
        }
        if (object instanceof Float) {
            return new Primitive(Primitive.floatUnaryOperation((Float)object, n));
        }
        if (object instanceof Double) {
            return new Primitive(Primitive.doubleUnaryOperation((Double)object, n));
        }
        throw new InterpreterError("An error occurred.  Please call technical support.");
    }

    static boolean booleanUnaryOperation(Boolean bl, int n) throws UtilEvalError {
        boolean bl2 = bl;
        switch (n) {
            case 86: {
                return !bl2;
            }
        }
        throw new UtilEvalError("Operator inappropriate for boolean");
    }

    static int intUnaryOperation(Integer n, int n2) {
        int n3 = n;
        switch (n2) {
            case 102: {
                return n3;
            }
            case 103: {
                return -n3;
            }
            case 87: {
                return ~n3;
            }
            case 100: {
                return n3 + 1;
            }
            case 101: {
                return n3 - 1;
            }
        }
        throw new InterpreterError("bad integer unaryOperation");
    }

    static long longUnaryOperation(Long l, int n) {
        long l2 = l;
        switch (n) {
            case 102: {
                return l2;
            }
            case 103: {
                return -l2;
            }
            case 87: {
                return l2 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case 100: {
                return l2 + 1L;
            }
            case 101: {
                return l2 - 1L;
            }
        }
        throw new InterpreterError("bad long unaryOperation");
    }

    static float floatUnaryOperation(Float f, int n) {
        float f2 = f.floatValue();
        switch (n) {
            case 102: {
                return f2;
            }
            case 103: {
                return -f2;
            }
        }
        throw new InterpreterError("bad float unaryOperation");
    }

    static double doubleUnaryOperation(Double d, int n) {
        double d2 = d;
        switch (n) {
            case 102: {
                return d2;
            }
            case 103: {
                return -d2;
            }
        }
        throw new InterpreterError("bad double unaryOperation");
    }

    public int intValue() throws UtilEvalError {
        if (this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        throw new UtilEvalError("Primitive not a number");
    }

    public boolean equals(Object object) {
        if (object instanceof Primitive) {
            return ((Primitive)object).value.equals(this.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode() * 21;
    }

    public static Object unwrap(Object object) {
        if (object == VOID) {
            return null;
        }
        if (object instanceof Primitive) {
            return ((Primitive)object).getValue();
        }
        return object;
    }

    public static Object[] unwrap(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            objectArray2[n] = Primitive.unwrap(objectArray[n]);
            ++n;
        }
        return objectArray2;
    }

    public static Object[] wrap(Object[] objectArray, Class[] classArray) {
        if (objectArray == null) {
            return null;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            objectArray2[n] = Primitive.wrap(objectArray[n], classArray[n]);
            ++n;
        }
        return objectArray2;
    }

    public static Object wrap(Object object, Class clazz) {
        if (clazz == Void.TYPE) {
            return VOID;
        }
        if (object == null) {
            return NULL;
        }
        if (clazz.isPrimitive()) {
            return new Primitive(object);
        }
        return object;
    }

    public static Primitive getDefaultValue(Class clazz) {
        if (clazz == null || !clazz.isPrimitive()) {
            return NULL;
        }
        if (clazz == Boolean.TYPE) {
            return new Primitive(false);
        }
        try {
            return new Primitive(0).castToType(clazz, 0);
        }
        catch (UtilEvalError utilEvalError) {
            throw new InterpreterError("bad cast");
        }
    }

    public static Class unboxType(Class clazz) {
        Class clazz2 = (Class)wrapperMap.get(clazz);
        if (clazz2 != null) {
            return clazz2;
        }
        throw new InterpreterError("Not a primitive wrapper type: " + clazz);
    }

    public Primitive castToType(Class clazz, int n) throws UtilEvalError {
        return Primitive.castPrimitive(clazz, this.getType(), this, false, n);
    }

    static Primitive castPrimitive(Class clazz, Class clazz2, Primitive primitive, boolean bl, int n) throws UtilEvalError {
        if (bl && primitive != null) {
            throw new InterpreterError("bad cast param 1");
        }
        if (!bl && primitive == null) {
            throw new InterpreterError("bad cast param 2");
        }
        if (clazz2 != null && !clazz2.isPrimitive()) {
            throw new InterpreterError("bad fromType:" + clazz2);
        }
        if (primitive == NULL && clazz2 != null) {
            throw new InterpreterError("inconsistent args 1");
        }
        if (primitive == VOID && clazz2 != Void.TYPE) {
            throw new InterpreterError("inconsistent args 2");
        }
        if (clazz2 == Void.TYPE) {
            if (bl) {
                return Types.INVALID_CAST;
            }
            throw Types.castError(Reflect.normalizeClassName(clazz), "void value", n);
        }
        Object object = null;
        if (primitive != null) {
            object = primitive.getValue();
        }
        if (clazz.isPrimitive()) {
            if (clazz2 == null) {
                if (bl) {
                    return Types.INVALID_CAST;
                }
                throw Types.castError("primitive type:" + clazz, "Null value", n);
            }
        } else {
            if (clazz2 == null) {
                return bl ? Types.VALID_CAST : NULL;
            }
            if (bl) {
                return Types.INVALID_CAST;
            }
            throw Types.castError("object type:" + clazz, "primitive value", n);
        }
        if (clazz2 == Boolean.TYPE) {
            if (clazz != Boolean.TYPE) {
                if (bl) {
                    return Types.INVALID_CAST;
                }
                throw Types.castError(clazz, clazz2, n);
            }
            return bl ? Types.VALID_CAST : primitive;
        }
        if (n == 1 && !Types.isJavaAssignable(clazz, clazz2)) {
            if (bl) {
                return Types.INVALID_CAST;
            }
            throw Types.castError(clazz, clazz2, n);
        }
        return bl ? Types.VALID_CAST : new Primitive(Primitive.castWrapper(clazz, object));
    }

    public static boolean isWrapperType(Class clazz) {
        return wrapperMap.get(clazz) != null && !clazz.isPrimitive();
    }

    static Object castWrapper(Class clazz, Object object) {
        if (!clazz.isPrimitive()) {
            throw new InterpreterError("invalid type in castWrapper: " + clazz);
        }
        if (object == null) {
            throw new InterpreterError("null value in castWrapper, guard");
        }
        if (object instanceof Boolean) {
            if (clazz != Boolean.TYPE) {
                throw new InterpreterError("bad wrapper cast of boolean");
            }
            return object;
        }
        if (object instanceof Character) {
            object = new Integer(((Character)object).charValue());
        }
        if (!(object instanceof Number)) {
            throw new InterpreterError("bad type in cast");
        }
        Number number = (Number)object;
        if (clazz == Byte.TYPE) {
            return new Byte(number.byteValue());
        }
        if (clazz == Short.TYPE) {
            return new Short(number.shortValue());
        }
        if (clazz == Character.TYPE) {
            return new Character((char)number.intValue());
        }
        if (clazz == Integer.TYPE) {
            return new Integer(number.intValue());
        }
        if (clazz == Long.TYPE) {
            return new Long(number.longValue());
        }
        if (clazz == Float.TYPE) {
            return new Float(number.floatValue());
        }
        if (clazz == Double.TYPE) {
            return new Double(number.doubleValue());
        }
        throw new InterpreterError("error in wrapper cast");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        wrapperMap.put(Boolean.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = Primitive.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        wrapperMap.put(Byte.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = Primitive.class$("java.lang.Byte")) : class$java$lang$Byte);
        wrapperMap.put(Short.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = Primitive.class$("java.lang.Short")) : class$java$lang$Short);
        wrapperMap.put(Character.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = Primitive.class$("java.lang.Character")) : class$java$lang$Character);
        wrapperMap.put(Integer.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = Primitive.class$("java.lang.Integer")) : class$java$lang$Integer);
        wrapperMap.put(Long.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = Primitive.class$("java.lang.Long")) : class$java$lang$Long);
        wrapperMap.put(Float.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = Primitive.class$("java.lang.Float")) : class$java$lang$Float);
        wrapperMap.put(Double.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = Primitive.class$("java.lang.Double")) : class$java$lang$Double);
        wrapperMap.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = Primitive.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.TYPE);
        wrapperMap.put(class$java$lang$Byte == null ? (class$java$lang$Byte = Primitive.class$("java.lang.Byte")) : class$java$lang$Byte, Byte.TYPE);
        wrapperMap.put(class$java$lang$Short == null ? (class$java$lang$Short = Primitive.class$("java.lang.Short")) : class$java$lang$Short, Short.TYPE);
        wrapperMap.put(class$java$lang$Character == null ? (class$java$lang$Character = Primitive.class$("java.lang.Character")) : class$java$lang$Character, Character.TYPE);
        wrapperMap.put(class$java$lang$Integer == null ? (class$java$lang$Integer = Primitive.class$("java.lang.Integer")) : class$java$lang$Integer, Integer.TYPE);
        wrapperMap.put(class$java$lang$Long == null ? (class$java$lang$Long = Primitive.class$("java.lang.Long")) : class$java$lang$Long, Long.TYPE);
        wrapperMap.put(class$java$lang$Float == null ? (class$java$lang$Float = Primitive.class$("java.lang.Float")) : class$java$lang$Float, Float.TYPE);
        wrapperMap.put(class$java$lang$Double == null ? (class$java$lang$Double = Primitive.class$("java.lang.Double")) : class$java$lang$Double, Double.TYPE);
        NULL = new Primitive(Special.NULL_VALUE);
        VOID = new Primitive(Special.VOID_TYPE);
    }

    private static class Special
    implements Serializable {
        public static final Special NULL_VALUE = new Special();
        public static final Special VOID_TYPE = new Special();

        private Special() {
        }
    }
}

