import injector
import sims4.resources
from sims4.tuning.instance_manager import InstanceManager
from sims4.resources import Types
import services

SNIPPET_ID = 24508
MIXER_ID = 11201874672541317407

@injector.inject_to(InstanceManager, 'load_data_into_class_instances')
def add_mixer_to_snippet(original, self):
    # Let the original function finish up its work
    original(self)

    # This function gets called once for each tuning type, so by only running this if we're specifically
    # working on the snippets, we can just get that snippet directly using the key rather than looping
    # through all the instances to and checking the guids.  The same tactic works for getting the tuning
    # straight for the mixer interaction directly from the affordance manager.

    if self.TYPE == Types.SNIPPET:
        # Get the snippet tuning
        key = sims4.resources.get_resource_key(SNIPPET_ID, Types.SNIPPET)
        snippet_tuning = self._tuned_classes.get(key)
        # Check that we found it....
        # If we were running in a loop, we'd probably want to skip to the next iteration
        # rather than just returning if the snippet id is invalid.
        if snippet_tuning is None:
            return
        # Get the mixer from the affordance manager
        affordance_manager = services.affordance_manager()
        key = sims4.resources.get_resource_key(MIXER_ID, Types.INTERACTION)
        mixer_tuning = affordance_manager.get(key)
        if mixer_tuning is None:
            return
        # Add the mixer tuning to the snippet's value (a tuple)
        snippet_tuning.value = snippet_tuning.value + (mixer_tuning, )