/*
 * Decompiled with CFR 0.152.
 */
package com.sci.torcherino.update;

import com.sci.torcherino.update.IUpdatableMod;
import com.sci.torcherino.update.UpdateCheckThread;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public final class UpdateChecker {
    private IUpdatableMod mod;
    private int lastPoll = 100;
    private boolean displayed = false;
    private UpdateCheckThread thread;

    private UpdateChecker(IUpdatableMod mod) {
        this.mod = mod;
        this.thread = new UpdateCheckThread(mod);
        this.thread.start();
    }

    @SubscribeEvent
    public void tickStart(TickEvent.PlayerTickEvent evt) {
        if (evt.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.lastPoll > 0) {
            --this.lastPoll;
            return;
        }
        this.lastPoll = 400;
        if (!this.displayed && this.thread.checkComplete()) {
            this.displayed = true;
            FMLCommonHandler.instance().bus().unregister((Object)this);
            if (this.thread.newVersionAvailable()) {
                EntityPlayer player = evt.player;
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "[" + this.mod.name() + "] " + EnumChatFormatting.WHITE + "A new version is available: " + EnumChatFormatting.AQUA + this.thread.latest().toString()));
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GRAY + this.thread.description()));
            }
            try {
                this.thread.interrupt();
                this.thread.join();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.thread = null;
            }
        }
    }

    public static UpdateChecker register(IUpdatableMod updatableMod) {
        UpdateChecker checker = new UpdateChecker(updatableMod);
        FMLCommonHandler.instance().bus().register((Object)checker);
        return checker;
    }
}

