/*
 * Decompiled with CFR 0.152.
 */
package com.sci.torcherino.tile;

import com.sci.torcherino.TorcherinoRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;

public class TileTorcherino
extends TileEntity
implements ITickable {
    private static final String[] MODES = new String[]{"Stopped", "Radius: +1, Area: 3x3x3", "Radius: +2, Area: 5x3x5", "Radius: +3, Area: 7x3x7", "Radius: +4, Area: 9x3x9"};
    private static final int SPEEDS = 4;
    private boolean poweredByRedstone;
    private byte speed;
    private byte mode;
    private byte cachedMode = (byte)-1;
    private Random rand = new Random();
    private int xMin;
    private int yMin;
    private int zMin;
    private int xMax;
    private int yMax;
    private int zMax;

    protected int speed(int base) {
        return base;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.poweredByRedstone || this.mode == 0 || this.speed == 0) {
            return;
        }
        this.updateCachedModeIfNeeded();
        this.tickNeighbors();
    }

    private void updateCachedModeIfNeeded() {
        if (this.cachedMode != this.mode) {
            this.xMin = this.field_174879_c.func_177958_n() - this.mode;
            this.yMin = this.field_174879_c.func_177956_o() - 1;
            this.zMin = this.field_174879_c.func_177952_p() - this.mode;
            this.xMax = this.field_174879_c.func_177958_n() + this.mode;
            this.yMax = this.field_174879_c.func_177956_o() + 1;
            this.zMax = this.field_174879_c.func_177952_p() + this.mode;
            this.cachedMode = this.mode;
        }
    }

    private void tickNeighbors() {
        for (int x = this.xMin; x <= this.xMax; ++x) {
            for (int y = this.yMin; y <= this.yMax; ++y) {
                for (int z = this.zMin; z <= this.zMax; ++z) {
                    this.tickBlock(new BlockPos(x, y, z));
                }
            }
        }
    }

    private void tickBlock(BlockPos pos) {
        TileEntity tile;
        IBlockState blockState = this.field_145850_b.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block == null) {
            return;
        }
        if (TorcherinoRegistry.isBlockBlacklisted(block)) {
            return;
        }
        if (block instanceof BlockFluidBase) {
            return;
        }
        if (block.func_149653_t()) {
            for (int i = 0; i < this.speed && this.func_145831_w().func_180495_p(pos) == blockState; ++i) {
                block.func_180650_b(this.field_145850_b, pos, blockState, this.rand);
            }
        }
        if (block.hasTileEntity(this.field_145850_b.func_180495_p(pos)) && (tile = this.field_145850_b.func_175625_s(pos)) != null && !tile.func_145837_r()) {
            if (TorcherinoRegistry.isTileBlacklisted(tile.getClass())) {
                return;
            }
            for (int i = 0; i < this.speed(this.speed) && !tile.func_145837_r(); ++i) {
                if (!(tile instanceof ITickable)) continue;
                ((ITickable)tile).func_73660_a();
            }
        }
    }

    public void setPoweredByRedstone(boolean poweredByRedstone) {
        this.poweredByRedstone = poweredByRedstone;
    }

    public void changeMode(boolean sneaking) {
        if (sneaking) {
            this.speed = this.speed < 4 ? (byte)(this.speed + 1) : (byte)0;
        } else {
            this.mode = this.mode < MODES.length - 1 ? (byte)(this.mode + 1) : (byte)0;
        }
    }

    public String getSpeedDescription() {
        return this.speed(this.speed) * 100 + "% increase";
    }

    public String getModeDescription() {
        return MODES[this.mode];
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74774_a("Speed", this.speed);
        tag.func_74774_a("Mode", this.mode);
        tag.func_74757_a("PoweredByRedstone", this.poweredByRedstone);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.speed = tag.func_74771_c("Speed");
        this.mode = tag.func_74771_c("Mode");
        this.poweredByRedstone = tag.func_74767_n("PoweredByRedstone");
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), -999, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }
}

