/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.traits;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.potion.TinkerPotion;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class TraitMomentum
extends AbstractTrait {
    public static final TinkerPotion Momentum = new TinkerPotion(Util.getResource("momentum"), false, false);

    public TraitMomentum() {
        super("momentum", EnumChatFormatting.BLUE);
    }

    @Override
    public void miningSpeed(ItemStack tool, PlayerEvent.BreakSpeed event) {
        float boost = Momentum.getLevel((EntityLivingBase)event.entityPlayer);
        event.newSpeed += event.originalSpeed * (boost /= 80.0f);
    }

    @Override
    public void afterBlockBreak(ItemStack tool, World world, Block block, BlockPos pos, EntityLivingBase player, boolean wasEffective) {
        int level = 1;
        level += Momentum.getLevel(player);
        level = Math.min(32, level);
        int duration = (int)(10.0f / ToolHelper.getActualMiningSpeed(tool) * 1.5f * 20.0f);
        Momentum.apply(player, duration, level);
    }
}

