/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials;

import java.text.DecimalFormat;
import net.minecraft.util.EnumChatFormatting;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.IMaterialStats;

public abstract class AbstractMaterialStats
implements IMaterialStats {
    public static final DecimalFormat df = new DecimalFormat("#,###,###.##");
    public static final DecimalFormat dfPercent = new DecimalFormat("#%");
    protected final String materialType;

    public AbstractMaterialStats(String materialType) {
        this.materialType = materialType;
    }

    @Override
    public String getIdentifier() {
        return this.materialType;
    }

    @Override
    public String getLocalizedName() {
        return Util.translate("stat.%s.name", this.materialType);
    }

    public static String formatNumber(String loc, String color, int number) {
        return AbstractMaterialStats.formatNumber(loc, color, (float)number);
    }

    public static String formatNumber(String loc, String color, float number) {
        return String.format("%s: %s%s", Util.translate(loc, new Object[0]), color, df.format(number)) + EnumChatFormatting.RESET;
    }
}

