/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockReed;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;

public class Scythe
extends AoeToolCore {
    public static final float DURABILITY_MODIFIER = 2.2f;
    public static final ImmutableSet<Material> effective_materials = ImmutableSet.of((Object)Material.field_151569_G, (Object)Material.field_151584_j, (Object)Material.field_151585_k, (Object)Material.field_151582_l, (Object)Material.field_151572_C, (Object)Material.field_151570_A, (Object[])new Material[0]);

    public Scythe() {
        super(PartMaterialType.handle(TinkerTools.toughToolRod), PartMaterialType.head(TinkerTools.scytheHead), PartMaterialType.extra(TinkerTools.toughBinding), PartMaterialType.handle(TinkerTools.toughToolRod));
        this.addCategory(Category.HARVEST, Category.WEAPON);
    }

    @Override
    public float damagePotential() {
        return 0.75f;
    }

    @Override
    public double attackSpeed() {
        return 0.9f;
    }

    @Override
    public boolean isEffective(IBlockState state) {
        return effective_materials.contains((Object)state.func_185904_a());
    }

    protected void breakBlock(ItemStack stack, EntityPlayer player, BlockPos pos, BlockPos refPos) {
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0 && ToolHelper.shearBlock(stack, player.func_130014_f_(), player, pos)) {
            return;
        }
        ToolHelper.breakExtraBlock(stack, player.func_130014_f_(), player, pos, refPos);
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        if (!ToolHelper.isBroken(stack) && this.isAoeHarvestTool()) {
            for (BlockPos extraPos : this.getAOEBlocks(stack, player.func_130014_f_(), player, pos)) {
                this.breakBlock(stack, player, extraPos, pos);
            }
        }
        return super.onBlockStartBreak(stack, pos, player);
    }

    @Override
    public ImmutableList<BlockPos> getAOEBlocks(ItemStack stack, World world, EntityPlayer player, BlockPos origin) {
        return ToolHelper.calcAOEBlocks(stack, world, player, origin, 3, 3, 3);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity target) {
        if (player.func_184825_o(0.5f) <= 0.9f) {
            return super.onLeftClickEntity(stack, player, target);
        }
        TinkerToolEvent.ExtraBlockBreak event = TinkerToolEvent.ExtraBlockBreak.fireEvent(stack, player, player.func_130014_f_().func_180495_p(target.func_180425_c()), 3, 3, 3, -1);
        if (event.isCanceled()) {
            return false;
        }
        player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187730_dW, player.func_184176_by(), 1.0f, 1.0f);
        player.func_184810_cG();
        int distance = event.distance;
        boolean hit = false;
        for (Entity entity : this.getAoeEntities(player, target, event)) {
            if (distance >= 0 && !(entity.func_70032_d(target) <= (float)distance)) continue;
            hit |= ToolHelper.attackEntity(stack, this, (EntityLivingBase)player, entity, null, false);
        }
        if (hit) {
            player.func_184821_cY();
        }
        return hit;
    }

    private List<Entity> getAoeEntities(EntityPlayer player, Entity target, TinkerToolEvent.ExtraBlockBreak event) {
        int width = (event.width - 1) / 2;
        int height = (event.width - 1) / 2;
        AxisAlignedBB box = new AxisAlignedBB(target.field_70165_t, target.field_70163_u, target.field_70161_v, target.field_70165_t + 1.0, target.field_70163_u + 1.0, target.field_70161_v + 1.0).func_72314_b((double)width, (double)height, (double)width);
        return player.func_130014_f_().func_72839_b((Entity)player, box);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (ToolHelper.isBroken(itemStackIn)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemStackIn);
        }
        RayTraceResult trace = this.func_77621_a(worldIn, playerIn, true);
        if (trace == null || trace.field_72313_a != RayTraceResult.Type.BLOCK) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
        }
        int fortune = ToolHelper.getFortuneLevel(itemStackIn);
        BlockPos origin = trace.func_178782_a();
        boolean harvestedSomething = false;
        for (BlockPos pos : this.getAOEBlocks(itemStackIn, playerIn.func_130014_f_(), playerIn, origin)) {
            harvestedSomething |= this.harvestCrop(itemStackIn, worldIn, playerIn, pos, fortune);
        }
        if (harvestedSomething |= this.harvestCrop(itemStackIn, worldIn, playerIn, origin, fortune)) {
            playerIn.func_184609_a(hand);
            playerIn.func_130014_f_().func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187730_dW, playerIn.func_184176_by(), 1.0f, 1.0f);
            playerIn.func_184810_cG();
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    protected boolean canHarvestCrop(IBlockState state) {
        boolean canHarvest = state.func_177230_c() instanceof BlockReed;
        if (state.func_177230_c() instanceof BlockCrops && ((BlockCrops)state.func_177230_c()).func_185525_y(state)) {
            canHarvest = true;
        }
        return canHarvest;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (!(target instanceof IShearable)) {
            return false;
        }
        TinkerToolEvent.ExtraBlockBreak event = TinkerToolEvent.ExtraBlockBreak.fireEvent(stack, player, player.func_130014_f_().func_180495_p(target.func_180425_c()), 3, 3, 3, -1);
        if (event.isCanceled()) {
            return false;
        }
        int distance = event.distance;
        boolean shorn = false;
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        for (Entity entity : this.getAoeEntities(player, (Entity)target, event)) {
            if (distance >= 0 && !(entity.func_70032_d((Entity)target) <= (float)distance)) continue;
            shorn |= this.shearEntity(stack, player.func_130014_f_(), player, entity, fortune);
        }
        if (shorn) {
            player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187730_dW, player.func_184176_by(), 1.0f, 1.0f);
            player.func_184810_cG();
        }
        return shorn;
    }

    public boolean harvestCrop(ItemStack stack, World world, EntityPlayer player, BlockPos pos, int fortune) {
        TinkerToolEvent.OnScytheHarvest event;
        IBlockState state = world.func_180495_p(pos);
        boolean canHarvest = this.canHarvestCrop(state);
        if (state.func_177230_c() instanceof BlockReed && !(world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockReed)) {
            canHarvest = false;
        }
        if ((event = TinkerToolEvent.OnScytheHarvest.fireEvent(stack, player, world, pos, state, canHarvest)).isCanceled()) {
            return false;
        }
        if (event.getResult() == Event.Result.DENY) {
            return true;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            canHarvest = true;
        }
        if (!canHarvest) {
            return false;
        }
        if (!world.field_72995_K) {
            this.doHarvestCrop(stack, world, player, pos, fortune, state);
        }
        return true;
    }

    protected void doHarvestCrop(ItemStack stack, World world, EntityPlayer player, BlockPos pos, int fortune, IBlockState state) {
        IBlockState down;
        float chance = 1.0f;
        List drops = state.func_177230_c().getDrops((IBlockAccess)world, pos, state, fortune);
        chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)player);
        IPlantable seed = null;
        for (ItemStack drop : drops) {
            if (drop == null || !(drop.func_77973_b() instanceof IPlantable)) continue;
            seed = (IPlantable)drop.func_77973_b();
            drop.func_190918_g(1);
            if (!drop.func_190926_b()) break;
            drops.remove(drop);
            break;
        }
        boolean replanted = false;
        if (seed != null && (down = world.func_180495_p(pos.func_177977_b())).func_177230_c().canSustainPlant(down, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, seed)) {
            IBlockState crop = seed.getPlant((IBlockAccess)world, pos);
            if (crop != state) {
                world.func_175656_a(pos, seed.getPlant((IBlockAccess)world, pos));
                ToolHelper.damageTool(stack, 1, (EntityLivingBase)player);
            }
            for (ItemStack drop : drops) {
                if (!(world.field_73012_v.nextFloat() <= chance)) continue;
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
            }
            replanted = true;
        }
        if (!replanted) {
            this.breakBlock(stack, player, pos, pos);
        }
    }

    public boolean shearEntity(ItemStack stack, World world, EntityPlayer player, Entity entity, int fortune) {
        if (!(entity instanceof IShearable)) {
            return false;
        }
        IShearable shearable = (IShearable)entity;
        if (shearable.isShearable(stack, (IBlockAccess)world, entity.func_180425_c())) {
            if (!world.field_72995_K) {
                List drops = shearable.onSheared(stack, (IBlockAccess)world, entity.func_180425_c(), fortune);
                Random rand = world.field_73012_v;
                for (ItemStack drop : drops) {
                    EntityItem entityItem = entity.func_70099_a(drop, 1.0f);
                    if (entityItem == null) continue;
                    entityItem.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                    entityItem.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                    entityItem.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                }
            }
            ToolHelper.damageTool(stack, 1, (EntityLivingBase)player);
            return true;
        }
        return false;
    }

    @Override
    public int[] getRepairParts() {
        return new int[]{1, 2};
    }

    @Override
    public ToolNBT buildTagData(List<slimeknights.tconstruct.library.materials.Material> materials) {
        HandleMaterialStats handle = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
        HeadMaterialStats head = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        ExtraMaterialStats extra = (ExtraMaterialStats)materials.get(2).getStatsOrUnknown("extra");
        HandleMaterialStats handle2 = (HandleMaterialStats)materials.get(3).getStatsOrUnknown("handle");
        ToolNBT data = new ToolNBT();
        data.head(head);
        data.extra(extra);
        data.handle(handle, handle2);
        data.durability = (int)((float)data.durability * 2.2f);
        return data;
    }
}

