/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tools.IPattern;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.utils.TagUtil;

public class Pattern
extends Item
implements IPattern {
    public static final String TAG_PARTTYPE = "PartType";

    public Pattern() {
        this.func_77637_a((CreativeTabs)TinkerRegistry.tabParts);
        this.func_77627_a(true);
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        subItems.add((Object)new ItemStack((Item)this));
        for (Item toolpart : this.getSubItemToolparts()) {
            ItemStack stack = new ItemStack((Item)this);
            Pattern.setTagForPart(stack, toolpart);
            if (!this.isValidSubitem(toolpart)) continue;
            subItems.add((Object)stack);
        }
    }

    protected Collection<Item> getSubItemToolparts() {
        return TinkerRegistry.getPatternItems();
    }

    protected boolean isValidSubitem(Item toolpart) {
        if (toolpart instanceof IToolPart) {
            for (Material material : TinkerRegistry.getAllMaterials()) {
                if (!this.isValidSubitemMaterial(material) || !((IToolPart)toolpart).canUseMaterial(material)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean isValidSubitemMaterial(Material material) {
        return material.isCraftable();
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        Item part = Pattern.getPartFromTag(stack);
        String unloc = this.func_77657_g(stack);
        if (part == null) {
            return Util.translate(unloc + ".blank", new Object[0]);
        }
        return Util.translateFormatted(unloc + ".name", part.func_77653_i(ItemStack.field_190927_a));
    }

    public static ItemStack setTagForPart(ItemStack stack, Item toolPart) {
        NBTTagCompound tag = TagUtil.getTagSafe(stack);
        tag.func_74778_a(TAG_PARTTYPE, toolPart.getRegistryName().toString());
        stack.func_77982_d(tag);
        return stack;
    }

    @Nullable
    public static Item getPartFromTag(ItemStack stack) {
        NBTTagCompound tag = TagUtil.getTagSafe(stack);
        String part = tag.func_74779_i(TAG_PARTTYPE);
        return Item.func_111206_d((String)part);
    }

    public boolean isBlankPattern(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IPattern)) {
            return false;
        }
        if (!stack.func_77942_o()) {
            return true;
        }
        return Config.reuseStencil || !stack.func_77978_p().func_74764_b(TAG_PARTTYPE);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        Item part = Pattern.getPartFromTag(stack);
        if (part != null && part instanceof IToolPart) {
            float cost = (float)((IToolPart)part).getCost() / 144.0f;
            tooltip.add(Util.translateFormatted("tooltip.pattern.cost", Util.df.format(cost)));
        }
    }

    public static String getTextureIdentifier(Item item) {
        String identifier = item.getRegistryName().toString();
        if (identifier.contains(":")) {
            identifier = identifier.substring(identifier.lastIndexOf(58) + 1);
        }
        return "_" + identifier;
    }
}

