/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tinkering;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.events.TinkerEvent;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.IModifyable;
import slimeknights.tconstruct.library.tinkering.IRepairable;
import slimeknights.tconstruct.library.tinkering.ITinkerable;
import slimeknights.tconstruct.library.tinkering.IndestructibleEntityItem;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolBuilder;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.library.utils.TooltipBuilder;

public abstract class TinkersItem
extends Item
implements ITinkerable,
IModifyable,
IRepairable {
    protected final PartMaterialType[] requiredComponents;
    protected final Set<Category> categories = new THashSet();

    public TinkersItem(PartMaterialType ... requiredComponents) {
        this.requiredComponents = requiredComponents;
        this.func_77625_d(1);
    }

    public List<PartMaterialType> getRequiredComponents() {
        return ImmutableList.copyOf((Object[])this.requiredComponents);
    }

    public List<PartMaterialType> getToolBuildComponents() {
        return this.getRequiredComponents();
    }

    protected void addCategory(Category ... categories) {
        Collections.addAll(this.categories, categories);
    }

    public boolean hasCategory(Category category) {
        return this.categories.contains(category);
    }

    protected Category[] getCategories() {
        Category[] out = new Category[this.categories.size()];
        int i = 0;
        for (Category category : this.categories) {
            out[i++] = category;
        }
        return out;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nonnull
    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        IndestructibleEntityItem entity = new IndestructibleEntityItem(world, location.field_70165_t, location.field_70163_u, location.field_70161_v, itemstack);
        if (location instanceof EntityItem) {
            NBTTagCompound tag = new NBTTagCompound();
            location.func_189511_e(tag);
            entity.func_174867_a(tag.func_74765_d("PickupDelay"));
        }
        entity.field_70159_w = location.field_70159_w;
        entity.field_70181_x = location.field_70181_x;
        entity.field_70179_y = location.field_70179_y;
        return entity;
    }

    public boolean validComponent(int slot, ItemStack stack) {
        if (slot > this.requiredComponents.length || slot < 0) {
            return false;
        }
        return this.requiredComponents[slot].isValid(stack);
    }

    @Nonnull
    public ItemStack buildItemFromStacks(NonNullList<ItemStack> stacks) {
        long itemCount = stacks.stream().filter(stack -> !stack.func_190926_b()).count();
        ArrayList<Material> materials = new ArrayList<Material>(stacks.size());
        if (itemCount != (long)this.requiredComponents.length) {
            return ItemStack.field_190927_a;
        }
        int i = 0;
        while ((long)i < itemCount) {
            if (!this.validComponent(i, (ItemStack)stacks.get(i))) {
                return ItemStack.field_190927_a;
            }
            materials.add(TinkerUtil.getMaterialFromStack((ItemStack)stacks.get(i)));
            ++i;
        }
        return this.buildItem(materials);
    }

    @Nonnull
    public ItemStack buildItem(List<Material> materials) {
        ItemStack tool = new ItemStack((Item)this);
        tool.func_77982_d(this.buildItemNBT(materials));
        return tool;
    }

    public NBTTagCompound buildItemNBT(List<Material> materials) {
        NBTTagCompound basetag = new NBTTagCompound();
        NBTTagCompound toolTag = this.buildTag(materials);
        NBTTagCompound dataTag = this.buildData(materials);
        basetag.func_74782_a("TinkerData", (NBTBase)dataTag);
        basetag.func_74782_a("Stats", (NBTBase)toolTag);
        basetag.func_74782_a("StatsOriginal", (NBTBase)toolTag.func_74737_b());
        TagUtil.setCategories(basetag, this.getCategories());
        this.addMaterialTraits(basetag, materials);
        TinkerEvent.OnItemBuilding.fireEvent(basetag, (ImmutableList<Material>)ImmutableList.copyOf(materials), this);
        return basetag;
    }

    private NBTTagCompound buildData(List<Material> materials) {
        NBTTagCompound base = new NBTTagCompound();
        NBTTagList materialList = new NBTTagList();
        for (Material material : materials) {
            materialList.func_74742_a((NBTBase)new NBTTagString(material.identifier));
        }
        NBTTagList modifierList = new NBTTagList();
        modifierList.func_74742_a((NBTBase)new NBTTagString());
        modifierList.func_74744_a(0);
        base.func_74782_a("Materials", (NBTBase)materialList);
        base.func_74782_a("Modifiers", (NBTBase)modifierList);
        return base;
    }

    @Nonnull
    public ItemStack buildItemForRendering(List<Material> materials) {
        ItemStack tool = new ItemStack((Item)this);
        NBTTagCompound base = new NBTTagCompound();
        base.func_74782_a("TinkerData", (NBTBase)this.buildData(materials));
        tool.func_77982_d(base);
        return tool;
    }

    @Nonnull
    public ItemStack buildItemForRenderingInGui() {
        List<Material> materials = IntStream.range(0, this.getRequiredComponents().size()).mapToObj(this::getMaterialForPartForGuiRendering).collect(Collectors.toList());
        return this.buildItemForRendering(materials);
    }

    @SideOnly(value=Side.CLIENT)
    public Material getMaterialForPartForGuiRendering(int index) {
        return ClientProxy.RenderMaterials[index % ClientProxy.RenderMaterials.length];
    }

    public abstract NBTTagCompound buildTag(List<Material> var1);

    public boolean hasValidMaterials(ItemStack stack) {
        NBTTagList list = TagUtil.getBaseMaterialsTagList(stack);
        List<Material> materials = TinkerUtil.getMaterialsFromTagList(list);
        if (materials.size() != this.requiredComponents.length) {
            return false;
        }
        for (int i = 0; i < materials.size(); ++i) {
            PartMaterialType required = this.requiredComponents[i];
            Material material = materials.get(i);
            if (required.isValidMaterial(material)) continue;
            return false;
        }
        return true;
    }

    public void addMaterialTraits(NBTTagCompound root, List<Material> materials) {
        int size = this.requiredComponents.length;
        if (materials.size() < size) {
            size = materials.size();
        }
        for (int i = 0; i < size; ++i) {
            PartMaterialType required = this.requiredComponents[i];
            Material material = materials.get(i);
            for (ITrait trait : required.getApplicableTraitsForMaterial(material)) {
                ToolBuilder.addTrait(root, trait, material.materialTextColor);
            }
        }
    }

    public int[] getRepairParts() {
        return new int[]{1};
    }

    public float getRepairModifierForPart(int index) {
        return 1.0f;
    }

    @Override
    @Nonnull
    public ItemStack repair(ItemStack repairable, NonNullList<ItemStack> repairItems) {
        int amount;
        if (repairable.func_77952_i() == 0 && !ToolHelper.isBroken(repairable)) {
            return ItemStack.field_190927_a;
        }
        List<Material> materials = TinkerUtil.getMaterialsFromTagList(TagUtil.getBaseMaterialsTagList(repairable));
        if (materials.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        NonNullList<ItemStack> items = Util.deepCopyFixedNonNullList(repairItems);
        boolean foundMatch = false;
        for (int index : this.getRepairParts()) {
            Optional match;
            Material material = materials.get(index);
            if (this.repairCustom(material, items) > 0) {
                foundMatch = true;
            }
            if (!(match = material.matches(items)).isPresent()) continue;
            foundMatch = true;
            while ((match = material.matches(items)).isPresent()) {
                RecipeMatch.removeMatch(items, (RecipeMatch.Match)((RecipeMatch.Match)match.get()));
            }
        }
        if (!foundMatch) {
            return ItemStack.field_190927_a;
        }
        for (int i = 0; i < repairItems.size(); ++i) {
            if (((ItemStack)repairItems.get(i)).func_190926_b() || !ItemStack.func_77989_b((ItemStack)((ItemStack)repairItems.get(i)), (ItemStack)((ItemStack)items.get(i)))) continue;
            return ItemStack.field_190927_a;
        }
        ItemStack item = repairable.func_77946_l();
        while (item.func_77952_i() > 0 && (amount = this.calculateRepairAmount(materials, repairItems)) > 0) {
            ToolHelper.repairTool(item, this.calculateRepair(item, amount));
            NBTTagCompound tag = TagUtil.getExtraTag(item);
            tag.func_74768_a("RepairCount", tag.func_74762_e("RepairCount") + 1);
            TagUtil.setExtraTag(item, tag);
        }
        return item;
    }

    protected int repairCustom(Material material, NonNullList<ItemStack> repairItems) {
        return 0;
    }

    protected int calculateRepairAmount(List<Material> materials, NonNullList<ItemStack> repairItems) {
        HashSet materialsMatched = Sets.newHashSet();
        float durability = 0.0f;
        for (int index : this.getRepairParts()) {
            Material material = materials.get(index);
            if (materialsMatched.contains((Object)material)) continue;
            durability += (float)this.repairCustom(material, repairItems) * this.getRepairModifierForPart(index);
            Optional matchOptional = material.matches(repairItems);
            if (!matchOptional.isPresent()) continue;
            RecipeMatch.Match match = (RecipeMatch.Match)matchOptional.get();
            HeadMaterialStats stats = (HeadMaterialStats)material.getStats("head");
            if (stats == null) continue;
            materialsMatched.add(material);
            durability += (float)stats.durability * (float)match.amount * this.getRepairModifierForPart(index) / 144.0f;
            RecipeMatch.removeMatch(repairItems, (RecipeMatch.Match)match);
        }
        return (int)(durability *= 1.0f + ((float)materialsMatched.size() - 1.0f) / 9.0f);
    }

    protected int calculateRepair(ItemStack tool, int amount) {
        float origDur = TagUtil.getOriginalToolStats((ItemStack)tool).durability;
        float actualDur = ToolHelper.getDurabilityStat(tool);
        float durabilityFactor = actualDur / origDur;
        float increase = (float)amount * Math.min(10.0f, durabilityFactor);
        increase = Math.max(increase, actualDur / 64.0f);
        int modifiersUsed = TagUtil.getBaseModifiersUsed(tool.func_77978_p());
        float mods = 1.0f;
        if (modifiersUsed == 1) {
            mods = 0.95f;
        } else if (modifiersUsed == 2) {
            mods = 0.9f;
        } else if (modifiersUsed >= 3) {
            mods = 0.85f;
        }
        increase *= mods;
        NBTTagCompound tag = TagUtil.getExtraTag(tool);
        int repair = tag.func_74762_e("RepairCount");
        float repairDimishingReturns = (float)(100 - repair / 2) / 100.0f;
        if (repairDimishingReturns < 0.5f) {
            repairDimishingReturns = 0.5f;
        }
        return (int)Math.ceil(increase *= repairDimishingReturns);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        boolean shift = Util.isShiftKeyDown();
        boolean ctrl = Util.isCtrlKeyDown();
        if (!shift && !ctrl) {
            this.getTooltip(stack, tooltip);
            tooltip.add("");
            tooltip.add(Util.translate("tooltip.tool.holdShift", new Object[0]));
            tooltip.add(Util.translate("tooltip.tool.holdCtrl", new Object[0]));
            tooltip.add(TextFormatting.BLUE + I18n.func_74837_a((String)"attribute.modifier.plus.0", (Object[])new Object[]{Util.df.format(ToolHelper.getActualDamage(stack, (EntityLivingBase)playerIn)), I18n.func_74838_a((String)"attribute.name.generic.attackDamage")}));
        } else if (Config.extraTooltips && shift) {
            this.getTooltipDetailed(stack, tooltip);
        } else if (Config.extraTooltips && ctrl) {
            this.getTooltipComponents(stack, tooltip);
        }
    }

    @Override
    public void getTooltip(ItemStack stack, List<String> tooltips) {
        TooltipBuilder.addModifierTooltips(stack, tooltips);
    }

    @Nonnull
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.COMMON;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean func_179215_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("TinkerData")) {
            try {
                ToolBuilder.rebuildTool(nbt, this);
            }
            catch (TinkerGuiException tinkerGuiException) {
                // empty catch block
            }
        }
        return true;
    }
}

