/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.texture;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.client.texture.TinkerTexture;

public abstract class AbstractColoredTexture
extends TinkerTexture {
    protected static Map<String, TextureAtlasSprite> cache = Maps.newHashMap();
    private TextureAtlasSprite baseTexture;
    private String backupTextureLocation;
    private String extra;

    protected AbstractColoredTexture(TextureAtlasSprite baseTexture, String spriteName) {
        super(spriteName);
        this.baseTexture = baseTexture;
        this.backupTextureLocation = baseTexture.func_94215_i();
    }

    protected AbstractColoredTexture(String baseTextureLocation, String spriteName) {
        super(spriteName);
        this.baseTexture = null;
        this.backupTextureLocation = baseTextureLocation;
    }

    public TextureAtlasSprite setSuffix(String suffix) {
        this.extra = suffix;
        this.baseTexture = null;
        return this;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public boolean load(IResourceManager manager, ResourceLocation location) {
        int[][] data;
        this.field_110976_a = Lists.newArrayList();
        this.field_110973_g = 0;
        this.field_110983_h = 0;
        if (this.baseTexture == null || this.baseTexture.func_110970_k() <= 0) {
            this.baseTexture = null;
            if (this.extra != null && !this.extra.isEmpty()) {
                this.baseTexture = this.backupLoadTexture(new ResourceLocation(this.backupTextureLocation + "_" + this.extra), manager);
            }
            if (this.baseTexture == null) {
                this.baseTexture = this.backupLoadTexture(new ResourceLocation(this.backupTextureLocation), manager);
            }
        }
        if (this.baseTexture != null && this.baseTexture.func_110970_k() > 0) {
            this.func_94217_a(this.baseTexture);
            int[][] original = this.baseTexture.func_147965_a(0);
            data = new int[original.length][];
            for (int i = 0; i < original.length; ++i) {
                if (original[i] == null) continue;
                data[i] = Arrays.copyOf(original[i], original[i].length);
            }
        } else {
            this.field_130223_c = 1;
            this.field_130224_d = 1;
            return false;
        }
        this.processData(data);
        if (this.field_110976_a.isEmpty()) {
            this.field_110976_a.add(data);
        }
        return false;
    }

    protected void processData(int[][] data) {
        for (int mipmap = 0; mipmap < data.length; ++mipmap) {
            if (data[mipmap] == null) continue;
            for (int pxCoord = 0; pxCoord < data[mipmap].length; ++pxCoord) {
                data[mipmap][pxCoord] = this.colorPixel(data[mipmap][pxCoord], mipmap, pxCoord);
            }
        }
    }

    protected abstract int colorPixel(int var1, int var2, int var3);

    public static int getPerceptualBrightness(int col) {
        double r = (double)RenderUtil.red(col) / 255.0;
        double g = (double)RenderUtil.green(col) / 255.0;
        double b = (double)RenderUtil.blue(col) / 255.0;
        return AbstractColoredTexture.getPerceptualBrightness(r, g, b);
    }

    public static int getPerceptualBrightness(double r, double g, double b) {
        double brightness = Math.sqrt(0.241 * r * r + 0.691 * g * g + 0.068 * b * b);
        return (int)(brightness * 255.0);
    }

    protected static int mult(int c1, int c2) {
        return (int)((float)c1 * ((float)c2 / 255.0f));
    }

    protected int getX(int pxCoord) {
        return pxCoord % this.field_130223_c;
    }

    protected int getY(int pxCoord) {
        return pxCoord / this.field_130223_c;
    }

    protected int coord(int x, int y) {
        return y * this.field_130223_c + x;
    }

    public static class CacheClearer
    implements IResourceManagerReloadListener {
        public static CacheClearer INSTANCE = new CacheClearer();

        private CacheClearer() {
        }

        public void func_110549_a(@Nonnull IResourceManager resourceManager) {
            cache.clear();
        }
    }
}

