/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import slimeknights.mantle.client.model.TRSRBakedModel;
import slimeknights.tconstruct.library.client.model.BakedMaterialModel;
import slimeknights.tconstruct.library.client.model.BakedToolModel;
import slimeknights.tconstruct.library.client.model.BakedToolModelOverride;
import slimeknights.tconstruct.library.client.model.ModelHelper;
import slimeknights.tconstruct.library.client.model.format.AmmoPosition;
import slimeknights.tconstruct.library.tools.IAmmoUser;

public class BakedBowModel
extends BakedToolModel {
    protected final AmmoPosition ammoPosition;

    public BakedBowModel(IBakedModel parent, BakedMaterialModel[] parts, BakedMaterialModel[] brokenParts, Map<String, IBakedModel> modifierParts, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transform, ImmutableList<BakedToolModelOverride> overrides, AmmoPosition ammoPosition) {
        super(parent, parts, brokenParts, modifierParts, transform, overrides);
        this.ammoPosition = ammoPosition;
    }

    @Override
    @Nonnull
    public ItemOverrideList func_188617_f() {
        return BowItemOverrideList.INSTANCE;
    }

    protected static class CacheKeyAmmo
    extends BakedToolModel.CacheKey {
        final Item ammoItem;
        final int ammoMeta;
        final String ammoData;

        private CacheKeyAmmo(IBakedModel parent, ItemStack stack, ItemStack ammo) {
            super(parent, stack);
            this.ammoItem = ammo.func_77973_b();
            this.ammoMeta = ammo.func_77960_j();
            this.ammoData = this.getDataFromStack(ammo);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CacheKeyAmmo that = (CacheKeyAmmo)o;
            if (this.ammoItem != null ? !this.ammoItem.equals(that.ammoItem) || this.ammoMeta != that.ammoMeta : that.ammoItem != null) {
                return false;
            }
            return this.ammoData != null ? this.ammoData.equals(that.ammoData) : that.ammoData == null;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.ammoItem != null ? this.ammoItem.hashCode() : 0);
            result = 31 * result + (this.ammoData != null ? this.ammoData.hashCode() : 0);
            result = 31 * result + this.ammoMeta;
            return result;
        }
    }

    protected static class BowItemOverrideList
    extends BakedToolModel.ToolItemOverrideList {
        static BowItemOverrideList INSTANCE = new BowItemOverrideList();

        protected BowItemOverrideList() {
        }

        @Override
        protected BakedToolModel.CacheKey getCacheKey(ItemStack stack, BakedToolModel original, World world, EntityLivingBase entityLivingBase) {
            ItemStack ammo;
            BakedToolModel.CacheKey key = super.getCacheKey(stack, original, world, entityLivingBase);
            if (original instanceof BakedBowModel && stack.func_77973_b() instanceof IAmmoUser && !(ammo = ((IAmmoUser)stack.func_77973_b()).getAmmoToRender(stack, entityLivingBase)).func_190926_b()) {
                key = new CacheKeyAmmo((IBakedModel)original, stack, ammo);
            }
            return key;
        }

        @Override
        protected void addExtraQuads(ItemStack stack, BakedToolModel original, ImmutableList.Builder<BakedQuad> quads, World world, EntityLivingBase entityLivingBase) {
            ItemStack ammo;
            if (original instanceof BakedBowModel && stack.func_77973_b() instanceof IAmmoUser && !(ammo = ((IAmmoUser)stack.func_77973_b()).getAmmoToRender(stack, entityLivingBase)).func_190926_b()) {
                AmmoPosition pos = ((BakedBowModel)original).ammoPosition;
                IBakedModel ammoModel = ModelHelper.getBakedModelForItem(ammo, world, entityLivingBase);
                ammoModel = new TRSRBakedModel(ammoModel, pos.pos[0].floatValue(), pos.pos[1].floatValue(), pos.pos[2].floatValue(), pos.rot[0].floatValue() / 180.0f * (float)Math.PI, pos.rot[1].floatValue() / 180.0f * (float)Math.PI, pos.rot[2].floatValue() / 180.0f * (float)Math.PI, 1.0f);
                quads.addAll((Iterable)ammoModel.func_188616_a(null, null, 0L));
            }
        }
    }
}

