/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.book.sectiontransformer;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.gui.book.element.ElementImage;
import slimeknights.mantle.client.gui.book.element.ElementItem;
import slimeknights.mantle.client.gui.book.element.SizedBookElement;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.book.content.ContentListing;
import slimeknights.tconstruct.library.book.content.ContentPageIconList;
import slimeknights.tconstruct.library.book.content.ContentSingleStatMultMaterial;
import slimeknights.tconstruct.library.book.sectiontransformer.SectionTransformer;
import slimeknights.tconstruct.library.materials.Material;

@SideOnly(value=Side.CLIENT)
public class BowMaterialSectionTransformer
extends SectionTransformer {
    public BowMaterialSectionTransformer() {
        super("bowmaterials");
    }

    @Override
    public void transform(BookData book, SectionData data) {
        ContentListing listing = new ContentListing();
        listing.title = book.translate(this.sectionName);
        this.addPage(data, this.sectionName, "", listing);
        if (!Loader.instance().hasReachedState(LoaderState.POSTINITIALIZATION)) {
            return;
        }
        Stream.of("bow", "bowstring", "shaft", "fletching").forEach(type -> {
            int pageIndex = data.pages.size();
            this.generateContent((String)type, data);
            listing.addEntry(this.getStatName((String)type), (PageData)data.pages.get(pageIndex));
        });
    }

    protected String getStatName(String type) {
        return Material.UNKNOWN.getStats(type).getLocalizedName();
    }

    protected List<ContentPageIconList> generateContent(String materialType, SectionData data) {
        List materialList = TinkerRegistry.getAllMaterials().stream().filter(m -> !m.isHidden()).filter(Material::hasItems).filter(material -> material.hasStats(materialType)).collect(Collectors.toList());
        List<ContentPageIconList> contentPages = ContentPageIconList.getPagesNeededForItemCount(materialList.size(), data, this.getStatName(materialType));
        ListIterator<ContentPageIconList> iter = contentPages.listIterator();
        ContentPageIconList currentOverview = iter.next();
        contentPages.forEach(p -> {
            p.maxScale = 1.0f;
        });
        for (List materials : Lists.partition(materialList, (int)3)) {
            ContentSingleStatMultMaterial content = new ContentSingleStatMultMaterial(materials, materialType);
            String id = materialType + "_" + materials.stream().map(Material::getIdentifier).collect(Collectors.joining("_"));
            PageData page = this.addPage(data, id, "single_stat_material", content);
            for (Material material2 : materials) {
                Object icon = material2.getRepresentativeItem() != null ? new ElementItem(0, 0, 1.0f, material2.getRepresentativeItem()) : new ElementImage(ImageData.MISSING);
                if (currentOverview.addLink((SizedBookElement)icon, material2.getLocalizedNameColored(), page)) continue;
                currentOverview = iter.next();
            }
        }
        return contentPages;
    }
}

