/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.block;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.gadgets.tileentity.TileDryingRack;
import slimeknights.tconstruct.gadgets.tileentity.TileItemRack;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.shared.block.BlockTable;

public class BlockRack
extends BlockTable {
    public static final PropertyEnum<BlockLever.EnumOrientation> ORIENTATION = PropertyEnum.func_177709_a((String)"facing", BlockLever.EnumOrientation.class);
    public static final PropertyBool DRYING = PropertyBool.func_177716_a((String)"drying");
    private static final ImmutableMap<BlockLever.EnumOrientation, AxisAlignedBB> BOUNDS;

    public BlockRack() {
        super(Material.field_151575_d);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a((CreativeTabs)TinkerRegistry.tabGadgets);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.NORTH).func_177226_a((IProperty)DRYING, (Comparable)Boolean.valueOf(false)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)BlockRack.createItemstack(this, 0, (Block)Blocks.field_150376_bx, 0));
        list.add((Object)BlockRack.createItemstack(this, 1, (Block)Blocks.field_150376_bx, 0));
    }

    public int func_180651_a(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)DRYING)).booleanValue()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isSideSolid(@Nonnull IBlockState base_state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return side == EnumFacing.UP && ((BlockLever.EnumOrientation)base_state.func_177229_b(ORIENTATION)).func_176852_c() == EnumFacing.UP;
    }

    @Override
    @Nonnull
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        if (((Boolean)this.func_176203_a(meta).func_177229_b((IProperty)DRYING)).booleanValue()) {
            return new TileDryingRack();
        }
        return new TileItemRack();
    }

    @Override
    public boolean openGui(EntityPlayer player, World world, BlockPos pos) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float clickX, float clickY, float clickZ) {
        TileItemRack tileItemRack;
        if (!world.field_72995_K && (tileItemRack = (TileItemRack)world.func_175625_s(pos)) != null) {
            tileItemRack.interact(player);
            world.func_175684_a(pos, (Block)this, 0);
        }
        return true;
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{ORIENTATION, DRYING}, new IUnlistedProperty[]{TEXTURE, INVENTORY, FACING});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState placedOn;
        IBlockState state = this.func_176223_P();
        if ((meta & 1) == 1) {
            state = state.func_177226_a((IProperty)DRYING, (Comparable)Boolean.valueOf(true));
        }
        if ((placedOn = world.func_180495_p(pos.func_177972_a(facing.func_176734_d()))).func_177230_c() == TinkerGadgets.rack) {
            return state.func_177226_a(ORIENTATION, placedOn.func_177229_b(ORIENTATION));
        }
        return state.func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.func_176856_a((EnumFacing)facing.func_176734_d(), (EnumFacing)placer.func_174811_aO()));
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileItemRack) {
            TileItemRack rack = (TileItemRack)te;
            BlockLever.EnumOrientation orientation = (BlockLever.EnumOrientation)state.func_177229_b(ORIENTATION);
            switch (orientation) {
                case NORTH: 
                case EAST: 
                case SOUTH: 
                case WEST: {
                    rack.setFacing(orientation.func_176852_c().func_176734_d());
                    break;
                }
                case UP_X: 
                case DOWN_X: {
                    if (placer.func_174811_aO().func_176740_k() == EnumFacing.Axis.X) break;
                    rack.setFacing(placer.func_174811_aO().func_176746_e());
                    break;
                }
                case UP_Z: 
                case DOWN_Z: {
                    if (placer.func_174811_aO().func_176740_k() == EnumFacing.Axis.Z) break;
                    rack.setFacing(placer.func_174811_aO().func_176746_e());
                }
            }
        }
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.func_176853_a((int)(meta >> 1))).func_177226_a((IProperty)DRYING, (Comparable)Boolean.valueOf((meta & 1) == 1));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((BlockLever.EnumOrientation)state.func_177229_b(ORIENTATION)).func_176855_a() << 1;
        if (((Boolean)state.func_177229_b((IProperty)DRYING)).booleanValue()) {
            i |= 1;
        }
        return i;
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                switch ((BlockLever.EnumOrientation)state.func_177229_b(ORIENTATION)) {
                    case EAST: {
                        return state.func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.WEST);
                    }
                    case WEST: {
                        return state.func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.EAST);
                    }
                    case SOUTH: {
                        return state.func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.NORTH);
                    }
                    case NORTH: {
                        return state.func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.SOUTH);
                    }
                }
                return state;
            }
            case COUNTERCLOCKWISE_90: {
                switch ((BlockLever.EnumOrientation)state.func_177229_b(ORIENTATION)) {
                    case EAST: {
                        return state.func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.NORTH);
                    }
                    case WEST: {
                        return state.func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.SOUTH);
                    }
                    case SOUTH: {
                        return state.func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.EAST);
                    }
                    case NORTH: {
                        return state.func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.WEST);
                    }
                    case UP_Z: {
                        return state.func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.UP_X);
                    }
                    case UP_X: {
                        return state.func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.UP_Z);
                    }
                    case DOWN_X: {
                        return state.func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.DOWN_Z);
                    }
                    case DOWN_Z: {
                        return state.func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.DOWN_X);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch ((BlockLever.EnumOrientation)state.func_177229_b(ORIENTATION)) {
                    case EAST: {
                        return state.func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.SOUTH);
                    }
                    case WEST: {
                        return state.func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.NORTH);
                    }
                    case SOUTH: {
                        return state.func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.WEST);
                    }
                    case NORTH: {
                        return state.func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.EAST);
                    }
                    case UP_Z: {
                        return state.func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.UP_X);
                    }
                    case UP_X: {
                        return state.func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.UP_Z);
                    }
                    case DOWN_X: {
                        return state.func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.DOWN_Z);
                    }
                    case DOWN_Z: {
                        return state.func_177226_a(ORIENTATION, (Comparable)BlockLever.EnumOrientation.DOWN_X);
                    }
                }
            }
        }
        return state;
    }

    @Nonnull
    public IBlockState func_185471_a(@Nonnull IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a(((BlockLever.EnumOrientation)state.func_177229_b(ORIENTATION)).func_176852_c()));
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return (AxisAlignedBB)BOUNDS.get((Object)blockState.func_177229_b(ORIENTATION));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (AxisAlignedBB)BOUNDS.get((Object)state.func_177229_b(ORIENTATION));
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return this.func_185503_a(pos, start, end, blockState.func_185900_c((IBlockAccess)worldIn, pos));
    }

    public boolean func_149740_M(IBlockState state) {
        return state.func_177229_b((IProperty)DRYING) == Boolean.TRUE;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileDryingRack)) {
            return 0;
        }
        return ((TileDryingRack)te).comparatorStrength();
    }

    @Override
    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return false;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)BlockLever.EnumOrientation.DOWN_X, (Object)new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 0.25, 1.0));
        builder.put((Object)BlockLever.EnumOrientation.DOWN_Z, (Object)new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 0.25, 0.625));
        builder.put((Object)BlockLever.EnumOrientation.UP_X, (Object)new AxisAlignedBB(0.375, 0.75, 0.0, 0.625, 1.0, 1.0));
        builder.put((Object)BlockLever.EnumOrientation.UP_Z, (Object)new AxisAlignedBB(0.0, 0.75, 0.375, 1.0, 1.0, 0.625));
        builder.put((Object)BlockLever.EnumOrientation.NORTH, (Object)new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 0.25));
        builder.put((Object)BlockLever.EnumOrientation.SOUTH, (Object)new AxisAlignedBB(0.0, 0.75, 0.75, 1.0, 1.0, 1.0));
        builder.put((Object)BlockLever.EnumOrientation.EAST, (Object)new AxisAlignedBB(0.75, 0.75, 0.0, 1.0, 1.0, 1.0));
        builder.put((Object)BlockLever.EnumOrientation.WEST, (Object)new AxisAlignedBB(0.0, 0.75, 0.0, 0.25, 1.0, 1.0));
        BOUNDS = builder.build();
    }
}

