/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world.model;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import tconstruct.util.ItemHelper;

public class SlimeChannelRender
implements ISimpleBlockRenderingHandler {
    public static int model = RenderingRegistry.getNextAvailableRenderId();
    static final float LIGHT_Y_NEG = 0.5f;
    static final float LIGHT_Y_POS = 1.0f;
    static final float LIGHT_XZ_NEG = 0.8f;
    static final float LIGHT_XZ_POS = 0.6f;

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        if (modelID == model) {
            ItemHelper.renderStandardInvBlock(renderer, block, metadata);
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelID, RenderBlocks renderer) {
        if (modelID == model) {
            this.renderRotatedBlock(block, x, y, z, world, renderer);
            return true;
        }
        return false;
    }

    public boolean renderRotatedBlock(Block block, int x, int y, int z, IBlockAccess world, RenderBlocks renderer) {
        double v3;
        double u3;
        double v4;
        double u4;
        double v1;
        double u1;
        double v2;
        double u2;
        Tessellator tessellator = Tessellator.field_78398_a;
        int bMeta = world.func_72805_g(x, y, z);
        IIcon iconStill = block.func_149691_a(1, bMeta);
        float flowDir = (float)((double)((float)bMeta / 8.0f * 2.0f) * Math.PI);
        if (flowDir < -999.0f) {
            u2 = iconStill.func_94214_a(0.0);
            v2 = iconStill.func_94207_b(0.0);
            u1 = u2;
            v1 = iconStill.func_94207_b(16.0);
            u4 = iconStill.func_94214_a(16.0);
            v4 = v1;
            u3 = u4;
            v3 = v2;
        } else {
            float xFlow = MathHelper.func_76126_a((float)flowDir) * 0.25f;
            float zFlow = MathHelper.func_76134_b((float)flowDir) * 0.25f;
            u2 = iconStill.func_94214_a((double)(8.0f + (-zFlow - xFlow) * 16.0f));
            v2 = iconStill.func_94207_b((double)(8.0f + (-zFlow + xFlow) * 16.0f));
            u1 = iconStill.func_94214_a((double)(8.0f + (-zFlow + xFlow) * 16.0f));
            v1 = iconStill.func_94207_b((double)(8.0f + (zFlow + xFlow) * 16.0f));
            u4 = iconStill.func_94214_a((double)(8.0f + (zFlow + xFlow) * 16.0f));
            v4 = iconStill.func_94207_b((double)(8.0f + (zFlow - xFlow) * 16.0f));
            u3 = iconStill.func_94214_a((double)(8.0f + (zFlow - xFlow) * 16.0f));
            v3 = iconStill.func_94207_b((double)(8.0f + (-zFlow - xFlow) * 16.0f));
        }
        int color = block.func_149720_d(world, x, y, z);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
        tessellator.func_78386_a(1.0f * red, 1.0f * green, 1.0f * blue);
        tessellator.func_78374_a((double)(x + 0), (double)y + 0.5, (double)(z + 0), u2, v2);
        tessellator.func_78374_a((double)(x + 0), (double)y + 0.5, (double)(z + 1), u1, v1);
        tessellator.func_78374_a((double)(x + 1), (double)y + 0.5, (double)(z + 1), u4, v4);
        tessellator.func_78374_a((double)(x + 1), (double)y + 0.5, (double)(z + 0), u3, v3);
        renderer.func_147784_q(block, x, y, z);
        return true;
    }

    public boolean shouldRender3DInInventory(int modelID) {
        return true;
    }

    public int getRenderId() {
        return model;
    }
}

