/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.common.ModelRegisterUtil;
import slimeknights.tconstruct.library.client.renderer.RenderTinkerSlime;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;
import slimeknights.tconstruct.world.block.BlockSlimeSapling;
import slimeknights.tconstruct.world.block.BlockTallSlimeGrass;
import slimeknights.tconstruct.world.client.CustomStateMap;
import slimeknights.tconstruct.world.client.SlimeColorizer;
import slimeknights.tconstruct.world.entity.EntityBlueSlime;

public class WorldClientProxy
extends ClientProxy {
    public static SlimeColorizer slimeColorizer = new SlimeColorizer();
    public static Minecraft minecraft = Minecraft.func_71410_x();

    @Override
    public void preInit() {
        ((IReloadableResourceManager)minecraft.func_110442_L()).func_110542_a((IResourceManagerReloadListener)slimeColorizer);
        RenderingRegistry.registerEntityRenderingHandler(EntityBlueSlime.class, (IRenderFactory)RenderTinkerSlime.FACTORY_BlueSlime);
        super.preInit();
    }

    @Override
    public void init() {
        BlockColors blockColors = minecraft.func_184125_al();
        blockColors.func_186722_a((state, access, pos, tintIndex) -> {
            BlockSlimeGrass.FoliageType type = (BlockSlimeGrass.FoliageType)((Object)((Object)state.func_177229_b(BlockSlimeGrass.FOLIAGE)));
            return this.getSlimeColorByPos(pos, type, null);
        }, new Block[]{TinkerWorld.slimeGrass, TinkerWorld.slimeGrassTall});
        blockColors.func_186722_a((state, access, pos, tintIndex) -> {
            BlockSlimeGrass.FoliageType type = (BlockSlimeGrass.FoliageType)((Object)((Object)state.func_177229_b(BlockSlimeGrass.FOLIAGE)));
            return this.getSlimeColorByPos(pos, type, SlimeColorizer.LOOP_OFFSET);
        }, new Block[]{TinkerWorld.slimeLeaves});
        blockColors.func_186722_a((state, access, pos, tintIndex) -> this.getSlimeColorByPos(pos, BlockSlimeGrass.FoliageType.BLUE, SlimeColorizer.LOOP_OFFSET), new Block[]{TinkerWorld.slimeVineBlue1, TinkerWorld.slimeVineBlue2, TinkerWorld.slimeVineBlue3});
        blockColors.func_186722_a((state, access, pos, tintIndex) -> this.getSlimeColorByPos(pos, BlockSlimeGrass.FoliageType.PURPLE, SlimeColorizer.LOOP_OFFSET), new Block[]{TinkerWorld.slimeVinePurple1, TinkerWorld.slimeVinePurple2, TinkerWorld.slimeVinePurple3});
        minecraft.getItemColors().func_186731_a((stack, tintIndex) -> {
            IBlockState iblockstate = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
            return blockColors.func_186724_a(iblockstate, null, null, tintIndex);
        }, new Block[]{TinkerWorld.slimeGrass, TinkerWorld.slimeGrassTall, TinkerWorld.slimeLeaves, TinkerWorld.slimeVineBlue1, TinkerWorld.slimeVineBlue2, TinkerWorld.slimeVineBlue3, TinkerWorld.slimeVinePurple1, TinkerWorld.slimeVinePurple2, TinkerWorld.slimeVinePurple3});
        super.init();
    }

    @Override
    public void registerModels() {
        ModelLoader.setCustomStateMapper((Block)TinkerWorld.slimeGrass, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockSlimeGrass.FOLIAGE}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)TinkerWorld.slimeLeaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockSlimeGrass.FOLIAGE, BlockLeaves.field_176236_b, BlockLeaves.field_176237_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)TinkerWorld.slimeGrassTall, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockSlimeGrass.FOLIAGE}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)TinkerWorld.slimeSapling, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockSlimeSapling.field_176479_b, BlockSapling.field_176480_a}).func_178441_a());
        CustomStateMap vineMap = new CustomStateMap("slime_vine");
        ModelLoader.setCustomStateMapper((Block)TinkerWorld.slimeVineBlue1, (IStateMapper)vineMap);
        ModelLoader.setCustomStateMapper((Block)TinkerWorld.slimeVinePurple1, (IStateMapper)vineMap);
        vineMap = new CustomStateMap("slime_vine_mid");
        ModelLoader.setCustomStateMapper((Block)TinkerWorld.slimeVineBlue2, (IStateMapper)vineMap);
        ModelLoader.setCustomStateMapper((Block)TinkerWorld.slimeVinePurple2, (IStateMapper)vineMap);
        vineMap = new CustomStateMap("slime_vine_end");
        ModelLoader.setCustomStateMapper((Block)TinkerWorld.slimeVineBlue3, (IStateMapper)vineMap);
        ModelLoader.setCustomStateMapper((Block)TinkerWorld.slimeVinePurple3, (IStateMapper)vineMap);
        ModelRegisterUtil.registerItemBlockMeta((Block)TinkerWorld.slimeDirt);
        Item grass = Item.func_150898_a((Block)TinkerWorld.slimeGrass);
        for (BlockSlimeGrass.FoliageType type : BlockSlimeGrass.FoliageType.values()) {
            for (BlockSlimeGrass.DirtType dirtType : BlockSlimeGrass.DirtType.values()) {
                String variant = String.format("%s=%s,%s=%s", BlockSlimeGrass.field_176498_a.func_177701_a(), BlockSlimeGrass.field_176498_a.func_177702_a(Boolean.valueOf(false)), BlockSlimeGrass.TYPE.func_177701_a(), BlockSlimeGrass.TYPE.func_177702_a((Enum)dirtType));
                int meta = TinkerWorld.slimeGrass.func_176201_c(TinkerWorld.slimeGrass.func_176223_P().func_177226_a(BlockSlimeGrass.TYPE, (Comparable)((Object)dirtType)).func_177226_a(BlockSlimeGrass.FOLIAGE, (Comparable)((Object)type)));
                ModelLoader.setCustomModelResourceLocation((Item)grass, (int)meta, (ModelResourceLocation)new ModelResourceLocation(grass.getRegistryName(), variant));
            }
        }
        Item leaves = Item.func_150898_a((Block)TinkerWorld.slimeLeaves);
        for (BlockSlimeGrass.FoliageType type : BlockSlimeGrass.FoliageType.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)leaves, (int)type.getMeta(), (ModelResourceLocation)new ModelResourceLocation(leaves.getRegistryName(), "normal"));
        }
        IBlockState state = TinkerWorld.slimeSapling.func_176223_P();
        Item sapling = Item.func_150898_a((Block)TinkerWorld.slimeSapling);
        ItemStack stack = new ItemStack(sapling, 1, TinkerWorld.slimeSapling.func_176201_c(state.func_177226_a(BlockSlimeSapling.FOLIAGE, (Comparable)((Object)BlockSlimeGrass.FoliageType.BLUE))));
        this.registerItemModelTiC(stack, "slime_sapling_blue");
        stack = new ItemStack(sapling, 1, TinkerWorld.slimeSapling.func_176201_c(state.func_177226_a(BlockSlimeSapling.FOLIAGE, (Comparable)((Object)BlockSlimeGrass.FoliageType.PURPLE))));
        this.registerItemModelTiC(stack, "slime_sapling_purple");
        stack = new ItemStack(sapling, 1, TinkerWorld.slimeSapling.func_176201_c(state.func_177226_a(BlockSlimeSapling.FOLIAGE, (Comparable)((Object)BlockSlimeGrass.FoliageType.ORANGE))));
        this.registerItemModelTiC(stack, "slime_sapling_orange");
        for (Enum enum_ : BlockSlimeGrass.FoliageType.values()) {
            state = TinkerWorld.slimeGrassTall.func_176223_P();
            state = state.func_177226_a(BlockTallSlimeGrass.FOLIAGE, (Comparable)((Object)enum_));
            state = state.func_177226_a(BlockTallSlimeGrass.TYPE, (Comparable)((Object)BlockTallSlimeGrass.SlimePlantType.TALL_GRASS));
            stack = new ItemStack((Block)TinkerWorld.slimeGrassTall, 1, TinkerWorld.slimeGrassTall.func_176201_c(state));
            this.registerItemModelTiC(stack, "slime_tall_grass");
            state = state.func_177226_a(BlockTallSlimeGrass.TYPE, (Comparable)((Object)BlockTallSlimeGrass.SlimePlantType.FERN));
            stack = new ItemStack((Block)TinkerWorld.slimeGrassTall, 1, TinkerWorld.slimeGrassTall.func_176201_c(state));
            this.registerItemModelTiC(stack, "slime_fern");
        }
        this.registerItemModelTiC(new ItemStack((Block)TinkerWorld.slimeVineBlue1), "slime_vine");
        this.registerItemModelTiC(new ItemStack((Block)TinkerWorld.slimeVineBlue2), "slime_vine_mid");
        this.registerItemModelTiC(new ItemStack((Block)TinkerWorld.slimeVineBlue3), "slime_vine_end");
        this.registerItemModelTiC(new ItemStack((Block)TinkerWorld.slimeVinePurple1), "slime_vine");
        this.registerItemModelTiC(new ItemStack((Block)TinkerWorld.slimeVinePurple2), "slime_vine_mid");
        this.registerItemModelTiC(new ItemStack((Block)TinkerWorld.slimeVinePurple3), "slime_vine_end");
    }

    private int getSlimeColorByPos(BlockPos pos, BlockSlimeGrass.FoliageType type, BlockPos add) {
        if (pos == null) {
            return SlimeColorizer.getColorStatic(type);
        }
        if (add != null) {
            pos = pos.func_177971_a((Vec3i)add);
        }
        return SlimeColorizer.getColorForPos(pos, type);
    }
}

