/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.library.DryingRecipe;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.plugin.jei.CraftingStationRecipeTransferInfo;
import slimeknights.tconstruct.plugin.jei.alloy.AlloyRecipeCategory;
import slimeknights.tconstruct.plugin.jei.alloy.AlloyRecipeChecker;
import slimeknights.tconstruct.plugin.jei.alloy.AlloyRecipeHandler;
import slimeknights.tconstruct.plugin.jei.casting.CastingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.casting.CastingRecipeChecker;
import slimeknights.tconstruct.plugin.jei.casting.CastingRecipeHandler;
import slimeknights.tconstruct.plugin.jei.casting.CastingRecipeWrapper;
import slimeknights.tconstruct.plugin.jei.drying.DryingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.drying.DryingRecipeChecker;
import slimeknights.tconstruct.plugin.jei.drying.DryingRecipeHandler;
import slimeknights.tconstruct.plugin.jei.interpreter.PatternSubtypeInterpreter;
import slimeknights.tconstruct.plugin.jei.interpreter.TableSubtypeInterpreter;
import slimeknights.tconstruct.plugin.jei.interpreter.ToolPartSubtypeInterpreter;
import slimeknights.tconstruct.plugin.jei.smelting.SmeltingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.smelting.SmeltingRecipeChecker;
import slimeknights.tconstruct.plugin.jei.smelting.SmeltingRecipeHandler;
import slimeknights.tconstruct.plugin.jei.table.TableRecipeHandler;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.BlockCasting;
import slimeknights.tconstruct.smeltery.client.GuiSmeltery;
import slimeknights.tconstruct.smeltery.client.GuiTinkerTank;
import slimeknights.tconstruct.smeltery.client.IGuiLiquidTank;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.common.TableRecipeFactory;
import slimeknights.tconstruct.tools.common.block.BlockToolTable;

@mezz.jei.api.JEIPlugin
public class JEIPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelpers;
    private static final int craftOutputSlot = 0;
    private static final int craftInputSlot1 = 1;
    public static ICraftingGridHelper craftingGridHelper;
    public static IRecipeRegistry recipeRegistry;
    public static CastingRecipeCategory castingCategory;

    public void registerItemSubtypes(ISubtypeRegistry registry) {
        TableSubtypeInterpreter tableInterpreter = new TableSubtypeInterpreter();
        PatternSubtypeInterpreter patternInterpreter = new PatternSubtypeInterpreter();
        if (TConstruct.pulseManager.isPulseLoaded("TinkerGadgets")) {
            registry.registerSubtypeInterpreter(Item.func_150898_a((Block)TinkerGadgets.rack), (ISubtypeRegistry.ISubtypeInterpreter)tableInterpreter);
        }
        if (TConstruct.pulseManager.isPulseLoaded("TinkerTools")) {
            registry.registerSubtypeInterpreter(Item.func_150898_a((Block)TinkerTools.toolTables), (ISubtypeRegistry.ISubtypeInterpreter)tableInterpreter);
            registry.registerSubtypeInterpreter(Item.func_150898_a((Block)TinkerTools.toolForge), (ISubtypeRegistry.ISubtypeInterpreter)tableInterpreter);
            ToolPartSubtypeInterpreter toolPartInterpreter = new ToolPartSubtypeInterpreter();
            for (IToolPart part : TinkerRegistry.getToolParts()) {
                if (!(part instanceof Item)) continue;
                registry.registerSubtypeInterpreter((Item)part, (ISubtypeRegistry.ISubtypeInterpreter)toolPartInterpreter);
            }
            registry.registerSubtypeInterpreter((Item)TinkerTools.pattern, (ISubtypeRegistry.ISubtypeInterpreter)patternInterpreter);
        }
        if (TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery")) {
            registry.registerSubtypeInterpreter((Item)TinkerSmeltery.cast, (ISubtypeRegistry.ISubtypeInterpreter)patternInterpreter);
            registry.registerSubtypeInterpreter((Item)TinkerSmeltery.clayCast, (ISubtypeRegistry.ISubtypeInterpreter)patternInterpreter);
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        if (TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery")) {
            castingCategory = new CastingRecipeCategory(guiHelper);
            registry.addRecipeCategories(new IRecipeCategory[]{new SmeltingRecipeCategory(guiHelper), new AlloyRecipeCategory(guiHelper), castingCategory});
        }
        if (TConstruct.pulseManager.isPulseLoaded("TinkerGadgets")) {
            registry.addRecipeCategories(new IRecipeCategory[]{new DryingRecipeCategory(guiHelper)});
        }
    }

    public void register(@Nonnull IModRegistry registry) {
        jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
        if (TConstruct.pulseManager.isPulseLoaded("TinkerTools")) {
            registry.handleRecipes(TableRecipeFactory.TableRecipe.class, (IRecipeWrapperFactory)new TableRecipeHandler(), "minecraft.crafting");
            registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferInfo)new CraftingStationRecipeTransferInfo());
            registry.addRecipeCatalyst((Object)new ItemStack((Block)TinkerTools.toolTables, 1, BlockToolTable.TableTypes.CraftingStation.meta), new String[]{"minecraft.crafting"});
        }
        if (TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery")) {
            registry.handleRecipes(AlloyRecipe.class, (IRecipeWrapperFactory)new AlloyRecipeHandler(), AlloyRecipeCategory.CATEGORY);
            registry.handleRecipes(MeltingRecipe.class, (IRecipeWrapperFactory)new SmeltingRecipeHandler(), SmeltingRecipeCategory.CATEGORY);
            registry.handleRecipes(CastingRecipeWrapper.class, (IRecipeWrapperFactory)new CastingRecipeHandler(), CastingRecipeCategory.CATEGORY);
            registry.addRecipeCatalyst((Object)new ItemStack((Block)TinkerSmeltery.smelteryController), new String[]{SmeltingRecipeCategory.CATEGORY, AlloyRecipeCategory.CATEGORY});
            registry.addRecipeCatalyst((Object)new ItemStack((Block)TinkerSmeltery.castingBlock, 1, BlockCasting.CastingType.TABLE.meta), new String[]{CastingRecipeCategory.CATEGORY});
            registry.addRecipeCatalyst((Object)new ItemStack((Block)TinkerSmeltery.castingBlock, 1, BlockCasting.CastingType.BASIN.meta), new String[]{CastingRecipeCategory.CATEGORY});
            registry.addRecipeCatalyst((Object)new ItemStack(TinkerSmeltery.searedFurnaceController), new String[]{"minecraft.smelting"});
            registry.addRecipes(SmeltingRecipeChecker.getSmeltingRecipes(), SmeltingRecipeCategory.CATEGORY);
            registry.addRecipes(AlloyRecipeChecker.getAlloyRecipes(), AlloyRecipeCategory.CATEGORY);
            registry.addRecipes(CastingRecipeChecker.getCastingRecipes(), CastingRecipeCategory.CATEGORY);
            registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new TinkerGuiTankHandler<GuiTinkerTank>(GuiTinkerTank.class), new TinkerGuiTankHandler<GuiSmeltery>(GuiSmeltery.class)});
        }
        if (TConstruct.pulseManager.isPulseLoaded("TinkerGadgets")) {
            registry.handleRecipes(DryingRecipe.class, (IRecipeWrapperFactory)new DryingRecipeHandler(), DryingRecipeCategory.CATEGORY);
            registry.addRecipes(DryingRecipeChecker.getDryingRecipes(), DryingRecipeCategory.CATEGORY);
            registry.addRecipeCatalyst((Object)BlockTable.createItemstack(TinkerGadgets.rack, 1, (Block)Blocks.field_150376_bx, 0), new String[]{DryingRecipeCategory.CATEGORY});
        }
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        recipeRegistry = jeiRuntime.getRecipeRegistry();
    }

    private static class TinkerGuiTankHandler<T extends GuiContainer>
    implements IAdvancedGuiHandler<T> {
        private Class<T> clazz;

        public TinkerGuiTankHandler(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Nonnull
        public Class<T> getGuiContainerClass() {
            return this.clazz;
        }

        @Nullable
        public Object getIngredientUnderMouse(T guiContainer, int mouseX, int mouseY) {
            return ((IGuiLiquidTank)guiContainer).getFluidStackAtPosition(mouseX, mouseY);
        }
    }
}

