/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import slimeknights.mantle.client.model.BakedSimple;
import slimeknights.mantle.client.model.BakedWrapper;
import slimeknights.tconstruct.library.client.model.BakedMaterialModel;
import slimeknights.tconstruct.library.client.model.BakedToolModelOverride;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class BakedToolModel
extends BakedWrapper.Perspective {
    protected BakedMaterialModel[] parts;
    protected BakedMaterialModel[] brokenParts;
    protected Map<String, IBakedModel> modifierParts;
    protected final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
    protected final ImmutableList<BakedToolModelOverride> overrides;

    public BakedToolModel(IBakedModel parent, BakedMaterialModel[] parts, BakedMaterialModel[] brokenParts, Map<String, IBakedModel> modifierParts, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transform, ImmutableList<BakedToolModelOverride> overrides) {
        super(parent, transform);
        if (parts.length != brokenParts.length) {
            throw new RuntimeException("TinkerModel: Length of Parts and BrokenParts Array has to match");
        }
        this.parts = parts;
        this.brokenParts = brokenParts;
        this.modifierParts = modifierParts;
        this.transforms = transform;
        this.overrides = overrides;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ToolItemOverrideList.INSTANCE;
    }

    protected static class CacheKey {
        final IBakedModel parent;
        final String data;

        protected CacheKey(IBakedModel parent, ItemStack stack) {
            this.parent = parent;
            this.data = this.getDataFromStack(stack);
        }

        protected String getDataFromStack(ItemStack stack) {
            return TagUtil.getTagSafe(stack).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.parent != null ? this.parent != cacheKey.parent : cacheKey.parent != null) {
                return false;
            }
            return this.data != null ? this.data.equals(cacheKey.data) : cacheKey.data == null;
        }

        public int hashCode() {
            int result = this.parent != null ? this.parent.hashCode() : 0;
            result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
            return result;
        }
    }

    protected static class ToolItemOverrideList
    extends ItemOverrideList {
        private Cache<CacheKey, IBakedModel> bakedModelCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
        static ToolItemOverrideList INSTANCE = new ToolItemOverrideList();

        protected ToolItemOverrideList() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            NBTTagCompound baseTag = TagUtil.getBaseTag(stack);
            IBakedModel outputModel = originalModel;
            if (!baseTag.func_82582_d()) {
                BakedToolModel original = this.getBaseModel((BakedToolModel)originalModel, stack, world, entity);
                CacheKey key = this.getCacheKey(stack, original, world, entity);
                try {
                    outputModel = (IBakedModel)this.bakedModelCache.get((Object)key, () -> this.getCompleteModel(stack, world, entity, original));
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
            return outputModel;
        }

        protected CacheKey getCacheKey(ItemStack stack, BakedToolModel original, World world, EntityLivingBase entityLivingBase) {
            return new CacheKey((IBakedModel)original, stack);
        }

        protected IBakedModel getCompleteModel(ItemStack stack, World world, EntityLivingBase entity, BakedToolModel original) {
            ImmutableList.Builder quads = ImmutableList.builder();
            this.addPartQuads(stack, original, (ImmutableList.Builder<BakedQuad>)quads);
            this.addModifierQuads(stack, original, (ImmutableList.Builder<BakedQuad>)quads);
            this.addExtraQuads(stack, original, (ImmutableList.Builder<BakedQuad>)quads, world, entity);
            return new BakedSimple(quads.build(), original.transforms, (IBakedModel)original);
        }

        private BakedToolModel getBaseModel(@Nonnull BakedToolModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            BakedToolModel original = originalModel;
            for (BakedToolModelOverride override : original.overrides) {
                if (!override.matches(stack, world, entity)) continue;
                original = override.bakedToolModel;
            }
            return original;
        }

        private void addPartQuads(ItemStack stack, BakedToolModel original, ImmutableList.Builder<BakedQuad> quads) {
            NBTTagList materials = TagUtil.getBaseMaterialsTagList(stack);
            boolean broken = ToolHelper.isBroken(stack);
            BakedMaterialModel[] parts = original.parts;
            BakedMaterialModel[] brokenParts = original.brokenParts;
            for (int i = 0; i < parts.length; ++i) {
                String id = materials.func_150307_f(i);
                IBakedModel partModel = broken && brokenParts[i] != null ? brokenParts[i].getModelByIdentifier(id) : parts[i].getModelByIdentifier(id);
                quads.addAll((Iterable)partModel.func_188616_a(null, null, 0L));
            }
        }

        private void addModifierQuads(ItemStack stack, BakedToolModel original, ImmutableList.Builder<BakedQuad> quads) {
            NBTTagList modifiers = TagUtil.getBaseModifiersTagList(stack);
            Map<String, IBakedModel> modifierParts = original.modifierParts;
            for (int i = 0; i < modifiers.func_74745_c(); ++i) {
                String modId = modifiers.func_150307_f(i);
                IBakedModel modModel = modifierParts.get(modId);
                if (modModel == null) continue;
                quads.addAll((Iterable)modModel.func_188616_a(null, null, 0L));
            }
        }

        protected void addExtraQuads(ItemStack stack, BakedToolModel original, ImmutableList.Builder<BakedQuad> quads, World world, EntityLivingBase entity) {
        }
    }
}

