/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderHell;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlime;
import slimeknights.tconstruct.world.block.BlockSlimeDirt;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;
import slimeknights.tconstruct.world.worldgen.SlimeIslandGenerator;
import slimeknights.tconstruct.world.worldgen.SlimeLakeGenerator;
import slimeknights.tconstruct.world.worldgen.SlimePlantGenerator;
import slimeknights.tconstruct.world.worldgen.SlimeTreeGenerator;

public class MagmaSlimeIslandGenerator
extends SlimeIslandGenerator {
    public static MagmaSlimeIslandGenerator INSTANCE = new MagmaSlimeIslandGenerator();
    protected SlimeLakeGenerator lakeGenMagma;
    protected SlimePlantGenerator plantGenMagma;
    protected SlimeTreeGenerator treeGenMagma;
    protected IBlockState dirtMagma;
    protected IBlockState grassMagma;

    public MagmaSlimeIslandGenerator() {
        this.air = Blocks.field_150353_l.func_176223_P();
        IBlockState slimeMagma = TinkerWorld.slimeBlockCongealed.func_176223_P().func_177226_a(BlockSlime.TYPE, (Comparable)((Object)BlockSlime.SlimeType.MAGMA));
        IBlockState slimeBlood = TinkerWorld.slimeBlockCongealed.func_176223_P().func_177226_a(BlockSlime.TYPE, (Comparable)((Object)BlockSlime.SlimeType.BLOOD));
        this.dirtMagma = TinkerWorld.slimeDirt.func_176223_P().func_177226_a(BlockSlimeDirt.TYPE, (Comparable)((Object)BlockSlimeDirt.DirtType.MAGMA));
        this.grassMagma = TinkerWorld.slimeGrass.getStateFromDirt(this.dirtMagma).func_177226_a(BlockSlimeGrass.FOLIAGE, (Comparable)((Object)BlockSlimeGrass.FoliageType.ORANGE));
        this.lakeGenMagma = new SlimeLakeGenerator(Blocks.field_150353_l.func_176223_P(), slimeMagma, slimeMagma, slimeMagma, slimeMagma, slimeMagma, slimeBlood);
        this.treeGenMagma = new SlimeTreeGenerator(5, 4, slimeMagma, TinkerWorld.slimeLeaves.func_176223_P().func_177226_a(BlockSlimeGrass.FOLIAGE, (Comparable)((Object)BlockSlimeGrass.FoliageType.ORANGE)), null);
        this.plantGenMagma = new SlimePlantGenerator(BlockSlimeGrass.FoliageType.ORANGE, false);
    }

    @Override
    protected String getDataName() {
        return "MagmaIslands";
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int z;
        if (!Config.genSlimeIslands) {
            return;
        }
        if (world.func_175624_G() == WorldType.field_77138_c && !Config.genIslandsInSuperflat) {
            return;
        }
        if (!(chunkGenerator instanceof ChunkProviderHell)) {
            return;
        }
        if (random.nextInt(Config.magmaIslandsRate) > 0) {
            return;
        }
        int y = 31;
        int x = chunkX * 16 + 7 + random.nextInt(6) - 3;
        BlockPos pos = new BlockPos(x, y, z = chunkZ * 16 + 7 + random.nextInt(6) - 3);
        if (this.isLava(world, pos) && this.isLava(world, pos.func_177978_c()) && this.isLava(world, pos.func_177974_f()) && this.isLava(world, pos.func_177968_d()) && this.isLava(world, pos.func_177976_e())) {
            this.generateIsland(random, world, x, z, y + 1, this.dirtMagma, this.grassMagma, null, this.lakeGenMagma, this.treeGenMagma, this.plantGenMagma);
        }
    }

    private boolean isLava(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == Blocks.field_150353_l;
    }
}

