/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.traits;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.world.World;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.shared.client.ParticleEffect;
import slimeknights.tconstruct.tools.TinkerTools;

public class TraitShocking
extends AbstractTrait {
    public TraitShocking() {
        super("shocking", 0xFFFFFF);
    }

    @Override
    public void onHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, boolean isCritical) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        NBTTagCompound tag = TinkerUtil.getModifierTag(tool, this.identifier);
        Data data = Data.read(tag);
        if (data.charge >= 100.0f && TraitShocking.attackEntitySecondary((DamageSource)new EntityDamageSource("lightningBolt", (Entity)player), 5.0f, (Entity)target, false, true, false)) {
            TinkerTools.proxy.spawnEffectParticle(ParticleEffect.Type.HEART_ELECTRO, target, 5);
            if (player instanceof EntityPlayerMP) {
                Sounds.playSoundForAll((Entity)player, Sounds.shocking_discharge, 2.0f, 1.0f);
            }
            data.charge = 0.0f;
            NBTTagList tagList = TagUtil.getModifiersTagList(tool);
            int index = TinkerUtil.getIndexInCompoundList(tagList, this.identifier);
            data.write(tag);
            tagList.func_150304_a(index, (NBTBase)tag);
            TagUtil.setModifiersTagList(tool, tagList);
            TagUtil.setEnchantEffect(tool, false);
        }
    }

    @Override
    public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!isSelected || world.field_72995_K) {
            return;
        }
        NBTTagList tagList = TagUtil.getModifiersTagList(tool);
        int index = TinkerUtil.getIndexInCompoundList(tagList, this.identifier);
        NBTTagCompound tag = tagList.func_150305_b(index);
        Data data = Data.read(tag);
        if (data.charge >= 100.0f) {
            return;
        }
        double dx = entity.field_70165_t - data.x;
        double dy = entity.field_70163_u - data.y;
        double dz = entity.field_70161_v - data.z;
        double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (dist < (double)0.1f) {
            return;
        }
        if (dist > 5.0) {
            dist = 5.0;
        }
        data.charge = (float)((double)data.charge + dist * 2.0);
        if (data.charge >= 100.0f) {
            TagUtil.setEnchantEffect(tool, true);
            if (entity instanceof EntityPlayerMP) {
                Sounds.PlaySoundForPlayer(entity, Sounds.shocking_charged, 1.0f, 0.8f + 0.2f * random.nextFloat());
            }
        }
        data.x = entity.field_70165_t;
        data.y = entity.field_70163_u;
        data.z = entity.field_70161_v;
        data.write(tag);
        tagList.func_150304_a(index, (NBTBase)tag);
        TagUtil.setModifiersTagList(tool, tagList);
    }

    public static class Data {
        float charge;
        double x;
        double y;
        double z;

        public static Data read(NBTTagCompound tag) {
            Data data = new Data();
            data.charge = tag.func_74760_g("charge");
            data.x = tag.func_74769_h("x");
            data.y = tag.func_74769_h("y");
            data.z = tag.func_74769_h("z");
            return data;
        }

        public void write(NBTTagCompound tag) {
            tag.func_74776_a("charge", this.charge);
            tag.func_74780_a("x", this.x);
            tag.func_74780_a("y", this.y);
            tag.func_74780_a("z", this.z);
        }
    }
}

