/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class ModReinforced
extends ModifierTrait {
    public ModReinforced() {
        super("reinforced", 5254787, 7, 0);
    }

    @Override
    public int onToolDamage(ItemStack tool, int damage, int newDamage, EntityLivingBase entity) {
        NBTTagCompound tag = TinkerUtil.getModifierTag(tool, this.identifier);
        ModifierNBT data = ModifierNBT.readTag(tag);
        float chance = (float)data.level * 0.15f;
        if (chance >= random.nextFloat()) {
            newDamage -= damage;
        }
        return Math.max(0, newDamage);
    }

    @Override
    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        String key;
        ModifierNBT data = ModifierNBT.readTag(modifierTag);
        if (data.level == this.maxLevel && I18n.func_94522_b((String)(key = String.format("modifier.%s.unbreakable", this.getIdentifier())))) {
            return Util.translate(key, new Object[0]);
        }
        return super.getTooltip(modifierTag, detailed);
    }
}

