/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.shared.client.ParticleEffect;
import slimeknights.tconstruct.tools.TinkerTools;

public class ModFiery
extends ModifierTrait {
    public ModFiery() {
        super("fiery", 15375922, 5, 25);
    }

    @Override
    public void onHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, boolean isCritical) {
        this.dealFireDamage(tool, target);
    }

    protected void dealFireDamage(ItemStack tool, EntityLivingBase target) {
        NBTTagCompound tag = TinkerUtil.getModifierTag(tool, this.identifier);
        ModifierNBT.IntegerNBT data = ModifierNBT.readInteger(tag);
        int duration = this.getFireDuration(data);
        target.func_70015_d(duration);
        float fireDamage = this.getFireDamage(data);
        if (ModFiery.attackEntitySecondary(DamageSource.field_76372_a, fireDamage, (Entity)target, false, true)) {
            int count = Math.round(fireDamage);
            TinkerTools.proxy.spawnEffectParticle(ParticleEffect.Type.HEART_FIRE, target, count);
        }
    }

    private float getFireDamage(ModifierNBT.IntegerNBT data) {
        return (float)data.current / 15.0f;
    }

    private int getFireDuration(ModifierNBT.IntegerNBT data) {
        return 1 + data.current / 8;
    }

    @Override
    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        String loc = String.format("modifier.%s.extra", this.getIdentifier());
        ModifierNBT.IntegerNBT data = ModifierNBT.readInteger(modifierTag);
        int duration = this.getFireDuration(data);
        float dmg = this.getFireDamage(data);
        return ImmutableList.of((Object)Util.translateFormatted(loc, Util.df.format(dmg)), (Object)Util.translateFormatted(loc + 2, Util.df.format(duration)));
    }
}

