/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ProjectileCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.entity.EntityShuriken;

public class Shuriken
extends ProjectileCore {
    private static PartMaterialType shurikenPMT = new PartMaterialType(TinkerTools.knifeBlade, "head", "extra");

    public Shuriken() {
        super(shurikenPMT, shurikenPMT, shurikenPMT, shurikenPMT);
        this.addCategory(Category.NO_MELEE, Category.PROJECTILE);
    }

    @Override
    public float damagePotential() {
        return 0.5f;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (ToolHelper.isBroken(itemStackIn)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemStackIn);
        }
        int damage = itemStackIn.func_77952_i();
        ItemStack reference = itemStackIn.func_77946_l();
        reference.field_77994_a = 1;
        if (!playerIn.field_71075_bZ.field_75098_d) {
            ToolHelper.damageTool(itemStackIn, 1, (EntityLivingBase)playerIn);
        }
        playerIn.func_184811_cZ().func_185145_a(itemStackIn.func_77973_b(), 4);
        if (!worldIn.field_72995_K) {
            if (damage == itemStackIn.func_77952_i()) {
                reference.field_77994_a = 0;
            }
            EntityShuriken projectile = new EntityShuriken(worldIn, playerIn, 1.9f, 0.0f, reference);
            worldIn.func_72838_d((Entity)projectile);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    @Override
    public NBTTagCompound buildTag(List<Material> materials) {
        ToolNBT data = new ToolNBT();
        data.head((HeadMaterialStats)materials.get(0).getStatsOrUnknown("head"), (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head"), (HeadMaterialStats)materials.get(2).getStatsOrUnknown("head"), (HeadMaterialStats)materials.get(3).getStatsOrUnknown("head"));
        data.extra((ExtraMaterialStats)materials.get(0).getStatsOrUnknown("extra"), (ExtraMaterialStats)materials.get(1).getStatsOrUnknown("extra"), (ExtraMaterialStats)materials.get(2).getStatsOrUnknown("extra"), (ExtraMaterialStats)materials.get(3).getStatsOrUnknown("extra"));
        data.modifiers = 3;
        data.attack += 1.0f;
        return data.get();
    }
}

