/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.client.particle.Particles;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.shared.client.ParticleEffect;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.BroadSword;

public class Rapier
extends ToolCore {
    public Rapier() {
        super(PartMaterialType.handle(TinkerTools.toolRod), PartMaterialType.head(TinkerTools.swordBlade), PartMaterialType.extra(TinkerTools.crossGuard));
        this.addCategory(Category.WEAPON);
    }

    @Override
    public boolean isEffective(IBlockState block) {
        return BroadSword.effective_materials.contains((Object)block.func_185904_a());
    }

    @Override
    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (state.func_177230_c() == Blocks.field_150321_G) {
            return super.func_150893_a(stack, state) * 7.5f;
        }
        return super.func_150893_a(stack, state);
    }

    @Override
    public float damagePotential() {
        return 0.55f;
    }

    @Override
    public float damageCutoff() {
        return 13.0f;
    }

    @Override
    public double attackSpeed() {
        return 3.0;
    }

    @Override
    public float knockback() {
        return 0.6f;
    }

    @Override
    public boolean dealDamage(ItemStack stack, EntityLivingBase player, EntityLivingBase entity, float damage) {
        boolean hit = player instanceof EntityPlayer ? this.dealHybridDamage(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)player)), entity, damage) : this.dealHybridDamage(DamageSource.func_76358_a((EntityLivingBase)player), entity, damage);
        if (hit && this.readyForSpecialAttack(entity)) {
            TinkerTools.proxy.spawnAttackParticle(Particles.RAPIER_ATTACK, (Entity)player, 0.8);
        }
        return hit;
    }

    private boolean dealHybridDamage(DamageSource source, EntityLivingBase target, float damage) {
        boolean hit = target.func_70097_a(source, damage / 2.0f);
        if (hit) {
            target.field_70172_ad = 0;
            target.field_110153_bc = 0.0f;
            target.func_70097_a(source.func_76348_h(), damage / 2.0f);
            int count = Math.round(damage / 2.0f);
            if (count > 0) {
                TinkerTools.proxy.spawnEffectParticle(ParticleEffect.Type.HEART_ARMOR, target, count);
            }
        }
        return hit;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack itemStackIn, World worldIn, EntityPlayer player, EnumHand hand) {
        if (player.field_70122_E) {
            player.func_71020_j(0.1f);
            player.field_70181_x += 0.32;
            float f = 0.5f;
            player.field_70159_w = MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * f;
            player.field_70179_y = -MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * f;
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    @Override
    public NBTTagCompound buildTag(List<Material> materials) {
        ToolNBT data = this.buildDefaultTag(materials);
        data.durability = (int)((float)data.durability * 0.8f);
        return data.get();
    }
}

